/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.ApproximateCountDistinctAggregation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestApproximateCountDistinctAggregations {
    @Test
    public void testStandardErrorToBuckets() {
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0326), (int)1024);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0325), (int)1024);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0324), (int)2048);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0231), (int)2048);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.023), (int)2048);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0229), (int)4096);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0164), (int)4096);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0163), (int)4096);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0162), (int)8192);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0116), (int)8192);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0115), (int)8192);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0114), (int)16384);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008126), (int)16384);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008125), (int)16384);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008124), (int)32768);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00576), (int)32768);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00575), (int)32768);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00574), (int)65536);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040626), (int)65536);
        Assert.assertEquals((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040625), (int)65536);
    }

    @Test
    public void testStandardErrorToBucketsBounds() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040624)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.26001)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }
}

