/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.operator.aggregation.groupby.AggregationTestInput;
import io.trino.operator.aggregation.groupby.AggregationTestInputBuilder;
import io.trino.operator.aggregation.groupby.AggregationTestOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestArrayAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testEmpty() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), null, new Block[]{BlockAssertions.createLongsBlock(new Long[0])});
    }

    @Test
    public void testNullOnly() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), Arrays.asList(null, null, null), new Block[]{BlockAssertions.createLongsBlock(null, null, null)});
    }

    @Test
    public void testNullPartial() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), Arrays.asList(null, 2L, null, 3L, null), new Block[]{BlockAssertions.createLongsBlock(null, 2L, null, 3L, null)});
    }

    @Test
    public void testBoolean() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}), Arrays.asList(true, false), new Block[]{BlockAssertions.createBooleansBlock(true, false)});
    }

    @Test
    public void testBigInt() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), Arrays.asList(2L, 1L, 2L), new Block[]{BlockAssertions.createLongsBlock(2L, 1L, 2L)});
    }

    @Test
    public void testVarchar() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}), Arrays.asList("hello", "world"), new Block[]{BlockAssertions.createStringsBlock("hello", "world")});
    }

    @Test
    public void testDate() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DateType.DATE}), Arrays.asList(new SqlDate(1), new SqlDate(2), new SqlDate(4)), new Block[]{BlockAssertions.createTypedLongsBlock((Type)DateType.DATE, (Iterable<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)4L))});
    }

    @Test
    public void testArray() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "array_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)}), Arrays.asList(Arrays.asList(1L), Arrays.asList(1L, 2L), Arrays.asList(1L, 2L, 3L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))});
    }

    @Test
    public void testEmptyStateOutputsNull() {
        TestingAggregationFunction bigIntAgg = FUNCTION_RESOLUTION.getAggregateFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        GroupedAggregator groupedAggregator = bigIntAgg.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of(), OptionalInt.empty()).createGroupedAggregator();
        BlockBuilder blockBuilder = bigIntAgg.getFinalType().createBlockBuilder(null, 1000);
        groupedAggregator.evaluate(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.build().isNull(0));
    }

    @Test
    public void testWithMultiplePages() {
        TestingAggregationFunction varcharAgg = FUNCTION_RESOLUTION.getAggregateFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{BlockAssertions.createStringsBlock("hello", "world", "hello2", "world2", "hello3", "world3", "goodbye")}, varcharAgg);
        AggregationTestOutput testOutput = new AggregationTestOutput(ImmutableList.of((Object)"hello", (Object)"world", (Object)"hello2", (Object)"world2", (Object)"hello3", (Object)"world3", (Object)"goodbye"));
        AggregationTestInput testInput = testInputBuilder.build();
        testInput.runPagesOnAggregatorWithAssertion(0, varcharAgg.getFinalType(), testInput.createGroupedAggregator(), testOutput);
    }

    @Test
    public void testMultipleGroupsWithMultiplePages() {
        TestingAggregationFunction varcharAgg = FUNCTION_RESOLUTION.getAggregateFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        ValueBlock block1 = BlockAssertions.createStringsBlock("a", "b", "c", "d", "e");
        ValueBlock block2 = BlockAssertions.createStringsBlock("f", "g", "h", "i", "j");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"));
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, varcharAgg);
        AggregationTestInput test1 = testInputBuilder1.build();
        GroupedAggregator groupedAggregator = test1.createGroupedAggregator();
        test1.runPagesOnAggregatorWithAssertion(0, varcharAgg.getFinalType(), groupedAggregator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableList.of((Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j"));
        AggregationTestInputBuilder testBuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, varcharAgg);
        AggregationTestInput test2 = testBuilder2.build();
        test2.runPagesOnAggregatorWithAssertion(255, varcharAgg.getFinalType(), groupedAggregator, aggregationTestOutput2);
    }

    @Test
    public void testManyValues() {
        TestingAggregationFunction varcharAgg = FUNCTION_RESOLUTION.getAggregateFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        int numGroups = 50000;
        int arraySize = 30;
        Random random = new Random();
        GroupedAggregator groupedAggregator = varcharAgg.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0), OptionalInt.empty()).createGroupedAggregator();
        for (int j = 0; j < numGroups; ++j) {
            ArrayList<String> expectedValues = new ArrayList<String>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < arraySize; ++i) {
                String str = String.valueOf(random.nextInt());
                valueList.add(str);
                expectedValues.add(str);
            }
            ValueBlock block = BlockAssertions.createStringsBlock(valueList);
            AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{block}, varcharAgg);
            AggregationTestInput test1 = testInputBuilder.build();
            test1.runPagesOnAggregatorWithAssertion(j, varcharAgg.getFinalType(), groupedAggregator, new AggregationTestOutput(expectedValues));
        }
    }
}

