/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.SequencePageBuilder;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.SkewedPartitionFunction;
import io.trino.operator.output.SkewedPartitionRebalancer;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSkewedPartitionRebalancer {
    private static final long MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private static final long MIN_DATA_PROCESSED_REBALANCE_THRESHOLD = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private static final int MAX_REBALANCED_PARTITIONS = 30;

    TestSkewedPartitionRebalancer() {
    }

    @Test
    void testRebalanceWithSkewness() {
        int partitionCount = 3;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 3, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)3, (Object)6, (Object)9, (Object)12, (Object)15)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4, (Object)7, (Object)10, (Object)13, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)8, (Object)11, (Object)14))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)2, (Object)4, (Object)6, (Object)8, (Object)10, (Object)12, (Object)14, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)7, (Object)9, (Object)13, (Object)15)), new IntArrayList((Collection)ImmutableList.of((Object)5, (Object)11))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)2, (Object)0)});
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)2, (Object)4, (Object)9, (Object)11, (Object)13)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)10, (Object)12, (Object)14)), new IntArrayList((Collection)ImmutableList.of((Object)6, (Object)7, (Object)8, (Object)15, (Object)16))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1, (Object)2), ImmutableList.of((Object)1, (Object)0, (Object)2), ImmutableList.of((Object)2, (Object)0, (Object)1)});
    }

    @Test
    void testRebalanceWithoutSkewness() {
        int partitionCount = 6;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 2, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 700L);
        rebalancer.addPartitionRowCount(2, 600L);
        rebalancer.addPartitionRowCount(3, 1000L);
        rebalancer.addPartitionRowCount(4, 700L);
        rebalancer.addPartitionRowCount(5, 600L);
        rebalancer.addDataProcessed(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 6)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)3)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2), ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
    }

    @Test
    void testNoRebalanceWhenDataWrittenIsLessThanTheRebalanceLimit() {
        int partitionCount = 3;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 3, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 0L);
        rebalancer.addPartitionRowCount(2, 0L);
        rebalancer.addDataProcessed(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 6)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)3)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
    }

    @Test
    void testNoRebalanceWhenDataWrittenByThePartitionIsLessThanWriterScalingMinDataProcessed() {
        int partitionCount = 3;
        long minPartitionDataProcessedRebalanceThreshold = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 3, minPartitionDataProcessedRebalanceThreshold, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 600L);
        rebalancer.addPartitionRowCount(2, 0L);
        rebalancer.addDataProcessed(DataSize.of((long)60L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 6)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)3)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
    }

    @Test
    void testRebalancePartitionToSingleTaskInARebalancingLoop() {
        int partitionCount = 3;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 3, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 0L);
        rebalancer.addPartitionRowCount(2, 0L);
        rebalancer.addDataProcessed(DataSize.of((long)60L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)6, (Object)12)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)4, (Object)7, (Object)9, (Object)10, (Object)13, (Object)15, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)8, (Object)11, (Object)14))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 0L);
        rebalancer.addPartitionRowCount(2, 0L);
        rebalancer.addDataProcessed(DataSize.of((long)60L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)9)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)4, (Object)7, (Object)10, (Object)12, (Object)13, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)6, (Object)8, (Object)11, (Object)14, (Object)15))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1, (Object)2), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
    }

    @Test
    public void testConsiderSkewedPartitionOnlyWithinACycle() {
        int partitionCount = 3;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 1, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 30);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 800L);
        rebalancer.addPartitionRowCount(2, 0L);
        rebalancer.addDataProcessed(DataSize.of((long)60L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)6, (Object)12)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4, (Object)7, (Object)10, (Object)13, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)3, (Object)5, (Object)8, (Object)9, (Object)11, (Object)14, (Object)15))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        rebalancer.addPartitionRowCount(0, 0L);
        rebalancer.addPartitionRowCount(1, 800L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)60L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)2, (Object)6, (Object)8, (Object)12, (Object)14)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4, (Object)7, (Object)10, (Object)13, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)3, (Object)5, (Object)9, (Object)11, (Object)15))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2), ImmutableList.of((Object)1), ImmutableList.of((Object)2, (Object)0)});
    }

    @Test
    public void testRebalancePartitionWithMaxRebalancedPartitionsPerTask() {
        int partitionCount = 3;
        SkewedPartitionRebalancer rebalancer = new SkewedPartitionRebalancer(partitionCount, 3, 3, MIN_PARTITION_DATA_PROCESSED_REBALANCE_THRESHOLD, MIN_DATA_PROCESSED_REBALANCE_THRESHOLD, 2);
        SkewedPartitionFunction function = new SkewedPartitionFunction((PartitionFunction)new TestPartitionFunction(partitionCount), rebalancer);
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)3, (Object)6, (Object)9, (Object)12, (Object)15)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)4, (Object)7, (Object)10, (Object)13, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)8, (Object)11, (Object)14))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)4, (Object)6, (Object)10, (Object)12, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)7, (Object)9, (Object)13, (Object)15)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)8, (Object)11, (Object)14))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)2)});
        rebalancer.addPartitionRowCount(0, 1000L);
        rebalancer.addPartitionRowCount(1, 1000L);
        rebalancer.addPartitionRowCount(2, 1000L);
        rebalancer.addDataProcessed(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rebalancer.rebalance();
        Assertions.assertThat(TestSkewedPartitionRebalancer.getPartitionPositions((PartitionFunction)function, 17)).containsExactly((Object[])new List[]{new IntArrayList((Collection)ImmutableList.of((Object)0, (Object)4, (Object)6, (Object)10, (Object)12, (Object)16)), new IntArrayList((Collection)ImmutableList.of((Object)1, (Object)3, (Object)7, (Object)9, (Object)13, (Object)15)), new IntArrayList((Collection)ImmutableList.of((Object)2, (Object)5, (Object)8, (Object)11, (Object)14))});
        Assertions.assertThat((List)rebalancer.getPartitionAssignments()).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)2)});
    }

    private static List<List<Integer>> getPartitionPositions(PartitionFunction function, int maxPosition) {
        ArrayList<List<Integer>> partitionPositions = new ArrayList<List<Integer>>();
        for (int partition = 0; partition < function.partitionCount(); ++partition) {
            partitionPositions.add(new ArrayList());
        }
        for (int position = 0; position < maxPosition; ++position) {
            int partition = function.getPartition(TestSkewedPartitionRebalancer.dummyPage(), position);
            ((List)partitionPositions.get(partition)).add(position);
        }
        return partitionPositions;
    }

    private static Page dummyPage() {
        return SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 100, 0);
    }

    private record TestPartitionFunction(int partitionCount) implements PartitionFunction
    {
        public int getPartition(Page page, int position) {
            return position % this.partitionCount;
        }
    }
}

