/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestFormatFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s%%", "123")))).isEqualTo("123%");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%.4f", "pi()")))).isEqualTo("3.1416");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%.5f", "pi()")))).isEqualTo("3.14159");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%03d", "8")))).isEqualTo("008");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%-7s,%7s", "'hello'", "'world'")))).isEqualTo("hello  ,  world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%b %B %b", "true", "false", "null")))).isEqualTo("true FALSE false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s %s %s", "true", "false", "null")))).isEqualTo("true false null");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%S %S %S", "true", "false", "null")))).isEqualTo("TRUE FALSE NULL");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%4$s %3$s %2$s %1$s %4$s %3$s %2$s %1$s", "'a'", "'b'", "'c'", "'d'")))).isEqualTo("d c b a d c b a");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s %s %<s %<s", "'a'", "'b'", "'c'", "'d'")))).isEqualTo("a b b b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%2$s %s %<s %s", "'a'", "'b'", "'c'", "'d'")))).isEqualTo("b a a b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%2$s %3$s %1$s", "'a'", "'b'", "'c'", "'d'")))).isEqualTo("b c a");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s %s", "2", "3", "4")))).isEqualTo("2 3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%d", "tinyint '123'")))).isEqualTo("123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%d", "smallint '32123'")))).isEqualTo("32123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%d", "1234567890")))).isEqualTo("1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%d", "1234567890123")))).isEqualTo("1234567890123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%,.2f", "1234567.89")))).isEqualTo("1,234,567.89");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$f %1$.2f", "decimal '9.12345678'")))).isEqualTo("9.12345678 9.123457 9.12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$d %1$x %1$X %1$o", "1234")))).isEqualTo("1234 4d2 4D2 2322");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s", "ipaddress '192.168.88.123'")))).isEqualTo("192.168.88.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s", "ipaddress '2001:db8:0:0:1:0:0:1'")))).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s", "json '[123,\"abc\",true]'")))).isEqualTo("[123,\"abc\",true]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tF %1$tY-%1$tm-%1$td", "date '2001-08-22'")))).isEqualTo("2001-08-22 2001-08-22 2001-08-22");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$tA, %1$tB %1$te, %1$tY", "date '2006-07-04'")))).isEqualTo("Tuesday, July 4, 2006");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tT %1$tr", "time '16:17:13'")))).isEqualTo("16:17:13 16:17:13 04:17:13 PM");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tF %1$tT", "timestamp '1969-07-20 16:17:00'")))).isEqualTo("1969-07-20T16:17 1969-07-20 16:17:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tF %1$tT", "timestamp '1969-07-20 16:17:03'")))).isEqualTo("1969-07-20T16:17:03 1969-07-20 16:17:03");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tc", "cast('1969-07-20 16:17:00 America/New_York' AS timestamp with time zone)")))).isEqualTo("1969-07-20T16:17-04:00[America/New_York] Sun Jul 20 16:17:00 EDT 1969");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%1$s %1$tc", "cast('1969-07-20 20:17:00 UTC' AS timestamp with time zone)")))).isEqualTo("1969-07-20T20:17Z[UTC] Sun Jul 20 20:17:00 UTC 1969");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s", "cast('16:17:13 -05:00' AS time with time zone)")))).isEqualTo("16:17:13.000-05:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.format("%s", "cast('test' AS char(5))")))).isEqualTo("test ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%.4d", "8")::evaluate).hasMessage("Invalid format string: %.4d (IllegalFormatPrecision: 4)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%-02d", "8")::evaluate).hasMessage("Invalid format string: %-02d (IllegalFormatFlags: Flags = '-0')");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%--2d", "8")::evaluate).hasMessage("Invalid format string: %--2d (DuplicateFormatFlags: Flags = '-')");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%+s", "8")::evaluate).hasMessage("Invalid format string: %+s (FormatFlagsConversionMismatch: Conversion = s, Flags = +)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%-s", "8")::evaluate).hasMessage("Invalid format string: %-s (MissingFormatWidth: %-s)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%5n", "8")::evaluate).hasMessage("Invalid format string: %5n (IllegalFormatWidth: 5)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%s %d", "8")::evaluate).hasMessage("Invalid format string: %s %d (MissingFormatArgument: Format specifier '%d')");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%d", "decimal '8'")::evaluate).hasMessage("Invalid format string: %d (IllegalFormatConversion: d != java.math.BigDecimal)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%tT", "current_time")::evaluate).hasMessage("Invalid format string: %tT (IllegalFormatConversion: T != java.lang.String)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.format("%s", "array[8]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:20: Type not supported for formatting: array(integer)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("format", "5", "8")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:17: Type of first argument to format() must be VARCHAR (actual: integer)");
    }

    private QueryAssertions.ExpressionAssertProvider format(String format, String ... arguments) {
        return this.assertions.function("format", (List<String>)ImmutableList.builder().add((Object)"'%s'".formatted(format)).addAll(Arrays.asList(arguments)).build());
    }
}

