/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJsonOutputFunctions {
    private static final String JSON_EXPRESSION = "\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true)";
    private static final String OUTPUT = "{\"key1\":1.0,\"key2\":true,\"key3\":null}";
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testJsonToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varchar\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(OUTPUT);
    }

    @Test
    public void testJsonToVarbinaryUtf8() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varbinary\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)")))).isEqualTo(new SqlVarbinary(OUTPUT.getBytes(StandardCharsets.UTF_8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varbinary_utf8\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)")))).isEqualTo(new SqlVarbinary(OUTPUT.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testJsonToVarbinaryUtf16() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varbinary_utf16\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)")))).isEqualTo(new SqlVarbinary(OUTPUT.getBytes(StandardCharsets.UTF_16LE)));
    }

    @Test
    public void testJsonToVarbinaryUtf32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varbinary_utf32\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)")))).isEqualTo(new SqlVarbinary(OUTPUT.getBytes(Charset.forName("UTF-32LE"))));
    }

    @Test
    public void testQuotesBehavior() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varchar\"(\"$varchar_to_json\"('\"some_text\"', true), TINYINT '1', false)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\"some_text\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varchar\"(\"$varchar_to_json\"('\"some_text\"', true), TINYINT '1', true)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("some_text");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varchar\"(\"$varchar_to_json\"('[\"some_text\"]', true), TINYINT '1', true)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("[\"some_text\"]");
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$json_to_varchar\"(null, TINYINT '1', true)")))).isNull((Type)VarcharType.VARCHAR);
    }
}

