/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.date;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestExtract {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }

    @Test
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM DATE '2020-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MONTH FROM DATE '1960-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(DATE '2020-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("month(DATE '1960-05-10')")))).matches("BIGINT '5'");
    }

    @Test
    public void testWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(DATE '2020-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("week(DATE '1960-05-10')")))).matches("BIGINT '19'");
    }

    @Test
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY FROM DATE '1960-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day(DATE '1960-05-10')")))).matches("BIGINT '10'");
    }

    @Test
    public void testDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM DATE '1960-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_month(DATE '1960-05-10')")))).matches("BIGINT '10'");
    }

    @Test
    public void testDayOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_week(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Test
    public void testDow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOW FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("dow(DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("dow(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Test
    public void testDayOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM DATE '1960-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("day_of_year(DATE '1960-05-10')")))).matches("BIGINT '131'");
    }

    @Test
    public void testDoy() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(DOY FROM DATE '1960-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("doy(DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("doy(DATE '1960-05-10')")))).matches("BIGINT '131'");
    }

    @Test
    public void testQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM DATE '2020-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(QUARTER FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(DATE '2020-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quarter(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Test
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("year_of_week(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }

    @Test
    public void testYow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(YOW FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("yow(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("yow(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }

    @Test
    public void testUnsupported() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(HOUR FROM DATE '2020-05-10')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MINUTE FROM DATE '2020-05-10')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(SECOND FROM DATE '2020-05-10')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM DATE '2020-05-10')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM DATE '2020-05-10')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }
}

