/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.window.WindowAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import java.io.Closeable;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractTestWindowFunction {
    protected LocalQueryRunner queryRunner;

    @BeforeAll
    public final void initTestWindowFunction() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
    }

    @AfterAll
    public final void destroyTestWindowFunction() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    protected void assertWindowQuery(@Language(value="SQL") String sql, MaterializedResult expected) {
        WindowAssertions.assertWindowQuery(sql, expected, this.queryRunner);
    }

    protected void assertUnboundedWindowQuery(@Language(value="SQL") String sql, MaterializedResult expected) {
        this.assertWindowQuery(AbstractTestWindowFunction.unbounded(sql), expected);
    }

    protected void assertWindowQueryWithNulls(@Language(value="SQL") String sql, MaterializedResult expected) {
        WindowAssertions.assertWindowQueryWithNulls(sql, expected, this.queryRunner);
    }

    protected MaterializedResult executeWindowQueryWithNulls(@Language(value="SQL") String sql) {
        return WindowAssertions.executeWindowQueryWithNulls(sql, this.queryRunner);
    }

    protected void assertUnboundedWindowQueryWithNulls(@Language(value="SQL") String sql, MaterializedResult expected) {
        this.assertWindowQueryWithNulls(AbstractTestWindowFunction.unbounded(sql), expected);
    }

    @Language(value="SQL")
    private static String unbounded(@Language(value="SQL") String sql) {
        Preconditions.checkArgument((boolean)sql.endsWith(")"), (Object)"SQL does not end with ')'");
        return sql.substring(0, sql.length() - 1) + " ROWS BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING)";
    }
}

