/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.window.AbstractTestWindowFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import org.junit.jupiter.api.Test;

public class TestAggregateWindowFunction
extends AbstractTestWindowFunction {
    @Test
    public void testCountRowsOrdered() {
        this.assertWindowQuery("count(*) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1L}).row(new Object[]{5, "F", 2L}).row(new Object[]{6, "F", 3L}).row(new Object[]{33, "F", 4L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 2L}).row(new Object[]{4, "O", 3L}).row(new Object[]{7, "O", 4L}).row(new Object[]{32, "O", 5L}).row(new Object[]{34, "O", 6L}).build());
        this.assertWindowQueryWithNulls("count(*) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 1L}).row(new Object[]{5L, "F", 2L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 4L}).row(new Object[]{34L, "O", 1L}).row(new Object[]{null, "O", 2L}).row(new Object[]{1L, null, 1L}).row(new Object[]{7L, null, 2L}).row(new Object[]{null, null, 4L}).row(new Object[]{null, null, 4L}).build());
    }

    @Test
    public void testCountRowsRolling() {
        this.assertWindowQuery("count(*) OVER (ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 1 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 0L}).row(new Object[]{2, "O", 1L}).row(new Object[]{3, "F", 2L}).row(new Object[]{4, "O", 3L}).row(new Object[]{5, "F", 4L}).row(new Object[]{6, "F", 4L}).row(new Object[]{7, "O", 4L}).row(new Object[]{32, "O", 4L}).row(new Object[]{33, "F", 4L}).row(new Object[]{34, "O", 4L}).build());
        this.assertWindowQuery("count(*) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 1 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 0L}).row(new Object[]{5, "F", 1L}).row(new Object[]{6, "F", 2L}).row(new Object[]{33, "F", 3L}).row(new Object[]{1, "O", 0L}).row(new Object[]{2, "O", 1L}).row(new Object[]{4, "O", 2L}).row(new Object[]{7, "O", 3L}).row(new Object[]{32, "O", 4L}).row(new Object[]{34, "O", 4L}).build());
    }

    @Test
    public void testAverageRowsRolling() {
        this.assertWindowQuery("avg(orderkey) OVER (ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 1 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", 1.0}).row(new Object[]{3, "F", 1.5}).row(new Object[]{4, "O", 2.0}).row(new Object[]{5, "F", 2.5}).row(new Object[]{6, "F", 3.5}).row(new Object[]{7, "O", 4.5}).row(new Object[]{32, "O", 5.5}).row(new Object[]{33, "F", 12.5}).row(new Object[]{34, "O", 19.5}).build());
        this.assertWindowQuery("avg(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 1 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", 3.0}).row(new Object[]{6, "F", 4.0}).row(new Object[]{33, "F", 4.666666666666667}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", 1.0}).row(new Object[]{4, "O", 1.5}).row(new Object[]{7, "O", 2.3333333333333335}).row(new Object[]{32, "O", 3.5}).row(new Object[]{34, "O", 11.25}).build());
    }

    @Test
    public void testCountRowsUnordered() {
        this.assertWindowQuery("count(*) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 4L}).row(new Object[]{5, "F", 4L}).row(new Object[]{6, "F", 4L}).row(new Object[]{33, "F", 4L}).row(new Object[]{1, "O", 6L}).row(new Object[]{2, "O", 6L}).row(new Object[]{4, "O", 6L}).row(new Object[]{7, "O", 6L}).row(new Object[]{32, "O", 6L}).row(new Object[]{34, "O", 6L}).build());
        this.assertWindowQueryWithNulls("count(*) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 4L}).row(new Object[]{5L, "F", 4L}).row(new Object[]{6L, "F", 4L}).row(new Object[]{null, "F", 4L}).row(new Object[]{34L, "O", 2L}).row(new Object[]{null, "O", 2L}).row(new Object[]{1L, null, 4L}).row(new Object[]{7L, null, 4L}).row(new Object[]{null, null, 4L}).row(new Object[]{null, null, 4L}).build());
    }

    @Test
    public void testCountValuesOrdered() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1L}).row(new Object[]{5, "F", 2L}).row(new Object[]{6, "F", 3L}).row(new Object[]{33, "F", 4L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 2L}).row(new Object[]{4, "O", 3L}).row(new Object[]{7, "O", 4L}).row(new Object[]{32, "O", 5L}).row(new Object[]{34, "O", 6L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 1L}).row(new Object[]{5L, "F", 2L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 3L}).row(new Object[]{34L, "O", 1L}).row(new Object[]{null, "O", 1L}).row(new Object[]{1L, null, 1L}).row(new Object[]{7L, null, 2L}).row(new Object[]{null, null, 2L}).row(new Object[]{null, null, 2L}).build());
    }

    @Test
    public void testCountValuesUnordered() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 4L}).row(new Object[]{5, "F", 4L}).row(new Object[]{6, "F", 4L}).row(new Object[]{33, "F", 4L}).row(new Object[]{1, "O", 6L}).row(new Object[]{2, "O", 6L}).row(new Object[]{4, "O", 6L}).row(new Object[]{7, "O", 6L}).row(new Object[]{32, "O", 6L}).row(new Object[]{34, "O", 6L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 3L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 3L}).row(new Object[]{34L, "O", 1L}).row(new Object[]{null, "O", 1L}).row(new Object[]{1L, null, 2L}).row(new Object[]{7L, null, 2L}).row(new Object[]{null, null, 2L}).row(new Object[]{null, null, 2L}).build());
    }

    @Test
    public void testSumOrdered() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3L}).row(new Object[]{5, "F", 8L}).row(new Object[]{6, "F", 14L}).row(new Object[]{33, "F", 47L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 3L}).row(new Object[]{4, "O", 7L}).row(new Object[]{7, "O", 14L}).row(new Object[]{32, "O", 46L}).row(new Object[]{34, "O", 80L}).build();
        MaterializedResult expectedNulls = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 3L}).row(new Object[]{5L, "F", 8L}).row(new Object[]{6L, "F", 14L}).row(new Object[]{null, "F", 14L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 1L}).row(new Object[]{7L, null, 8L}).row(new Object[]{null, null, 8L}).row(new Object[]{null, null, 8L}).build();
        String sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE UNBOUNDED PRECEDING)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS UNBOUNDED PRECEDING)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
        sql = "sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)";
        this.assertWindowQuery(sql, expected);
        this.assertWindowQueryWithNulls(sql, expectedNulls);
    }

    @Test
    public void testSumRolling() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS 2 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3L}).row(new Object[]{5, "F", 8L}).row(new Object[]{6, "F", 14L}).row(new Object[]{33, "F", 44L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 3L}).row(new Object[]{4, "O", 7L}).row(new Object[]{7, "O", 13L}).row(new Object[]{32, "O", 43L}).row(new Object[]{34, "O", 73L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 PRECEDING AND 2 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", 3L}).row(new Object[]{33, "F", 8L}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", 1L}).row(new Object[]{7, "O", 3L}).row(new Object[]{32, "O", 7L}).row(new Object[]{34, "O", 13L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 3 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47L}).row(new Object[]{5, "F", 47L}).row(new Object[]{6, "F", 47L}).row(new Object[]{33, "F", 44L}).row(new Object[]{1, "O", 14L}).row(new Object[]{2, "O", 46L}).row(new Object[]{4, "O", 80L}).row(new Object[]{7, "O", 79L}).row(new Object[]{32, "O", 77L}).row(new Object[]{34, "O", 73L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 14L}).row(new Object[]{5, "F", 44L}).row(new Object[]{6, "F", 39L}).row(new Object[]{33, "F", 33L}).row(new Object[]{1, "O", 7L}).row(new Object[]{2, "O", 13L}).row(new Object[]{4, "O", 43L}).row(new Object[]{7, "O", 73L}).row(new Object[]{32, "O", 66L}).row(new Object[]{34, "O", 34L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 FOLLOWING AND 4 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 39L}).row(new Object[]{5, "F", 33L}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 43L}).row(new Object[]{2, "O", 73L}).row(new Object[]{4, "O", 66L}).row(new Object[]{7, "O", 34L}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47L}).row(new Object[]{5, "F", 44L}).row(new Object[]{6, "F", 39L}).row(new Object[]{33, "F", 33L}).row(new Object[]{1, "O", 80L}).row(new Object[]{2, "O", 79L}).row(new Object[]{4, "O", 77L}).row(new Object[]{7, "O", 73L}).row(new Object[]{32, "O", 66L}).row(new Object[]{34, "O", 34L}).build());
    }

    @Test
    public void testSumRollingUnboundedPrecedingNPreceding() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND 0 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3L}).row(new Object[]{5, "F", 8L}).row(new Object[]{6, "F", 14L}).row(new Object[]{33, "F", 47L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 3L}).row(new Object[]{4, "O", 7L}).row(new Object[]{7, "O", 14L}).row(new Object[]{32, "O", 46L}).row(new Object[]{34, "O", 80L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND 2 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", 3L}).row(new Object[]{33, "F", 8L}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", 1L}).row(new Object[]{7, "O", 3L}).row(new Object[]{32, "O", 7L}).row(new Object[]{34, "O", 14L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND 4 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", 1L}).row(new Object[]{34, "O", 3L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND 171 PRECEDING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
    }

    @Test
    public void testSumRollingNFollowingUnboundedFollowing() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 0 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47L}).row(new Object[]{5, "F", 44L}).row(new Object[]{6, "F", 39L}).row(new Object[]{33, "F", 33L}).row(new Object[]{1, "O", 80L}).row(new Object[]{2, "O", 79L}).row(new Object[]{4, "O", 77L}).row(new Object[]{7, "O", 73L}).row(new Object[]{32, "O", 66L}).row(new Object[]{34, "O", 34L}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 33L}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 73L}).row(new Object[]{2, "O", 66L}).row(new Object[]{4, "O", 34L}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 66L}).row(new Object[]{2, "O", 34L}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2179 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
    }

    @Test
    public void testSumCurrentRow() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3L}).row(new Object[]{5, "F", 5L}).row(new Object[]{6, "F", 6L}).row(new Object[]{33, "F", 33L}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 2L}).row(new Object[]{4, "O", 4L}).row(new Object[]{7, "O", 7L}).row(new Object[]{32, "O", 32L}).row(new Object[]{34, "O", 34L}).build();
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE CURRENT ROW)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey RANGE BETWEEN CURRENT ROW AND CURRENT ROW)", expected);
    }

    @Test
    public void testSumEmptyWindow() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build();
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 3 PRECEDING)", expected);
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 4 FOLLOWING AND 3 FOLLOWING)", expected);
    }

    @Test
    public void testSumUnordered() {
        this.assertWindowQuery("sum(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 47L}).row(new Object[]{5, "F", 47L}).row(new Object[]{6, "F", 47L}).row(new Object[]{33, "F", 47L}).row(new Object[]{1, "O", 80L}).row(new Object[]{2, "O", 80L}).row(new Object[]{4, "O", 80L}).row(new Object[]{7, "O", 80L}).row(new Object[]{32, "O", 80L}).row(new Object[]{34, "O", 80L}).build());
        this.assertWindowQueryWithNulls("sum(orderkey) OVER (PARTITION BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 14L}).row(new Object[]{5L, "F", 14L}).row(new Object[]{6L, "F", 14L}).row(new Object[]{null, "F", 14L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 8L}).row(new Object[]{7L, null, 8L}).row(new Object[]{null, null, 8L}).row(new Object[]{null, null, 8L}).build());
    }

    @Test
    public void testSumAllNulls() {
        this.assertWindowQueryWithNulls("sum(orderkey) OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, null, 1L}).row(new Object[]{3L, "F", 3L}).row(new Object[]{5L, "F", 5L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{7L, null, 7L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "F", null}).row(new Object[]{null, "O", null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }
}

