/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.window.AbstractTestWindowFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestRowNumberFunction
extends AbstractTestWindowFunction {
    @Test
    public void testRowNumber() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 1L}).row(new Object[]{2, "O", 2L}).row(new Object[]{3, "F", 3L}).row(new Object[]{4, "O", 4L}).row(new Object[]{5, "F", 5L}).row(new Object[]{6, "F", 6L}).row(new Object[]{7, "O", 7L}).row(new Object[]{32, "O", 8L}).row(new Object[]{33, "F", 9L}).row(new Object[]{34, "O", 10L}).build();
        MaterializedResult expectedWithNulls = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, null, 1L}).row(new Object[]{3L, "F", 2L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 4L}).row(new Object[]{7L, null, 5L}).row(new Object[]{34L, "O", 6L}).row(new Object[]{null, "F", 7L}).row(new Object[]{null, "O", 8L}).row(new Object[]{null, null, 9L}).row(new Object[]{null, null, 10L}).build();
        this.assertWindowQuery("row_number() OVER ()", expected);
        this.assertWindowQuery("row_number() OVER (ORDER BY orderkey)", expected);
        Assert.assertEquals((Collection)this.executeWindowQueryWithNulls("row_number() OVER ()").getMaterializedRows().stream().map(row -> row.getField(2)).collect(Collectors.toList()), (Collection)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object)7L, (Object)8L, (Object)9L, (Object)10L));
        this.assertWindowQueryWithNulls("row_number() OVER (ORDER BY orderkey, orderstatus)", expectedWithNulls);
    }
}

