/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.failuredetector.FailureDetectorConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestFailureDetectorConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FailureDetectorConfig)ConfigAssertions.recordDefaults(FailureDetectorConfig.class)).setExpirationGraceInterval(new Duration(10.0, TimeUnit.MINUTES)).setFailureRatioThreshold(0.1).setHeartbeatInterval(new Duration(500.0, TimeUnit.MILLISECONDS)).setWarmupInterval(new Duration(5.0, TimeUnit.SECONDS)).setEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"failure-detector.expiration-grace-interval", (Object)"5m").put((Object)"failure-detector.warmup-interval", (Object)"60s").put((Object)"failure-detector.heartbeat-interval", (Object)"10s").put((Object)"failure-detector.threshold", (Object)"0.5").put((Object)"failure-detector.enabled", (Object)"false").buildOrThrow();
        FailureDetectorConfig expected = new FailureDetectorConfig().setExpirationGraceInterval(new Duration(5.0, TimeUnit.MINUTES)).setWarmupInterval(new Duration(60.0, TimeUnit.SECONDS)).setHeartbeatInterval(new Duration(10.0, TimeUnit.SECONDS)).setFailureRatioThreshold(0.5).setEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

