/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.operator.BlockedReason;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.server.QueryStateInfo;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestQueryStateInfo {
    @Test
    public void testQueryStateInfo() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(0);
        QueryStateInfo query = QueryStateInfo.createQueuedQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(this.createQueryInfo("query_root_a_x", QueryState.QUEUED, "SELECT 1")), Optional.of(rootAX.getId()), Optional.of(ImmutableList.of((Object)rootAX.getInfo(), (Object)rootA.getInfo(), (Object)root.getInfo())));
        Assert.assertEquals((String)query.getQuery(), (String)"SELECT 1");
        Assert.assertEquals((String)query.getQueryId().toString(), (String)"query_root_a_x");
        Assert.assertEquals((Object)query.getQueryState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query.getProgress(), Optional.empty());
        List chainInfo = (List)query.getPathToRoot().get();
        Assert.assertEquals((int)chainInfo.size(), (int)3);
        ResourceGroupInfo rootAInfo = (ResourceGroupInfo)chainInfo.get(1);
        ResourceGroupInfo expectedRootAInfo = rootA.getInfo();
        Assert.assertEquals((Object)rootAInfo.getId(), (Object)expectedRootAInfo.getId());
        Assert.assertEquals((Object)rootAInfo.getState(), (Object)expectedRootAInfo.getState());
        Assert.assertEquals((int)rootAInfo.getNumRunningQueries(), (int)expectedRootAInfo.getNumRunningQueries());
        Assert.assertEquals((int)rootAInfo.getNumQueuedQueries(), (int)expectedRootAInfo.getNumQueuedQueries());
        ResourceGroupInfo actualRootInfo = (ResourceGroupInfo)chainInfo.get(2);
        ResourceGroupInfo expectedRootInfo = root.getInfo();
        Assert.assertEquals((Object)actualRootInfo.getId(), (Object)expectedRootInfo.getId());
        Assert.assertEquals((Object)actualRootInfo.getState(), (Object)expectedRootInfo.getState());
        Assert.assertEquals((int)actualRootInfo.getNumRunningQueries(), (int)expectedRootInfo.getNumRunningQueries());
        Assert.assertEquals((int)actualRootInfo.getNumQueuedQueries(), (int)expectedRootInfo.getNumQueuedQueries());
    }

    private QueryInfo createQueryInfo(String queryId, QueryState state, String query) {
        return new QueryInfo(new QueryId(queryId), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), state, URI.create("1"), (List)ImmutableList.of((Object)"2", (Object)"3"), query, Optional.empty(), new QueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), DateTime.parse((String)"1991-09-06T05:02-05:30"), DateTime.parse((String)"1991-09-06T06:00-05:30"), new Duration(10.0, TimeUnit.SECONDS), new Duration(8.0, TimeUnit.MINUTES), new Duration(7.0, TimeUnit.MINUTES), new Duration(34.0, TimeUnit.MINUTES), new Duration(9.0, TimeUnit.MINUTES), new Duration(10.0, TimeUnit.MINUTES), new Duration(11.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.SECONDS), new Duration(12.0, TimeUnit.MINUTES), 13, 14, 15, 16, 100, 17, 18, 34, 19, 20.0, 21.0, DataSize.valueOf((String)"21GB"), DataSize.valueOf((String)"22GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"24GB"), DataSize.valueOf((String)"25GB"), DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"27GB"), DataSize.valueOf((String)"28GB"), DataSize.valueOf((String)"29GB"), true, OptionalDouble.of(8.88), OptionalDouble.of(0.0), new Duration(23.0, TimeUnit.MINUTES), new Duration(24.0, TimeUnit.MINUTES), new Duration(25.0, TimeUnit.MINUTES), new Duration(26.0, TimeUnit.MINUTES), new Duration(27.0, TimeUnit.MINUTES), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"271GB"), DataSize.valueOf((String)"272GB"), 281L, 282L, new Duration(28.0, TimeUnit.MINUTES), new Duration(29.0, TimeUnit.MINUTES), DataSize.valueOf((String)"273GB"), DataSize.valueOf((String)"274GB"), 283L, 284L, DataSize.valueOf((String)"28GB"), DataSize.valueOf((String)"29GB"), 30L, 31L, DataSize.valueOf((String)"32GB"), DataSize.valueOf((String)"33GB"), 34L, 35L, new Duration(101.0, TimeUnit.SECONDS), new Duration(102.0, TimeUnit.SECONDS), DataSize.valueOf((String)"36GB"), DataSize.valueOf((String)"37GB"), 38L, 39L, new Duration(103.0, TimeUnit.SECONDS), new Duration(104.0, TimeUnit.SECONDS), DataSize.valueOf((String)"40GB"), DataSize.valueOf((String)"41GB"), (List)ImmutableList.of(), DynamicFilterService.DynamicFiltersStats.EMPTY, (List)ImmutableList.of(), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "42", Optional.empty(), null, null, (List)ImmutableList.of(), (Set)ImmutableSet.of(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), false, Optional.empty(), Optional.of(QueryType.SELECT), RetryPolicy.NONE, false, new NodeVersion("version"));
    }
}

