/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.server.remotetask.Backoff;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestBackoff {
    @Test
    public void testFailureInterval() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assert.assertEquals((long)backoff.getFailureCount(), (long)0L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)1L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        ticker.increment(14L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)2L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)14L);
        ticker.increment(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)3L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)15L);
    }

    @Test
    public void testMinTries() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(3, new Duration(1.0, TimeUnit.NANOSECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assert.assertEquals((long)backoff.getFailureCount(), (long)0L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)1L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        ticker.increment(14L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)2L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)14L);
        ticker.increment(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)3L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)15L);
    }

    @Test
    public void testStartRequest() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(10.0, TimeUnit.MILLISECONDS)));
        ticker.increment(10L, TimeUnit.MICROSECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)1L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        Assert.assertEquals((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS), (long)0L);
        ticker.increment(7L, TimeUnit.SECONDS);
        backoff.startRequest();
        ticker.increment(7L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)2L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)14L);
        Assert.assertEquals((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS), (long)7L);
        ticker.increment(1L, TimeUnit.SECONDS);
        backoff.startRequest();
        ticker.increment(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)3L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)16L);
        Assert.assertEquals((long)backoff.getFailureRequestTimeTotal().roundTo(TimeUnit.SECONDS), (long)8L);
    }

    @Test
    public void testDelay() {
        TestingTicker ticker = new TestingTicker();
        ticker.increment(1L, TimeUnit.NANOSECONDS);
        Backoff backoff = new Backoff(1, new Duration(15.0, TimeUnit.SECONDS), (Ticker)ticker, (List)ImmutableList.of((Object)new Duration(0.0, TimeUnit.SECONDS), (Object)new Duration(1.0, TimeUnit.SECONDS), (Object)new Duration(2.0, TimeUnit.SECONDS), (Object)new Duration(4.0, TimeUnit.SECONDS), (Object)new Duration(8.0, TimeUnit.SECONDS)));
        Assert.assertEquals((long)backoff.getFailureCount(), (long)0L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)1L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        long backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)0L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)2L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)0L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)1L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)3L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)1L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)2L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)4L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)3L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)4L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assert.assertFalse((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)5L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)7L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)8L);
        ticker.increment(backoffDelay, TimeUnit.NANOSECONDS);
        Assert.assertTrue((boolean)backoff.failure());
        Assert.assertEquals((long)backoff.getFailureCount(), (long)6L);
        Assert.assertEquals((long)backoff.getFailureDuration().roundTo(TimeUnit.SECONDS), (long)15L);
        backoffDelay = backoff.getBackoffDelayNanos();
        Assert.assertEquals((long)TimeUnit.NANOSECONDS.toSeconds(backoffDelay), (long)8L);
    }
}

