/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.server.security.PasswordAuthenticatorConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPasswordAuthenticatorConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PasswordAuthenticatorConfig)ConfigAssertions.recordDefaults(PasswordAuthenticatorConfig.class)).setUserMappingPattern(null).setUserMappingFile(null).setPasswordAuthenticatorFiles("etc/password-authenticator.properties"));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path config1 = Files.createTempFile(null, null, new FileAttribute[0]);
        Path config2 = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.password.user-mapping.file", (Object)userMappingFile.toString()).put((Object)"password-authenticator.config-files", (Object)(config1.toString() + "," + config2.toString())).buildOrThrow();
        PasswordAuthenticatorConfig expected = new PasswordAuthenticatorConfig().setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile()).setPasswordAuthenticatorFiles(config1 + "," + config2);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

