/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.spiller.NodeSpillConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestNodeSpillConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSpillConfig)ConfigAssertions.recordDefaults(NodeSpillConfig.class)).setMaxSpillPerNode(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setQueryMaxSpillPerNode(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setSpillCompressionEnabled(false).setSpillEncryptionEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"max-spill-per-node", (Object)"10MB").put((Object)"query-max-spill-per-node", (Object)"15 MB").put((Object)"spill-compression-enabled", (Object)"true").put((Object)"spill-encryption-enabled", (Object)"true").buildOrThrow();
        NodeSpillConfig expected = new NodeSpillConfig().setMaxSpillPerNode(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setQueryMaxSpillPerNode(DataSize.of((long)15L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSpillCompressionEnabled(true).setSpillEncryptionEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

