/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.spi.QueryId;
import io.trino.split.PageSinkId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestPageSinkId {
    private PageSinkId fromTaskId(int stageId, int partitionId, int attemptId) {
        return PageSinkId.fromTaskId((TaskId)new TaskId(new StageId(new QueryId("query"), stageId), partitionId, attemptId));
    }

    @Test
    public void testFromTaskId() {
        PageSinkId pageSinkId = this.fromTaskId(1, 2, 3);
        long expected = 4294967811L;
        Assert.assertEquals((long)pageSinkId.getId(), (long)expected);
    }

    @Test
    public void testFromTaskIdChecks() {
        Assertions.assertThatThrownBy(() -> this.fromTaskId(1, 0x1000000, 3)).hasMessageContaining("partitionId is out of allowable range");
        Assertions.assertThatThrownBy(() -> this.fromTaskId(1, -1, 3)).hasMessageContaining("partitionId is negative");
        Assertions.assertThatThrownBy(() -> this.fromTaskId(1, 2, 256)).hasMessageContaining("attemptId is out of allowable range");
        Assertions.assertThatThrownBy(() -> this.fromTaskId(1, 2, -1)).hasMessageContaining("attemptId is negative");
    }
}

