/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.optimizer.ExpressionOptimizer;
import io.trino.type.JsonType;
import io.trino.util.StructuralTestUtil;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.testng.Assert;

public class TestExpressionOptimizer {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final ExpressionOptimizer optimizer = new ExpressionOptimizer(this.functionResolution.getMetadata(), this.functionResolution.getPlannerContext().getFunctionManager(), SessionTestUtils.TEST_SESSION);

    @Test
    @Timeout(value=10L)
    public void testPossibleExponentialOptimizationTime() {
        ConstantExpression expression = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CallExpression(this.functionResolution.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (List)ImmutableList.of((Object)expression, (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)));
        }
        this.optimizer.optimize((RowExpression)expression);
    }

    @Test
    public void testIfConstantOptimization() {
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant(null, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        CallExpression condition = new CallExpression(this.functionResolution.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (List)ImmutableList.of((Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)condition, 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
    }

    @Test
    public void testCastWithJsonParseOptimization() {
        ResolvedFunction jsonParseFunction = this.functionResolution.resolveFunction("json_parse", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        ResolvedFunction jsonCastFunction = this.functionResolution.getCoercion((Type)JsonType.JSON, (Type)new ArrayType((Type)IntegerType.INTEGER));
        CallExpression jsonCastExpression = new CallExpression(jsonCastFunction, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)jsonParseFunction, (RowExpression[])new RowExpression[]{Expressions.constant((Object)Slices.utf8Slice((String)"[1, 2]"), (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assertions.assertInstanceOf((Object)resultExpression, ConstantExpression.class);
        Object resultValue = ((ConstantExpression)resultExpression).getValue();
        Assertions.assertInstanceOf((Object)resultValue, IntArrayBlock.class);
        Assert.assertEquals(BlockAssertions.toValues((Type)IntegerType.INTEGER, (Block)((IntArrayBlock)resultValue)), (Collection)ImmutableList.of((Object)1, (Object)2));
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)new ArrayType((Type)VarcharType.VARCHAR), "$internal$json_string_to_array_cast");
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), "$internal$json_string_to_map_cast");
        this.testCastWithJsonParseOptimization(jsonParseFunction, (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), "$internal$json_string_to_row_cast");
    }

    private void testCastWithJsonParseOptimization(ResolvedFunction jsonParseFunction, Type targetType, String jsonStringToRowName) {
        ResolvedFunction jsonCastFunction = this.functionResolution.getCoercion((Type)JsonType.JSON, targetType);
        CallExpression jsonCastExpression = new CallExpression(jsonCastFunction, (List)ImmutableList.of((Object)Expressions.call((ResolvedFunction)jsonParseFunction, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((ResolvedFunction)this.functionResolution.getCoercion(GlobalFunctionCatalog.builtinFunctionName((String)jsonStringToRowName), (Type)VarcharType.VARCHAR, targetType), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
    }

    private static RowExpression ifExpression(RowExpression condition, long trueValue, long falseValue) {
        return new SpecialForm(SpecialForm.Form.IF, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)condition, (Object)Expressions.constant((Object)trueValue, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)falseValue, (Type)BigintType.BIGINT)));
    }
}

