/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExpressionVerifier
extends AstVisitor<Boolean, Node> {
    private final SymbolAliases symbolAliases;

    public ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitNode(Node node, Node expectedExpression) {
        throw new IllegalStateException(String.format("Node %s is not supported", node.getClass().getSimpleName()));
    }

    protected Boolean visitGenericLiteral(GenericLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof GenericLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression)) && actual.getType().equals(((GenericLiteral)expectedExpression).getType());
    }

    protected Boolean visitStringLiteral(StringLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof StringLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitLongLiteral(LongLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof LongLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDoubleLiteral(DoubleLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DoubleLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDecimalLiteral(DecimalLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DecimalLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitTimestampLiteral(TimestampLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof TimestampLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitBooleanLiteral(BooleanLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof BooleanLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitNullLiteral(NullLiteral node, Node expectedExpression) {
        return expectedExpression instanceof NullLiteral;
    }

    private static String getValueFromLiteral(Node expression) {
        if (expression instanceof LongLiteral) {
            return String.valueOf(((LongLiteral)expression).getParsedValue());
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof DoubleLiteral) {
            return String.valueOf(((DoubleLiteral)expression).getValue());
        }
        if (expression instanceof DecimalLiteral) {
            return String.valueOf(((DecimalLiteral)expression).getValue());
        }
        if (expression instanceof TimestampLiteral) {
            return ((TimestampLiteral)expression).getValue();
        }
        if (expression instanceof GenericLiteral) {
            return ((GenericLiteral)expression).getValue();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getValue();
        }
        throw new IllegalArgumentException("Unsupported literal expression type: " + expression.getClass().getName());
    }

    protected Boolean visitSymbolReference(SymbolReference actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SymbolReference)) {
            return false;
        }
        SymbolReference expected = (SymbolReference)expectedExpression;
        return this.symbolAliases.get(expected.getName()).equals((Object)actual);
    }

    protected Boolean visitDereferenceExpression(DereferenceExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DereferenceExpression)) {
            return false;
        }
        DereferenceExpression expected = (DereferenceExpression)expectedExpression;
        return actual.getField().equals(expected.getField()) && (Boolean)this.process((Node)actual.getBase(), expected.getBase()) != false;
    }

    protected Boolean visitIfExpression(IfExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IfExpression)) {
            return false;
        }
        IfExpression expected = (IfExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getCondition(), expected.getCondition()) != false && (Boolean)this.process((Node)actual.getTrueValue(), expected.getTrueValue()) != false && this.process(actual.getFalseValue(), expected.getFalseValue());
    }

    protected Boolean visitCast(Cast actual, Node expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.getType().toString().equalsIgnoreCase(expected.getType().toString())) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getExpression(), expected.getExpression());
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate expected = (IsNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNotNullPredicate)) {
            return false;
        }
        IsNotNullPredicate expected = (IsNotNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitQuantifiedComparisonExpression(QuantifiedComparisonExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof QuantifiedComparisonExpression)) {
            return false;
        }
        QuantifiedComparisonExpression expected = (QuantifiedComparisonExpression)expectedExpression;
        return actual.getQuantifier() == expected.getQuantifier() && actual.getOperator() == expected.getOperator() && (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getSubquery(), expected.getSubquery()) != false;
    }

    protected Boolean visitInPredicate(InPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof InPredicate)) {
            return false;
        }
        InPredicate expected = (InPredicate)expectedExpression;
        if (actual.getValueList() instanceof InListExpression || !(expected.getValueList() instanceof InListExpression)) {
            return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), expected.getValueList()) != false;
        }
        List values = ((InListExpression)expected.getValueList()).getValues();
        Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Multiple expressions in expected value list %s, but actual value is not a list: %s", (Object)values, (Object)actual.getValue());
        Expression onlyExpectedExpression = (Expression)values.get(0);
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), onlyExpectedExpression) != false;
    }

    protected Boolean visitInListExpression(InListExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof InListExpression)) {
            return false;
        }
        InListExpression expected = (InListExpression)expectedExpression;
        return this.process(actual.getValues(), expected.getValues());
    }

    protected Boolean visitComparisonExpression(ComparisonExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ComparisonExpression)) {
            return false;
        }
        ComparisonExpression expected = (ComparisonExpression)expectedExpression;
        if (actual.getOperator() == expected.getOperator() && ((Boolean)this.process((Node)actual.getLeft(), expected.getLeft())).booleanValue() && ((Boolean)this.process((Node)actual.getRight(), expected.getRight())).booleanValue()) {
            return true;
        }
        return actual.getOperator() == expected.getOperator().flip() && (Boolean)this.process((Node)actual.getLeft(), expected.getRight()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getLeft()) != false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof BetweenPredicate)) {
            return false;
        }
        BetweenPredicate expected = (BetweenPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getMin(), expected.getMin()) != false && (Boolean)this.process((Node)actual.getMax(), expected.getMax()) != false;
    }

    protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticUnaryExpression)) {
            return false;
        }
        ArithmeticUnaryExpression expected = (ArithmeticUnaryExpression)expectedExpression;
        return actual.getSign() == expected.getSign() && (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false;
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticBinaryExpression)) {
            return false;
        }
        ArithmeticBinaryExpression expected = (ArithmeticBinaryExpression)expectedExpression;
        return actual.getOperator() == expected.getOperator() && (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false;
    }

    protected Boolean visitNotExpression(NotExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof NotExpression)) {
            return false;
        }
        NotExpression expected = (NotExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitLogicalExpression(LogicalExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof LogicalExpression)) {
            return false;
        }
        LogicalExpression expected = (LogicalExpression)expectedExpression;
        if (actual.getTerms().size() != expected.getTerms().size() || actual.getOperator() != expected.getOperator()) {
            return false;
        }
        for (int i = 0; i < actual.getTerms().size(); ++i) {
            if (((Boolean)this.process((Node)actual.getTerms().get(i), (Node)expected.getTerms().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof CoalesceExpression)) {
            return false;
        }
        CoalesceExpression expected = (CoalesceExpression)expectedExpression;
        if (actual.getOperands().size() != expected.getOperands().size()) {
            return false;
        }
        for (int i = 0; i < actual.getOperands().size(); ++i) {
            if (((Boolean)this.process((Node)actual.getOperands().get(i), (Node)expected.getOperands().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression expected = (SimpleCaseExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getOperand(), expected.getOperand()) != false && this.process(actual.getWhenClauses(), expected.getWhenClauses()) && this.process(actual.getDefaultValue(), expected.getDefaultValue());
    }

    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression actual, Node expected) {
        if (!(expected instanceof SearchedCaseExpression)) {
            return false;
        }
        SearchedCaseExpression expectedCase = (SearchedCaseExpression)expected;
        if (!this.process(actual.getWhenClauses(), expectedCase.getWhenClauses())) {
            return false;
        }
        if (actual.getDefaultValue().isPresent() != expectedCase.getDefaultValue().isPresent()) {
            return false;
        }
        return this.process(actual.getDefaultValue(), expectedCase.getDefaultValue());
    }

    protected Boolean visitWhenClause(WhenClause actual, Node expectedExpression) {
        if (!(expectedExpression instanceof WhenClause)) {
            return false;
        }
        WhenClause expected = (WhenClause)expectedExpression;
        return (Boolean)this.process((Node)actual.getOperand(), expected.getOperand()) != false && (Boolean)this.process((Node)actual.getResult(), expected.getResult()) != false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Boolean visitFunctionCall(FunctionCall actual, Node expectedExpression) {
        boolean bl;
        CatalogSchemaFunctionName expectedFunctionName;
        if (!(expectedExpression instanceof FunctionCall)) return false;
        FunctionCall expected = (FunctionCall)expectedExpression;
        if (ResolvedFunction.isResolved((QualifiedName)expected.getName())) {
            expectedFunctionName = ResolvedFunction.extractFunctionName((QualifiedName)expected.getName());
        } else {
            Preconditions.checkArgument((expected.getName().getParts().size() == 1 ? 1 : 0) != 0, (String)"Unresolved function call name must not be qualified: %s", (Object)expected.getName());
            expectedFunctionName = GlobalFunctionCatalog.builtinFunctionName((String)expected.getName().getSuffix());
        }
        if (actual.isDistinct() == expected.isDistinct() && ResolvedFunction.extractFunctionName((QualifiedName)actual.getName()).equals((Object)expectedFunctionName) && this.process(actual.getArguments(), expected.getArguments()) && this.process(actual.getFilter(), expected.getFilter())) {
            if (this.process(actual.getWindow().map(Node.class::cast), expected.getWindow().map(Node.class::cast))) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    protected Boolean visitLambdaExpression(LambdaExpression actual, Node expected) {
        if (!(expected instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambdaExpression = (LambdaExpression)expected;
        if (!actual.getArguments().equals(lambdaExpression.getArguments())) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getBody(), lambdaExpression.getBody());
    }

    protected Boolean visitRow(Row actual, Node expectedExpression) {
        if (!(expectedExpression instanceof Row)) {
            return false;
        }
        Row expected = (Row)expectedExpression;
        return this.process(actual.getItems(), expected.getItems());
    }

    protected Boolean visitTryExpression(TryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof TryExpression)) {
            return false;
        }
        TryExpression expected = (TryExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getInnerExpression(), expected.getInnerExpression());
    }

    protected Boolean visitSubscriptExpression(SubscriptExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SubscriptExpression)) {
            return false;
        }
        SubscriptExpression expected = (SubscriptExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getBase(), expected.getBase()) != false && (Boolean)this.process((Node)actual.getIndex(), expected.getIndex()) != false;
    }

    private <T extends Node> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Node)actuals.get(i), (Node)expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean process(Optional<T> actual, Optional<T> expected) {
        if (actual.isPresent() != expected.isPresent()) {
            return false;
        }
        if (actual.isPresent()) {
            return (Boolean)this.process((Node)actual.get(), (Node)expected.get());
        }
        return true;
    }
}

