/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.BigintType;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SymbolReference;
import java.util.Map;
import java.util.Set;

public class PatternRecognitionExpressionRewriter {
    private PatternRecognitionExpressionRewriter() {
    }

    public static LogicalIndexExtractor.ExpressionAndValuePointers rewrite(String definition, Map<IrLabel, Set<IrLabel>> subsets) {
        return PatternRecognitionExpressionRewriter.rewrite(new SqlParser().createExpression(definition), subsets);
    }

    public static LogicalIndexExtractor.ExpressionAndValuePointers rewrite(Expression definition, Map<IrLabel, Set<IrLabel>> subsets) {
        Expression expression = PatternRecognitionExpressionRewriter.rewriteIdentifiers(definition);
        Map types = (Map)ExpressionTreeUtils.extractExpressions((Iterable)ImmutableList.of((Object)expression), SymbolReference.class).stream().collect(ImmutableMap.toImmutableMap(Symbol::from, reference -> BigintType.BIGINT));
        return LogicalIndexExtractor.rewrite((Expression)expression, subsets, (SymbolAllocator)new SymbolAllocator(types), (Session)SessionTestUtils.TEST_SESSION, (Metadata)MetadataManager.createTestMetadataManager());
    }

    private static Expression rewriteIdentifiers(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkArgument((boolean)(node.getBase() instanceof Identifier), (Object)"chained dereferences not supported");
                return new LabelDereference(((Identifier)node.getBase()).getCanonicalValue(), node.getField().map(identifier -> new SymbolReference(identifier.getValue())));
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new LambdaExpression(node.getArguments(), treeRewriter.rewrite(node.getBody(), (Object)context));
            }

            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteRowDataType(RowDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }
        }, (Expression)expression);
    }
}

