/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAddExchangesScaledWriters
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)session);
        queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        queryRunner.createCatalog("catalog_with_scaled_writers", (ConnectorFactory)this.createConnectorFactory("catalog_with_scaled_writers", true), (Map)ImmutableMap.of());
        queryRunner.createCatalog("catalog_without_scaled_writers", (ConnectorFactory)this.createConnectorFactory("catalog_without_scaled_writers", false), (Map)ImmutableMap.of());
        return queryRunner;
    }

    private MockConnectorFactory createConnectorFactory(String name, boolean writerScalingEnabledAcrossTasks) {
        return MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> null).withName(name).withWriterScalingOptions(new WriterScalingOptions(writerScalingEnabledAcrossTasks, true)).build();
    }

    @Test
    public void testScaledWriters() {
        for (boolean isScaleWritersEnabled : Arrays.asList(true, false)) {
            Session session = TestingSession.testSessionBuilder().setSystemProperty("scale_writers", Boolean.toString(isScaleWritersEnabled)).build();
            String query = "CREATE TABLE catalog_with_scaled_writers.mock.test AS SELECT * FROM tpch.tiny.nation";
            SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
            if (isScaleWritersEnabled) {
                Assertions.assertThat((Object)((PlanFragment)subPlan.getAllFragments().get(1)).getPartitioning().getConnectorHandle()).isEqualTo((Object)SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION.getConnectorHandle());
                continue;
            }
            subPlan.getAllFragments().forEach(fragment -> Assertions.assertThat((Object)fragment.getPartitioning().getConnectorHandle()).isNotEqualTo((Object)SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION.getConnectorHandle()));
        }
    }

    @Test
    public void testScaledWritersWithTasksScalingDisabled() {
        for (boolean isScaleWritersEnabled : Arrays.asList(true, false)) {
            Session session = TestingSession.testSessionBuilder().setSystemProperty("scale_writers", Boolean.toString(isScaleWritersEnabled)).build();
            String query = "CREATE TABLE catalog_without_scaled_writers.mock.test AS SELECT * FROM tpch.tiny.nation";
            SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
            subPlan.getAllFragments().forEach(fragment -> Assertions.assertThat((Object)fragment.getPartitioning().getConnectorHandle()).isNotEqualTo((Object)SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION.getConnectorHandle()));
        }
    }
}

