/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.ValidateStreamingAggregations;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestValidateStreamingAggregations
extends BasePlanTest {
    private PlannerContext plannerContext;
    private TypeAnalyzer typeAnalyzer;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;

    @BeforeAll
    public void setup() {
        this.plannerContext = this.getQueryRunner().getPlannerContext();
        this.typeAnalyzer = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.plannerContext);
        CatalogHandle catalogHandle = this.getCurrentCatalogHandle();
        this.nationTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))));
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("unique"), p.symbol("nationkey")).preGroupedSymbols(p.symbol("unique"), p.symbol("nationkey")).source((PlanNode)p.assignUniqueId(p.symbol("unique"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))))));
    }

    @Test
    public void testValidateFailed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).preGroupedSymbols(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))))))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Streaming aggregation with input not grouped on the grouping keys");
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        this.getQueryRunner().inTransaction(session -> {
            PlanBuilder builder = new PlanBuilder(this.idAllocator, this.plannerContext, (Session)session);
            PlanNode planNode = (PlanNode)planProvider.apply(builder);
            TypeProvider types = builder.getTypes();
            session.getCatalog().ifPresent(catalog -> this.plannerContext.getMetadata().getCatalogHandle(session, catalog));
            new ValidateStreamingAggregations().validate(planNode, session, this.plannerContext, this.typeAnalyzer, types, WarningCollector.NOOP);
            return null;
        });
    }
}

