/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.block.BlockSerdeUtil;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.scalar.BlockSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.MoreMaps;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestArrayOperators.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testStackRepresentation() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        Block actualBlock = StructuralTestUtil.arrayBlockOf((Type)arrayType, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1L, 2L), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 3L));
        DynamicSliceOutput actualSliceOutput = new DynamicSliceOutput(100);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)((LocalQueryRunner)this.assertions.getQueryRunner()).getPlannerContext().getBlockEncodingSerde(), (SliceOutput)actualSliceOutput, (Block)actualBlock);
        ArrayBlockBuilder expectedBlockBuilder = arrayType.createBlockBuilder(null, 3);
        expectedBlockBuilder.buildEntry(elementBuilder -> {
            BigintType.BIGINT.writeLong(elementBuilder, 1L);
            BigintType.BIGINT.writeLong(elementBuilder, 2L);
        });
        expectedBlockBuilder.buildEntry(elementBuilder -> BigintType.BIGINT.writeLong(elementBuilder, 3L));
        Block expectedBlock = expectedBlockBuilder.build();
        DynamicSliceOutput expectedSliceOutput = new DynamicSliceOutput(100);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)((LocalQueryRunner)this.assertions.getQueryRunner()).getPlannerContext().getBlockEncodingSerde(), (SliceOutput)expectedSliceOutput, (Block)expectedBlock);
        Assert.assertEquals((Object)actualSliceOutput.slice(), (Object)expectedSliceOutput.slice());
    }

    @Test
    public void testTypeConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a]").binding("a", "7")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "12.34E0").binding("b", "56.78E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)12.34, (Object)56.78));
    }

    @Test
    public void testArrayToArrayCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(INTEGER))").binding("a", "array[null]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(new Integer[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(INTEGER))").binding("a", "array[1, 2, 3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(INTEGER))").binding("a", "array[1, null, 3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(1, null, 3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "array[null]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(new Long[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "array[1, 2, 3]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "array[1, null, 3]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(1L, null, 3L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DOUBLE))").binding("a", "array[1, 2, 3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DOUBLE))").binding("a", "array[1, null, 3]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(1.0, null, 3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(VARCHAR))").binding("a", "array['1', '2']")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(ImmutableList.of((Object)"1", (Object)"2"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DOUBLE))").binding("a", "array['1', '2']")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BOOLEAN))").binding("a", "array[true, false]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(VARCHAR))").binding("a", "array[true, false]")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(ImmutableList.of((Object)"true", (Object)"false"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BOOLEAN))").binding("a", "array[1, 0]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(ARRAY(DOUBLE)))").binding("a", "array[ARRAY[1], ARRAY[2, 3]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(Arrays.asList(Arrays.asList(1.0), Arrays.asList(2.0, 3.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(ARRAY(DOUBLE)))").binding("a", "array[ARRAY[1.0], ARRAY[2.0, 3.0]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(Arrays.asList(Arrays.asList(1.0), Arrays.asList(2.0, 3.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(ARRAY(DECIMAL(2,1))))").binding("a", "array[ARRAY[1.0E0], ARRAY[2.0E0, 3.0E0]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)))).isEqualTo(Arrays.asList(Arrays.asList(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))), Arrays.asList(SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(ARRAY(DECIMAL(20,10))))").binding("a", "array[ARRAY[1.0E0], ARRAY[2.0E0, 3.0E0]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)20, (int)10)))).isEqualTo(Arrays.asList(Arrays.asList(SqlDecimal.decimal((String)"0000000001.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10))), Arrays.asList(SqlDecimal.decimal((String)"0000000002.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)), SqlDecimal.decimal((String)"0000000003.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(TIMESTAMP))").binding("a", "array[1, null, 3]").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(ARRAY(TIMESTAMP)))").binding("a", "array[1, null, 3]").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "array['puppies', 'kittens']").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testArraySize() {
        int size = Math.toIntExact(BlockSet.MAX_FUNCTION_MEMORY.toBytes() + 1L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("array_distinct(ARRAY['" + "x".repeat(size) + "', '" + "y".repeat(size) + "', '" + "z".repeat(size) + "'])").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT});
    }

    @Test
    public void testArrayToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(null as ARRAY(BIGINT))")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[]")))).hasType((Type)JsonType.JSON).isEqualTo("[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[null, null]")))).hasType((Type)JsonType.JSON).isEqualTo("[null,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[true, false, null]")))).hasType((Type)JsonType.JSON).isEqualTo("[true,false,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ARRAY[1, 2, null] AS ARRAY(TINYINT))")))).hasType((Type)JsonType.JSON).isEqualTo("[1,2,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ARRAY[12345, -12345, null] AS ARRAY(SMALLINT))")))).hasType((Type)JsonType.JSON).isEqualTo("[12345,-12345,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ARRAY[123456789, -123456789, null] AS ARRAY(INTEGER))")))).hasType((Type)JsonType.JSON).isEqualTo("[123456789,-123456789,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ARRAY[1234567890123456789, -1234567890123456789, null] AS ARRAY(BIGINT))")))).hasType((Type)JsonType.JSON).isEqualTo("[1234567890123456789,-1234567890123456789,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ARRAY[3.14E0, nan(), infinity(), -infinity(), null] AS ARRAY(REAL))")))).hasType((Type)JsonType.JSON).isEqualTo("[3.14,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[3.14E0, 1e-323, 1e308, nan(), infinity(), -infinity(), null]")))).hasType((Type)JsonType.JSON).isEqualTo(Runtime.version().feature() >= 19 ? "[3.14,9.9E-324,1.0E308,\"NaN\",\"Infinity\",\"-Infinity\",null]" : "[3.14,1.0E-323,1.0E308,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[DECIMAL '3.14', null]")))).hasType((Type)JsonType.JSON).isEqualTo("[3.14,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[DECIMAL '12345678901234567890.123456789012345678', null]")))).hasType((Type)JsonType.JSON).isEqualTo("[12345678901234567890.123456789012345678,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY['a', 'bb', null]")))).hasType((Type)JsonType.JSON).isEqualTo("[\"a\",\"bb\",null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', null]")))).hasType((Type)JsonType.JSON).isEqualTo("[123,3.14,false,\"abc\",[1,\"a\",null],{\"a\":1,\"b\":\"str\",\"c\":null},null,null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', null]")))).hasType((Type)JsonType.JSON).isEqualTo(String.format("[\"%s\",null]", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[DATE '2001-08-22', DATE '2001-08-23', null]")))).hasType((Type)JsonType.JSON).isEqualTo("[\"2001-08-22\",\"2001-08-23\",null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], null]")))).hasType((Type)JsonType.JSON).isEqualTo("[[1,2],[3,null],[],[null,null],null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), null]")))).hasType((Type)JsonType.JSON).isEqualTo("[{\"a\":1,\"b\":2},{\"none\":null,\"three\":3},{},{\"h1\":null,\"h2\":null},null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null]")))).hasType((Type)JsonType.JSON).isEqualTo("[{\"\":1,\"\":2},{\"\":3,\"\":null},{\"\":null,\"\":null},null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[12345.12345, 12345.12345, 3.0]")))).hasType((Type)JsonType.JSON).isEqualTo("[12345.12345,12345.12345,3.00000]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ARRAY[123456789012345678901234567890.87654321, 123456789012345678901234567890.12345678]")))).hasType((Type)JsonType.JSON).isEqualTo("[123456789012345678901234567890.87654321,123456789012345678901234567890.12345678]");
    }

    @Test
    public void testJsonToArray() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "CAST(null AS JSON)")))).isNull((Type)new ArrayType((Type)BigintType.BIGINT));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON 'null'")))).isNull((Type)new ArrayType((Type)BigintType.BIGINT));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '[]'")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '[null, null]'")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Lists.newArrayList((Object[])new Object[]{null, null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BOOLEAN))").binding("a", "JSON '[true, false, 12, 0, 12.3, 0.0, \"true\", \"false\", null]'")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(true, false, true, false, true, false, true, false, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(TINYINT))").binding("a", "JSON '[true, false, 12, 12.7, \"12\", null]'")))).hasType((Type)new ArrayType((Type)TinyintType.TINYINT)).isEqualTo(Arrays.asList((byte)1, (byte)0, (byte)12, (byte)13, (byte)12, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(SMALLINT))").binding("a", "JSON '[true, false, 12345, 12345.6, \"12345\", null]'")))).hasType((Type)new ArrayType((Type)SmallintType.SMALLINT)).isEqualTo(Arrays.asList((short)1, (short)0, (short)12345, (short)12346, (short)12345, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(INTEGER))").binding("a", "JSON '[true, false, 12345678, 12345678.9, \"12345678\", null]'")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(1, 0, 12345678, 12345679, 12345678, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '[true, false, 1234567891234567, 1234567891234567.8, \"1234567891234567\", null]'")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(1L, 0L, 1234567891234567L, 1234567891234568L, 1234567891234567L, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(REAL))").binding("a", "JSON '[true, false, 12345, 12345.67, \"3.14\", \"NaN\", \"Infinity\", \"-Infinity\", null]'")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(12345.0f), Float.valueOf(12345.67f), Float.valueOf(3.14f), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DOUBLE))").binding("a", "JSON '[true, false, 1234567890, 1234567890.1, \"3.14\", \"NaN\", \"Infinity\", \"-Infinity\", null]'")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(1.0, 0.0, 1.23456789E9, 1.2345678901E9, 3.14, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(10, 5)))").binding("a", "JSON '[true, false, 128, 123.456, \"3.14\", null]'")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5))).isEqualTo(Arrays.asList(SqlDecimal.decimal((String)"1.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"0.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"128.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"3.14000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(38, 8)))").binding("a", "JSON '[true, false, 128, 12345678.12345678, \"3.14\", null]'")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)38, (int)8))).isEqualTo(Arrays.asList(SqlDecimal.decimal((String)"1.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"0.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"128.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"12345678.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"3.14000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(VARCHAR))").binding("a", "JSON '[true, false, 12, 12.3, \"puppies\", \"kittens\", \"null\", \"\", null]'")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(Arrays.asList("true", "false", "12", "1.23E1", "puppies", "kittens", "null", "", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(JSON))").binding("a", "JSON '[5, 3.14, [1, 2, 3], \"e\", {\"a\": \"b\"}, null, \"null\", [null]]'")))).hasType((Type)new ArrayType((Type)JsonType.JSON)).isEqualTo(ImmutableList.of((Object)"5", (Object)"3.14", (Object)"[1,2,3]", (Object)"\"e\"", (Object)"{\"a\":\"b\"}", (Object)"null", (Object)"\"null\"", (Object)"[null]"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(ARRAY(BIGINT)))").binding("a", "JSON '[[1, 2], [3, null], [], [null, null], null]'")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(Arrays.asList(Arrays.asList(1L, 2L), Arrays.asList(3L, null), Collections.emptyList(), Arrays.asList(null, null), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ARRAY(MAP(VARCHAR, BIGINT)))").binding("a", "JSON '[\n    {\"a\": 1, \"b\": 2},\n    {\"none\": null, \"three\": 3},\n    {},\n    {\"h1\": null,\"h2\": null},\n    null\n]'\n")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT))).isEqualTo(Arrays.asList(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)2L), MoreMaps.asMap((List)ImmutableList.of((Object)"none", (Object)"three"), Arrays.asList(null, 3L)), ImmutableMap.of(), MoreMaps.asMap((List)ImmutableList.of((Object)"h1", (Object)"h2"), Arrays.asList(null, null)), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ARRAY(ROW(k1 BIGINT, k2 VARCHAR)))").binding("a", "JSON '[\n    [1, \"two\"],\n    [3, null],\n    {\"k1\": 1, \"k2\": \"two\"},\n    {\"k2\": null, \"k1\": 3},\n    null\n]'\n")))).hasType((Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)VarcharType.VARCHAR))))).isEqualTo(Arrays.asList(Arrays.asList(1L, "two"), Arrays.asList(3L, null), Arrays.asList(1L, "two"), Arrays.asList(3L, null), null));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '{\"a\": 1}'").evaluate()).hasMessage("Cannot cast to array(bigint). Expected a json array, but got {\n{\"a\":1}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(ARRAY(BIGINT)))").binding("a", "JSON '[1, 2, 3]'").evaluate()).hasMessage("Cannot cast to array(array(bigint)). Expected a json array, but got 1\n[1,2,3]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '[1, {}]'").evaluate()).hasMessage("Cannot cast to array(bigint). Unexpected token when cast to bigint: {\n[1,{}]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(ARRAY(BIGINT)))").binding("a", "JSON '[[1], {}]'").evaluate()).hasMessage("Cannot cast to array(array(bigint)). Expected a json array, but got {\n[[1],{}]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "unchecked_to_json('1, 2, 3')").evaluate()).hasMessage("Cannot cast to array(bigint).\n1, 2, 3")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "unchecked_to_json('[1] 2')").evaluate()).hasMessage("Cannot cast to array(bigint). Unexpected trailing token: 2\n[1] 2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "unchecked_to_json('[1, 2, 3')").evaluate()).hasMessage("Cannot cast to array(bigint).\n[1, 2, 3")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(BIGINT))").binding("a", "JSON '[\"a\", \"b\"]'").evaluate()).hasMessage("Cannot cast to array(bigint). Cannot cast 'a' to BIGINT\n[\"a\",\"b\"]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(INTEGER))").binding("a", "JSON '[1234567890123.456]'").evaluate()).hasMessage("Cannot cast to array(integer). Out of range for integer: 1.234567890123456E12\n[1.234567890123456E12]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(10,5)))").binding("a", "JSON '[1, 2.0, 3]'")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)SqlDecimal.decimal((String)"2.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)SqlDecimal.decimal((String)"3.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(10,5)))").binding("a", "CAST(ARRAY[1, 2.0, 3] as JSON)")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)10, (int)5))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)SqlDecimal.decimal((String)"2.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)SqlDecimal.decimal((String)"3.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(38,8)))").binding("a", "CAST(ARRAY[123456789012345678901234567890.12345678, 1.2] as JSON)")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)38, (int)8))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), (Object)SqlDecimal.decimal((String)"1.20000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS array(DECIMAL(7,2)))").binding("a", "CAST(ARRAY[12345.87654] as JSON)")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)7, (int)2))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"12345.88", (DecimalType)DecimalType.createDecimalType((int)7, (int)2))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a AS array(DECIMAL(6,2)))").binding("a", "CAST(ARRAY[12345.12345] as JSON)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a]").binding("a", "NULL")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Lists.newArrayList((Object[])new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "2").binding("c", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "NULL").binding("c", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Lists.newArrayList((Object[])new Integer[]{1, null, 3}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "NULL").binding("b", "2").binding("c", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Lists.newArrayList((Object[])new Integer[]{null, 2, 3}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "2.0E0").binding("c", "3")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "ARRAY[1, 2]").binding("b", "NULL").binding("c", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1, (Object)2), null, ImmutableList.of((Object)3)}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "BIGINT '1'").binding("b", "2").binding("c", "3")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "CAST(NULL AS BIGINT)").binding("c", "3")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Lists.newArrayList((Object[])new Long[]{1L, null, 3L}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "NULL").binding("b", "20000000000").binding("c", "30000000000")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Lists.newArrayList((Object[])new Long[]{null, 20000000000L, 30000000000L}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "2.0E0").binding("c", "3")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "ARRAY[1, 2]").binding("b", "NULL").binding("c", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1, (Object)2), null, ImmutableList.of((Object)3)}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "ARRAY[1, 2]").binding("b", "NULL").binding("c", "ARRAY[BIGINT '3']")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1L, (Object)2L), null, ImmutableList.of((Object)3L)}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1.0E0").binding("b", "2.5E0").binding("c", "3.0E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "2.5E0").binding("c", "3")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "'puppies'").binding("b", "'kittens'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"puppies", (Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "TRUE").binding("b", "FALSE")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "TIMESTAMP '1970-01-01 00:00:01'").binding("b", "TIMESTAMP '1973-07-08 22:00:01'")))).hasType((Type)new ArrayType((Type)TimestampType.createTimestampType((int)0))).isEqualTo(ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a]").binding("a", "sqrt(-1)")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a]").binding("a", "pow(infinity(), 2)")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a]").binding("a", "pow(-infinity(), 1)")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "ARRAY[]").binding("b", "NULL")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN))).isEqualTo(Arrays.asList(ImmutableList.of(), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "ARRAY[1.0]").binding("b", "ARRAY[2.0, 3.0]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)))).isEqualTo(Arrays.asList(Arrays.asList(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))), Arrays.asList(SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1.0").binding("b", "2.0").binding("c", "3.11")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2))).isEqualTo(Arrays.asList(SqlDecimal.decimal((String)"1.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)), SqlDecimal.decimal((String)"2.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)), SqlDecimal.decimal((String)"3.11", (DecimalType)DecimalType.createDecimalType((int)3, (int)2))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b, c]").binding("a", "1").binding("b", "2.0").binding("c", "3.11")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)12, (int)2))).isEqualTo(Arrays.asList(SqlDecimal.decimal((String)"0000000001.00", (DecimalType)DecimalType.createDecimalType((int)12, (int)2)), SqlDecimal.decimal((String)"0000000002.00", (DecimalType)DecimalType.createDecimalType((int)12, (int)2)), SqlDecimal.decimal((String)"0000000003.11", (DecimalType)DecimalType.createDecimalType((int)12, (int)2))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("ARRAY[a, b]").binding("a", "ARRAY[1.0]").binding("b", "ARRAY[2.0, 123456789123456.789]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)18, (int)3)))).isEqualTo(Arrays.asList(Arrays.asList(SqlDecimal.decimal((String)"000000000000001.000", (DecimalType)DecimalType.createDecimalType((int)18, (int)3))), Arrays.asList(SqlDecimal.decimal((String)"000000000000002.000", (DecimalType)DecimalType.createDecimalType((int)18, (int)3)), SqlDecimal.decimal((String)"123456789123456.789", (DecimalType)DecimalType.createDecimalType((int)18, (int)3)))));
    }

    @Test
    public void testArrayToArrayConcat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[1, NULL]").binding("b", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Lists.newArrayList((Object[])new Integer[]{1, null, 3}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[3, 4]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[3, BIGINT '4']")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[3, 40000000000]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)40000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[NULL]").binding("b", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Lists.newArrayList((Object[])new Object[]{null, null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY['puppies']").binding("b", "ARRAY['kittens']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"puppies", (Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[TRUE]").binding("b", "ARRAY[FALSE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[1]", "ARRAY[2,3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[TIMESTAMP '1970-01-01 00:00:01']").binding("b", "ARRAY[TIMESTAMP '1973-07-08 22:00:01']")))).matches("ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[ARRAY[1]]]").binding("b", "ARRAY[ARRAY[ARRAY[2]]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))).isEqualTo(Arrays.asList(Collections.singletonList(Ints.asList((int[])new int[]{1})), Collections.singletonList(Ints.asList((int[])new int[]{2}))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[]").binding("b", "ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b || c").binding("a", "ARRAY[TRUE]").binding("b", "ARRAY[FALSE]").binding("c", "ARRAY[TRUE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b || c || d").binding("a", "ARRAY[1]").binding("b", "ARRAY[2]").binding("c", "ARRAY[3]").binding("d", "ARRAY[4]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b || c || d").binding("a", "ARRAY[1]").binding("b", "ARRAY[2.0E0]").binding("c", "ARRAY[3]").binding("d", "ARRAY[4.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1], ARRAY[2, 8]]").binding("b", "ARRAY[ARRAY[3, 6], ARRAY[4]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6), (Object)ImmutableList.of((Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[1.0]").binding("b", "ARRAY[2.0, 3.11]")))).matches("ARRAY[1.0, 2.0, 3.11]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b || c").binding("a", "ARRAY[1.0]").binding("b", "ARRAY[2.0]").binding("c", "ARRAY[123456789123456.789]")))).matches("ARRAY[1.0, 2.0, 123456789123456.789]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY[NULL]", "ARRAY[]", "ARRAY[NULL]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Collections.nCopies(2, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY[]", "ARRAY[]", "NULL", "ARRAY[]")))).isNull((Type)new ArrayType((Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY[]", "ARRAY[]", "ARRAY[]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY[]", "ARRAY[333]", "ARRAY[]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)333));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[1]", "ARRAY[2,3]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[1]", "ARRAY[2,3,3]", "ARRAY[2,1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)3, (Object)2, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[1]", "ARRAY[]", "ARRAY[1,2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY[1]", "ARRAY[]", "ARRAY[3]", "ARRAY[]", "ARRAY[5]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)3, (Object)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "ARRAY[]", "ARRAY['123456']", "CAST(ARRAY[1,2] AS ARRAY(varchar))", "ARRAY[]")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(ImmutableList.of((Object)"123456", (Object)"1", (Object)"2"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1]]").binding("b", "ARRAY[ARRAY[true], ARRAY[false]]").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1]]").binding("b", "ARRAY[NULL]").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_FUNCTION_CALL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1]]").binding("b", "ARRAY[ARRAY['x']]").evaluate()).hasMessage("line 1:10: Unexpected parameters (array(array(integer)), array(array(varchar(1)))) for function concat. Expected: concat(E, array(E)) E, concat(array(E)) E, concat(array(E), E) E, concat(char(x), char(y)), concat(varbinary), concat(varchar)");
    }

    @Test
    public void testElementArrayConcat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a || b AS JSON)").binding("a", "ARRAY[DATE '2001-08-22']").binding("b", "DATE '2001-08-23'")))).hasType((Type)JsonType.JSON).isEqualTo("[\"2001-08-22\",\"2001-08-23\"]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a || b AS JSON)").binding("a", "DATE '2001-08-23'").binding("b", "ARRAY[DATE '2001-08-22']")))).hasType((Type)JsonType.JSON).isEqualTo("[\"2001-08-23\",\"2001-08-22\"]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "1").binding("b", "ARRAY[2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Lists.newArrayList((Object[])new Integer[]{1, 2}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[2]").binding("b", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Lists.newArrayList((Object[])new Integer[]{2, 1}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[2]").binding("b", "BIGINT '1'")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Lists.newArrayList((Object[])new Long[]{2L, 1L}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "TRUE").binding("b", "ARRAY[FALSE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Lists.newArrayList((Object[])new Boolean[]{true, false}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[FALSE]").binding("b", "TRUE")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Lists.newArrayList((Object[])new Boolean[]{false, true}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "1.0E0").binding("b", "ARRAY[2.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Lists.newArrayList((Object[])new Double[]{1.0, 2.0}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[2.0E0]").binding("b", "1.0E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Lists.newArrayList((Object[])new Double[]{2.0, 1.0}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "'puppies'").binding("b", "ARRAY['kittens']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(Lists.newArrayList((Object[])new String[]{"puppies", "kittens"}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY['kittens']").binding("b", "'puppies'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(Lists.newArrayList((Object[])new String[]{"kittens", "puppies"}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[TIMESTAMP '1970-01-01 00:00:01']").binding("b", "TIMESTAMP '1973-07-08 22:00:01'")))).matches("ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "TIMESTAMP '1973-07-08 22:00:01'").binding("b", "ARRAY[TIMESTAMP '1970-01-01 00:00:01']")))).matches("ARRAY[TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[2, 8]").binding("b", "ARRAY[ARRAY[3, 6], ARRAY[4]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6), (Object)ImmutableList.of((Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1], ARRAY[2, 8]]").binding("b", "ARRAY[3, 6]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)8), (Object)ImmutableList.of((Object)3, (Object)6)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", "ARRAY[2.0, 3.11]").binding("b", "1.0")))).matches("ARRAY[2.0, 3.11, 1.0]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b || c").binding("a", "ARRAY[1.0]").binding("b", "2.0").binding("c", "123456789123456.789")))).matches("ARRAY[1.0, 2.0, 123456789123456.789]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a || b").binding("a", "ARRAY[ARRAY[1]]").binding("b", "ARRAY['x']").evaluate()).hasMessage("line 1:10: Unexpected parameters (array(array(integer)), array(varchar(1))) for function concat. Expected: concat(E, array(E)) E, concat(array(E)) E, concat(array(E), E) E, concat(char(x), char(y)), concat(varbinary), concat(varchar)");
    }

    @Test
    public void testArrayContains() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array['puppies', 'dogs']", "'dogs'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, 2, 3]", "2")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, BIGINT '2', 3]", "2")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, 2, 3]", "BIGINT '2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, 2, 3]", "5")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, NULL, 3]", "1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[NULL, 2, 3]", "1")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[NULL, 2, 3]", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1, 2.0E0, 3]", "3.0E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[1.0E0, 2.5E0, 3.0E0]", "2.2E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array['puppies', 'dogs']", "'dogs'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array['puppies', 'dogs']", "'sharks'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[TRUE, FALSE]", "TRUE")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[FALSE]", "TRUE")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[ARRAY[1, 2], ARRAY[3, 4]]", "ARRAY[3, 4]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[ARRAY[1, 2], ARRAY[3, 4]]", "ARRAY[3]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[CAST(NULL AS BIGINT)]", "1")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[CAST(NULL AS BIGINT)]", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[]", "NULL")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[]", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, 1.1]", "1.1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, 1.1]", "1.1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, NULL]", "1.1")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, 1.1]", "1.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, 1.1]", "0000000000001.100")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[2.2, 001.20]", "1.2")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[ARRAY[1.1, 2.2], ARRAY[3.3, 4.3]]", "ARRAY[3.3, 4.300]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[ARRAY[1.1, 2.2], ARRAY[3.3, 4.3]]", "ARRAY[1.3, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("contains", "array[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']", "TIMESTAMP '1111-05-10 12:34:56.123456789'")))).isEqualTo(true);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("contains", "array[ARRAY[1.1, 2.2], ARRAY[3.3, 4.3]]", "ARRAY[1.1, null]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("contains", "array[ARRAY[1.1, null], ARRAY[3.3, 4.3]]", "ARRAY[1.1, null]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testArrayJoin() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[NULL, 1, 2]", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1,2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, NULL, 2]", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1,2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, 2, NULL]", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1,2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, 2, 3]", "';'", "'N/A'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1;2;3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, 2, null]", "';'", "'N/A'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1;2;N/A");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, 2, 3]", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1x2x3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[BIGINT '1', 2, 3]", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1x2x3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[null]", "'='")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[null,null]", "'='")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[]", "'S'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY['']", "''", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1, 2, 3, null, 5]", "','", "'*'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1,2,3,*,5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY['a', 'b', 'c', null, null, 'd']", "'-'", "'N/A'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a-b-c-N/A-N/A-d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY['a', 'b', 'c', null, null, 'd']", "'-'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a-b-c-d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[null, null, null, null]", "'X'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[true, false]", "'XX'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("trueXXfalse");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[sqrt(-1), infinity()]", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("NaN,Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[JSON '\"a\"', JSON '\"b\"']", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a,b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[JSON '\"a\"', JSON 'null']", "','")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[JSON '\"a\"', JSON 'null']", "','", "'N/A'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a,N/A");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']", "'|'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(String.format("%s|%s", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']", "'|'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2020-05-10 12:34:56.123456789|1111-05-10 12:34:56.123456789");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[null, TIMESTAMP '1970-01-01 00:00:01']", "'|'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0).toString());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[null, TIMESTAMP '1970-01-01 00:00:01']", "'|'", "'XYZ'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("XYZ|" + DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0).toString());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1.0, 2.1, 3.3]", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.0x2.1x3.3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1.0, 2.100, 3.3]", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.000x2.100x3.300");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1.0, 2.100, NULL]", "'x'", "'N/A'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.000x2.100xN/A");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_join", "ARRAY[1.0, DOUBLE '002.100', 3.3]", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.0E0x2.1E0x3.3E0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_join", "ARRAY[ARRAY[1], ARRAY[2]]", "'-'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.OPERATOR_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_join", "ARRAY[MAP(ARRAY[1], ARRAY[2])]", "'-'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.OPERATOR_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_join", "ARRAY[CAST(row(1, 2) AS row(col0 bigint, col1 bigint))]", "'-'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.OPERATOR_NOT_FOUND});
    }

    @Test
    public void testCardinality() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[]")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[NULL]")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1, 2, 3]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1, NULL, 3]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1, 2.0E0, 3]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1.0E0, 2.5E0, 3.0E0]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY['puppies', 'kittens']")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[TRUE, FALSE]")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1.1, 2.2, 3.3]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "ARRAY[1.1, 33832293522235.23522]")))).isEqualTo(2L);
    }

    @Test
    public void testArrayMin() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NaN()]")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NaN(), NaN(), NaN()]")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[CAST(NaN() AS REAL), CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, 2, 3]")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NaN(), 2, 3]")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[2, NaN(), 3]")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[2, 3, NaN()]")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, NaN(), 1]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NaN(), NULL, 3.0]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1.0E0, NULL, 3]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1.0, NaN(), 3]")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[CAST(NaN() AS REAL), REAL '2', REAL '3']")))).isEqualTo(Float.valueOf(2.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[REAL '2', CAST(NaN() AS REAL), REAL '3']")))).isEqualTo(Float.valueOf(2.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[REAL '2', REAL '3', CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(2.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, CAST(NaN() AS REAL), REAL '1']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[CAST(NaN() AS REAL), NULL, REAL '3']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[REAL '1', NULL, REAL '3']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[REAL '1', CAST(NaN() AS REAL), REAL '3']")))).isEqualTo(Float.valueOf(1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY['1', '2', NULL]")))).isNull((Type)VarcharType.createVarcharType((int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[3, 2, 1]")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1, 2, 3]")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[BIGINT '3', 2, 1]")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1, 2.0E0, 3]")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1.0E0, 2.5E0, 3.0E0]")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY['puppies', 'kittens']")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, FALSE]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789']")))).matches("TIMESTAMP '2020-05-10 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[2.1, 2.2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[2.111111222111111114111, 2.22222222222222222, 2.222222222222223]")))).isEqualTo(SqlDecimal.decimal((String)"2.111111222111111114111", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[1.9, 2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"0000000001.9", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[2.22222222222222222, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.22222222222222222", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(NaN()), ROW(2), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(2), ROW(NaN()), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(2), ROW(3), ROW(NaN())]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, ROW(NaN()), ROW(1)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(NaN()), NULL, ROW(3.0)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(1.0E0), NULL, ROW(3)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(1.0), ROW(NaN()), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(CAST(NaN() AS REAL)), ROW(REAL '2'), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(REAL '2'), ROW(CAST(NaN() AS REAL)), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(REAL '2'), ROW(REAL '3'), ROW(CAST(NaN() AS REAL))]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, ROW(CAST(NaN() AS REAL)), ROW(REAL '1')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(CAST(NaN() AS REAL)), NULL, ROW(REAL '3')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(REAL '1'), NULL, ROW(REAL '3')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ROW(REAL '1'), ROW(CAST(NaN() AS REAL)), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(1.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[NaN()], ARRAY[2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[2], ARRAY[NaN()], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[2], ARRAY[3], ARRAY[NaN()]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, ARRAY[NaN()], ARRAY[1]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[NaN()], NULL, ARRAY[3.0]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[1.0E0], NULL, ARRAY[3]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[1.0], ARRAY[NaN()], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '2'], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[REAL '2'], ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[REAL '2'], ARRAY[REAL '3'], ARRAY[CAST(NaN() AS REAL)]]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(2.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[NULL, ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '1']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[CAST(NaN() AS REAL)], NULL, ARRAY[REAL '3']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[REAL '1'], NULL, ARRAY[REAL '3']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_min", "ARRAY[ARRAY[REAL '1'], ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testArrayMax() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NaN()]")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NaN(), NaN(), NaN()]")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[CAST(NaN() AS REAL), CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, 2, 3]")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NaN(), 2, 3]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[2, NaN(), 3]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[2, 3, NaN()]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, NaN(), 1]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NaN(), NULL, 3.0]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1.0E0, NULL, 3]")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1.0, NaN(), 3]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[CAST(NaN() AS REAL), REAL '2', REAL '3']")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[REAL '2', CAST(NaN() AS REAL), REAL '3']")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[REAL '2', REAL '3', CAST(NaN() AS REAL)]")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, CAST(NaN() AS REAL), REAL '1']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[CAST(NaN() AS REAL), NULL, REAL '3']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[REAL '1', NULL, REAL '3']")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[REAL '1', CAST(NaN() AS REAL), REAL '3']")))).isEqualTo(Float.valueOf(3.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY['1', '2', NULL]")))).isNull((Type)VarcharType.createVarcharType((int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[3, 2, 1]")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1, 2, 3]")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[BIGINT '1', 2, 3]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1, 2.0E0, 3]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1.0E0, 2.5E0, 3.0E0]")))).isEqualTo(3.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY['puppies', 'kittens']")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("puppies");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[TRUE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, FALSE]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).matches("TIMESTAMP '2020-05-10 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[2.1, 2.2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[2.111111222111111114111, 2.22222222222222222, 2.222222222222223]")))).isEqualTo(SqlDecimal.decimal((String)"2.222222222222223000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[1.9, 2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"0000000002.3", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[2.22222222222222222, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.30000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(NaN()), ROW(2), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(2), ROW(NaN()), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(2), ROW(3), ROW(NaN())]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, ROW(NaN()), ROW(1)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(NaN()), NULL, ROW(3.0)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(1.0E0), NULL, ROW(3)]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(1.0), ROW(NaN()), ROW(3)]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE})).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(CAST(NaN() AS REAL)), ROW(REAL '2'), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(REAL '2'), ROW(CAST(NaN() AS REAL)), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(REAL '2'), ROW(REAL '3'), ROW(CAST(NaN() AS REAL))]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, ROW(CAST(NaN() AS REAL)), ROW(REAL '1')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(CAST(NaN() AS REAL)), NULL, ROW(REAL '3')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(REAL '1'), NULL, ROW(REAL '3')]")))).isNull((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ROW(REAL '1'), ROW(CAST(NaN() AS REAL)), ROW(REAL '3')]")))).hasType((Type)RowType.anonymousRow((Type[])new Type[]{RealType.REAL})).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[NaN()], ARRAY[2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[2], ARRAY[NaN()], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[2], ARRAY[3], ARRAY[NaN()]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, ARRAY[NaN()], ARRAY[1]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[NaN()], NULL, ARRAY[3.0]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[1.0E0], NULL, ARRAY[3]]")))).isNull((Type)new ArrayType((Type)DoubleType.DOUBLE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[1.0], ARRAY[NaN()], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '2'], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[REAL '2'], ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[REAL '2'], ARRAY[REAL '3'], ARRAY[CAST(NaN() AS REAL)]]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[NULL, ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '1']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[CAST(NaN() AS REAL)], NULL, ARRAY[REAL '3']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[REAL '1'], NULL, ARRAY[REAL '3']]")))).isNull((Type)new ArrayType((Type)RealType.REAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_max", "ARRAY[ARRAY[REAL '1'], ARRAY[CAST(NaN() AS REAL)], ARRAY[REAL '3']]")))).hasType((Type)new ArrayType((Type)RealType.REAL)).isEqualTo(ImmutableList.of((Object)Float.valueOf(3.0f)));
    }

    @Test
    public void testArrayPosition() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[10, 20, 30, 40]", "30")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "CAST(JSON '[]' as array(bigint))", "30")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[CAST(NULL as bigint)]", "30")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[CAST(NULL as bigint), NULL, NULL]", "30")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[NULL, NULL, 30, NULL]", "30")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.1E0, 2.1E0, 3.1E0, 4.1E0]", "3.1E0")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[false, false, true, true]", "true")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY['10', '20', '30', '40']", "'30'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[DATE '2000-01-01', DATE '2000-01-02', DATE '2000-01-03', DATE '2000-01-04']", "DATE '2000-01-03'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[ARRAY[1, 11], ARRAY[2, 12], ARRAY[3, 13], ARRAY[4, 14]]", "ARRAY[3, 13]")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[]", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[NULL]", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1, NULL, 2]", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1, CAST(NULL AS BIGINT), 2]", "CAST(NULL AS BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1, NULL, 2]", "CAST(NULL AS BIGINT)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1, CAST(NULL AS BIGINT), 2]", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.0, 2.0, 3.0, 4.0]", "3.0")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.0, 2.0, 000000000000000000000003.000, 4.0]", "3.0")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.0, 2.0, 3.0, 4.0]", "000000000000000000000003.000")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.0, 2.0, 3.0, 4.0]", "3")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[1.0, 2.0, 3, 4.0]", "4.0")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[ARRAY[1]]", "ARRAY[1]")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_position", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']", "TIMESTAMP '1111-05-10 12:34:56.123456789'")))).isEqualTo(2L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_position", "ARRAY[ARRAY[null]]", "ARRAY[1]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_position", "ARRAY[ARRAY[null]]", "ARRAY[null]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testSubscript() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[1]").binding("a", "ARRAY[]").evaluate()).hasMessage("Array subscript must be less than or equal to array length: 1 > 0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[-1]").binding("a", "ARRAY[null]").evaluate()).hasMessage("Array subscript is negative: -1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[0]").binding("a", "ARRAY[1, 2, 3]").evaluate()).hasMessage("SQL array indices start at 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[-1]").binding("a", "ARRAY[1, 2, 3]").evaluate()).hasMessage("Array subscript is negative: -1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[4]").binding("a", "ARRAY[1, 2, 3]").evaluate()).hasMessage("Array subscript must be less than or equal to array length: 4 > 3");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[1.1E0]").binding("a", "ARRAY[1, 2, 3]").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot use double for subscript of array(integer)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY[NULL, NULL, NULL]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[2, 1, 3]")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[2, NULL, 3]")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY[1.0E0, 2.5E0, 3.5E0]")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[ARRAY[1, 2], NULL, ARRAY[3]]")))).isNull((Type)new ArrayType((Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2][1]").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY['puppies', 'kittens']")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY['puppies', 'kittens', NULL]")))).isNull((Type)VarcharType.createVarcharType((int)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).matches("TIMESTAMP '1111-05-10 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[infinity()]")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[-infinity()]")))).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[sqrt(-1)]")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY[2.1, 2.2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY[2.111111222111111114111, 2.22222222222222222, 2.222222222222223]")))).isEqualTo(SqlDecimal.decimal((String)"2.222222222222223000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "ARRAY[1.9, 2, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"0000000002.3", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "ARRAY[2.22222222222222222, 2.3]")))).isEqualTo(SqlDecimal.decimal((String)"2.22222222222222222", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
    }

    @Test
    public void testSubscriptReturnType() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY[true]")))).hasType((Type)JsonType.JSON).isEqualTo("true");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY[1234]")))).hasType((Type)JsonType.JSON).isEqualTo("1234");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY[1.23]")))).hasType((Type)JsonType.JSON).isEqualTo("1.23");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY['vc']")))).hasType((Type)JsonType.JSON).isEqualTo("\"vc\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000000001']")))).hasType((Type)JsonType.JSON).isEqualTo("\"1970-01-01 00:00:00.000000001\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a[1] AS JSON)").binding("a", "ARRAY[ARRAY[1]]")))).hasType((Type)JsonType.JSON).isEqualTo("[1]");
    }

    @Test
    public void testElementAt() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("element_at", "ARRAY[]", "0")::evaluate).hasMessage("SQL array indices start at 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("element_at", "ARRAY[1, 2, 3]", "0")::evaluate).hasMessage("SQL array indices start at 1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[]", "1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[]", "-1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[1, 2, 3]", "4")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[1, 2, 3]", "-4")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[NULL]", "1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[NULL]", "-1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[NULL, NULL, NULL]", "3")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[NULL, NULL, NULL]", "-1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2, 1, 3]", "2")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2, 1, 3]", "-2")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2, NULL, 3]", "2")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2, NULL, 3]", "-2")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[BIGINT '2', 1, 3]", "-2")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2, NULL, BIGINT '3']", "-2")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[1.0E0, 2.5E0, 3.5E0]", "3")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[1.0E0, 2.5E0, 3.5E0]", "-1")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[ARRAY[1, 2], ARRAY[3]]", "2")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[ARRAY[1, 2], ARRAY[3]]", "-1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[ARRAY[1, 2], NULL, ARRAY[3]]", "2")))).isNull((Type)new ArrayType((Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[ARRAY[1, 2], NULL, ARRAY[3]]", "-2")))).isNull((Type)new ArrayType((Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ELEMENT_AT(ARRAY[ARRAY[1, 2], ARRAY[3]], 2) ", "1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ELEMENT_AT(ARRAY[ARRAY[1, 2], ARRAY[3]], -1) ", "1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ELEMENT_AT(ARRAY[ARRAY[1, 2], ARRAY[3]], 2) ", "-1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ELEMENT_AT(ARRAY[ARRAY[1, 2], ARRAY[3]], -1) ", "-1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY['puppies', 'kittens']", "2")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY['crocodiles', 'kittens']", "2")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY['puppies', 'kittens']", "-1")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY['puppies', 'kittens', NULL]", "3")))).isNull((Type)VarcharType.createVarcharType((int)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY['puppies', 'kittens', NULL]", "-1")))).isNull((Type)VarcharType.createVarcharType((int)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[TRUE, FALSE]", "2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[TRUE, FALSE]", "-1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']", "1")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']", "-2")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[infinity()]", "1")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[infinity()]", "-1")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[-infinity()]", "1")))).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[-infinity()]", "-1")))).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[sqrt(-1)]", "1")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[sqrt(-1)]", "-1")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']", "2")))).matches("TIMESTAMP '1111-05-10 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2.1, 2.2, 2.3]", "3")))).isEqualTo(SqlDecimal.decimal((String)"2.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2.111111222111111114111, 2.22222222222222222, 2.222222222222223]", "3")))).isEqualTo(SqlDecimal.decimal((String)"2.222222222222223000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[1.9, 2, 2.3]", "-1")))).isEqualTo(SqlDecimal.decimal((String)"0000000002.3", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "ARRAY[2.22222222222222222, 2.3]", "-2")))).isEqualTo(SqlDecimal.decimal((String)"2.22222222222222222", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
    }

    @Test
    public void testSort() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[2, 3, 4, 1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[2, BIGINT '3', 4, 1]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[2.3, 2.1, 2.2]")))).matches("ARRAY[2.1, 2.2, 2.3]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[2, 1.900, 2.330]")))).matches("ARRAY[1.900, 2, 2.330]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY['z', 'f', 's', 'd', 'g']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"d", (Object)"f", (Object)"g", (Object)"s", (Object)"z"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[TRUE, FALSE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[22.1E0, 11.1E0, 1.1E0, 44.1E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.1, (Object)11.1, (Object)22.1, (Object)44.1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1989-02-06 12:00:00']")))).matches("ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1989-02-06 12:00:00']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[ARRAY[1], ARRAY[2]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY[2, 3, 2, null, null, 4, 1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, null, 4, 3, 2, 2, 1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN 1 WHEN y IS NULL THEN -1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY[2, 3, 2, null, null, 4, 1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(4, 3, 2, 2, 1, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY[2, null, BIGINT '3', 4, null, 1]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(null, null, 4L, 3L, 2L, 1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY['bc', null, 'ab', 'dc', null]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)2))).isEqualTo(Arrays.asList(null, null, "dc", "bc", "ab"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN length(x) < length(y) THEN 1 WHEN length(x) = length(y) THEN 0 ELSE -1 END)").binding("a", "ARRAY['a', null, 'abcd', null, 'abc', 'zx']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(Arrays.asList(null, null, "abcd", "abc", "zx", "a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x = y THEN 0 WHEN x THEN -1 ELSE 1 END)").binding("a", "ARRAY[TRUE, null, FALSE, TRUE, null, FALSE, TRUE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(null, null, true, true, true, false, false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY[22.1E0, null, null, 11.1E0, 1.1E0, 44.1E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(null, null, 44.1, 22.1, 11.1, 1.1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN date_diff('millisecond', y, x) < 0 THEN 1 WHEN date_diff('millisecond', y, x) = 0 THEN 0 ELSE -1 END)").binding("a", "ARRAY[TIMESTAMP '1973-07-08 22:00:01', NULL, TIMESTAMP '1970-01-01 00:00:01', NULL, TIMESTAMP '1989-02-06 12:00:00']")))).matches("ARRAY[null, null, TIMESTAMP '1989-02-06 12:00:00', TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN cardinality(x) < cardinality(y) THEN 1 WHEN cardinality(x) = cardinality(y) THEN 0 ELSE -1 END)").binding("a", "ARRAY[ARRAY[2, 3, 1], null, ARRAY[4, null, 2, 1, 4], ARRAY[1, 2], null]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(Arrays.asList(null, null, Arrays.asList(4, null, 2, 1, 4), Arrays.asList(2, 3, 1), Arrays.asList(1, 2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN x IS NULL THEN -1 WHEN y IS NULL THEN 1 WHEN x < y THEN 1 WHEN x = y THEN 0 ELSE -1 END)").binding("a", "ARRAY[2.3, null, 2.1, null, 2.2]")))).matches("ARRAY[null, null, 2.3, 2.2, 2.1]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("array_sort(a, (x, y) -> CASE WHEN month(x) > month(y) THEN 1 ELSE -1 END)").binding("a", "ARRAY[TIMESTAMP '1111-06-10 12:34:56.123456789', TIMESTAMP '2020-05-10 12:34:56.123456789']")))).matches("ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-06-10 12:34:56.123456789']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[1, null, 0, null, -1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(-1, 0, 1, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_sort", "ARRAY[1, null, null, -1, 0]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(-1, 0, 1, null, null));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_sort", "ARRAY[color('red'), color('blue')]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("array_sort(a, (x, y) -> y - x)").binding("a", "ARRAY[2, 1, 2, 4]").evaluate()).hasMessage("Lambda comparator must return either -1, 0, or 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("array_sort(a, (x, y) -> x / COALESCE(y, 0))").binding("a", "ARRAY[1, 2]").evaluate()).hasMessage("Lambda comparator must return either -1, 0, or 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("array_sort(a, (x, y) -> IF(x > y, NULL, IF(x = y, 0, -1)))").binding("a", "ARRAY[2, 3, 2, 4, 1]").evaluate()).hasMessage("Lambda comparator must return either -1, 0, or 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("array_sort(a, (x, y) -> x / COALESCE(y, 0))").binding("a", "ARRAY[1, null]").evaluate()).hasMessage("Lambda comparator must return either -1, 0, or 1");
    }

    @Test
    public void testReverse() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY[1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY[1, 2, 3, 4]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)4, (Object)3, (Object)2, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "array_sort(ARRAY[2, 3, 4, 1])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)4, (Object)3, (Object)2, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY[2, BIGINT '3', 4, 1]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)4L, (Object)3L, (Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY['a', 'b', 'c', 'd']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"d", (Object)"c", (Object)"b", (Object)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY[TRUE, FALSE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)4.4, (Object)3.3, (Object)2.2, (Object)1.1));
    }

    @Test
    public void testDistinct() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[0, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(0, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[0, NULL, 0, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(0, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[2, 3, 4, 3, 1, 2, 3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)3, (Object)4, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[0.0E0, NULL]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(0.0, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[2.2E0, 3.3E0, 4.4E0, 3.3E0, 1, 2.2E0, 3.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)2.2, (Object)3.3, (Object)4.4, (Object)1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[FALSE, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(false, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[FALSE, TRUE, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(false, true, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[TRUE, TRUE, TRUE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[TRUE, FALSE, FALSE, TRUE]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[TIMESTAMP '1973-07-08 22:00:01', TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']")))).hasType((Type)new ArrayType((Type)TimestampType.createTimestampType((int)0))).isEqualTo(ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0), (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY['2', '3', '2']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"2", (Object)"3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY['BB', 'CCC', 'BB']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"BB", (Object)"CCC"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[ARRAY[1], ARRAY[1, 2], ARRAY[1, 2, 3], ARRAY[1, 2]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[NULL, 2.2E0, 3.3E0, 4.4E0, 3.3E0, 1, 2.2E0, 3.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(null, 2.2, 3.3, 4.4, 1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[2, 3, NULL, 4, 3, 1, 2, 3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(2, 3, null, 4, 1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY['BB', 'CCC', 'BB', NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList("BB", "CCC", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[NULL, NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[NULL, NULL, NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[(123, 'abc'), (123, NULL)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[(NULL, NULL), (42, 'def'), (NULL, 'abc'), (123, NULL), (42, 'def'), (NULL, NULL), (NULL, 'abc'), (123, NULL)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(null, null), Arrays.asList(42, "def"), Arrays.asList(null, "abc"), Arrays.asList(123, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[CAST(5 AS BIGINT), NULL, CAST(12 AS BIGINT), NULL]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(5L, null, 12L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[CAST(100 AS BIGINT), NULL, CAST(100 AS BIGINT), NULL, 0, -2, 0]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(100L, null, 0L, -2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[2.3, 2.3, 2.2]")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"2.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_distinct", "ARRAY[2.330, 1.900, 2.330]")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)4, (int)3))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"2.330", (DecimalType)DecimalType.createDecimalType((int)4, (int)3)), (Object)SqlDecimal.decimal((String)"1.900", (DecimalType)DecimalType.createDecimalType((int)4, (int)3))));
    }

    @Test
    public void testSlice() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4, 5]", "1", "4")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2]", "1", "4")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4, 5]", "3", "2")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY['1', '2', '3', '4']", "2", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"2"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "3", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "-3", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "-3", "5")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "1", "0")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "-2", "0")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "-5", "5")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "-6", "5")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[ARRAY[1], ARRAY[2, 3], ARRAY[4, 5, 6]]", "1", "2")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[2.3, 2.3, 2.2]", "2", "3")))).matches("ARRAY[2.3, 2.2]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("slice", "ARRAY[2.330, 1.900, 2.330]", "1", "2")))).matches("ARRAY[2.330, 1.900]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "1", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("slice", "ARRAY[1, 2, 3, 4]", "0", "1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testArraysOverlap() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 2]", "ARRAY[2, 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[2, 1]", "ARRAY[2, 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[2, 1]", "ARRAY[3, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 2]", "ARRAY[3, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 3]", "ARRAY[2, 4]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[3, 1]", "ARRAY[2, 4]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[3, 1]", "ARRAY[4, 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 3]", "ARRAY[4, 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 3]", "ARRAY[2, 3, 4]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[3, 1]", "ARRAY[5, 4, 1]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 2]", "ARRAY[CAST(2 AS BIGINT), 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(2 AS BIGINT), 1]", "ARRAY[CAST(2 AS BIGINT), 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(2 AS BIGINT), 1]", "ARRAY[CAST(3 AS BIGINT), 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 2]", "ARRAY[CAST(3 AS BIGINT), 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 3]", "ARRAY[CAST(2 AS BIGINT), 4]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(3 AS BIGINT), 1]", "ARRAY[CAST(2 AS BIGINT), 4]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(3 AS BIGINT), 1]", "ARRAY[CAST(4 AS BIGINT), 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 3]", "ARRAY[CAST(4 AS BIGINT), 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY['dog', 'cat']", "ARRAY['monkey', 'dog']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY['dog', 'cat']", "ARRAY['monkey', 'fox']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 2]", "ARRAY[NULL, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[1, 2]", "ARRAY[2, NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[2, 1]", "ARRAY[NULL, 3]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[2, 1]", "ARRAY[3, NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[NULL, 2]", "ARRAY[1, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[2, NULL]", "ARRAY[1, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[NULL, 3]", "ARRAY[2, 1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[3, NULL]", "ARRAY[2, 1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 2]", "ARRAY[NULL, CAST(2 AS BIGINT)]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(1 AS BIGINT), 2]", "ARRAY[CAST(2 AS BIGINT), NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(2 AS BIGINT), 1]", "ARRAY[CAST(3 AS BIGINT), NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(2 AS BIGINT), 1]", "ARRAY[NULL, CAST(3 AS BIGINT)]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[NULL, CAST(2 AS BIGINT)]", "ARRAY[CAST(1 AS BIGINT), 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(2 AS BIGINT), NULL]", "ARRAY[CAST(1 AS BIGINT), 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[CAST(3 AS BIGINT), NULL]", "ARRAY[CAST(2 AS BIGINT), 1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[NULL, CAST(3 AS BIGINT)]", "ARRAY[CAST(2 AS BIGINT), 1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY['dog', 'cat']", "ARRAY[NULL, 'dog']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY['dog', 'cat']", "ARRAY['monkey', NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[NULL, 'dog']", "ARRAY['dog', 'cat']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY['monkey', NULL]", "ARRAY['dog', 'cat']")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[ARRAY[1, 2], ARRAY[3]]", "ARRAY[ARRAY[4], ARRAY[1, 2]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[ARRAY[1, 2], ARRAY[3]]", "ARRAY[ARRAY[4], NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[ARRAY[2], ARRAY[3]]", "ARRAY[ARRAY[4], ARRAY[1, 2]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[]", "ARRAY[]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[]", "ARRAY[1, 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[]", "ARRAY[NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[true]", "ARRAY[true, false]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[false]", "ARRAY[true, true]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[true, false]", "ARRAY[NULL]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("arrays_overlap", "ARRAY[false]", "ARRAY[true, NULL]")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testArrayIntersect() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[5]", "ARRAY[5]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[1, 2, 5, 5, 6]", "ARRAY[5, 5, 6, 6, 7, 8]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)5, (Object)6));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[IF (RAND() < 1.0E0, 7, 1) , 2]", "ARRAY[7]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[CAST(5 AS BIGINT), CAST(5 AS BIGINT)]", "ARRAY[CAST(1 AS BIGINT), CAST(5 AS BIGINT)]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)5L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[1, 5]", "ARRAY[1.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[1.0E0, 5.0E0]", "ARRAY[5.0E0, 5.0E0, 6.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[8.3E0, 1.6E0, 4.1E0, 5.2E0]", "ARRAY[4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.2, (Object)8.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[5.1E0, 7, 3.0E0, 4.8E0, 10]", "ARRAY[6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)10.0, (Object)5.1, (Object)4.8));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[2.3, 2.3, 2.2]", "ARRAY[2.2, 2.3]")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"2.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[2.330, 1.900, 2.330]", "ARRAY[2.3300, 1.9000]")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)5, (int)4))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"2.3300", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)), (Object)SqlDecimal.decimal((String)"1.9000", (DecimalType)DecimalType.createDecimalType((int)5, (int)4))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[2, 3]", "ARRAY[2.0, 3.0]")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)11, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"00000000002.0", (DecimalType)DecimalType.createDecimalType((int)11, (int)1)), (Object)SqlDecimal.decimal((String)"00000000003.0", (DecimalType)DecimalType.createDecimalType((int)11, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[true]", "ARRAY[true]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[true, false]", "ARRAY[true]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[true, true]", "ARRAY[true, true]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['abc']", "ARRAY['abc', 'bcd']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['abc', 'abc']", "ARRAY['abc', 'abc']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['foo', 'bar', 'baz']", "ARRAY['foo', 'test', 'bar']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"foo", (Object)"bar"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY[5]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[5, 6]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[1]", "ARRAY[5]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[CAST(1 AS BIGINT)]", "ARRAY[CAST(5 AS BIGINT)]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[true, true]", "ARRAY[false]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY[false]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[5]", "ARRAY[1.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['abc']", "ARRAY[]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY['abc', 'bcd']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY[]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[NULL]", "ARRAY[NULL, NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[0, 0, 1, NULL]", "ARRAY[0, 0, 1, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(0, 1, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[0, 0]", "ARRAY[0, 0, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[CAST(0 AS BIGINT), CAST(0 AS BIGINT)]", "ARRAY[CAST(0 AS BIGINT), NULL]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[0.0E0]", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[0.0E0, NULL]", "ARRAY[0.0E0, NULL]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(0.0, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[true, true, false, false, NULL]", "ARRAY[true, false, false, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(true, false, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[false, false]", "ARRAY[false, false, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['abc']", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['']", "ARRAY['', NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))).isEqualTo(ImmutableList.of((Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['', NULL]", "ARRAY['', NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))).isEqualTo(Arrays.asList("", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[NULL]", "ARRAY['abc', NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Collections.singletonList(null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY['abc', NULL, 'xyz', NULL]", "ARRAY[NULL, 'abc', NULL, NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList("abc", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[]", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[NULL]", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Collections.singletonList(null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 456), (123, 789)]", "ARRAY[(123, 456), (123, 456), (123, 789)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[ARRAY[123, 456], ARRAY[123, 789]]", "ARRAY[ARRAY[123, 456], ARRAY[123, 456], ARRAY[123, 789]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of(Arrays.asList(123, 456), Arrays.asList(123, 789)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc'), (123, 'cde')]", "ARRAY[(123, 'abc'), (123, 'cde')]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc'), (123, 'cde'), NULL]", "ARRAY[(123, 'abc'), (123, 'cde')]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, "cde")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc'), (123, 'cde'), NULL, NULL]", "ARRAY[(123, 'abc'), (123, 'cde'), NULL]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(Arrays.asList(Arrays.asList(123, "abc"), Arrays.asList(123, "cde"), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc'), (123, 'abc')]", "ARRAY[(123, 'abc'), (123, NULL)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc')]", "ARRAY[(123, NULL)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 'abc'), (123, NULL)]", "ARRAY[(123, 'abc'), (123, NULL)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(123, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(NULL, 'abc'), (123, 'abc')]", "ARRAY[(123, 'abc'),(NULL, 'abc')]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(null, "abc"), Arrays.asList(123, "abc")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(NULL, 'abc'), (123, 'abc'), (NULL, 'def'), (NULL, 'abc')]", "ARRAY[(123, 'abc'), (NULL, 'abc'), (123, 'def'), (123, 'abc'), (123, 'abc'), (123, 'abc'), (123, 'abc'), (NULL, 'abc'), (NULL, 'abc'), (NULL, 'abc')]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)3))))).isEqualTo(ImmutableList.of(Arrays.asList(123, "abc"), Arrays.asList(null, "abc")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_intersect", "ARRAY[(123, 456), (123, NULL), (42, 43)]", "ARRAY[(123, NULL), (123, 456), (42, NULL), (NULL, 43)]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of(Arrays.asList(123, null), Arrays.asList(123, 456)));
    }

    @Test
    public void testArrayUnion() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[CAST(10 as bigint), NULL, CAST(12 as bigint), NULL]", "ARRAY[NULL, CAST(10 as bigint), NULL, NULL]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(10L, null, 12L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[12]", "ARRAY[10]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)12, (Object)10));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY['foo', 'bar', 'baz']", "ARRAY['foo', 'test', 'bar']")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"test"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[NULL]", "ARRAY[NULL, NULL]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY['abc', NULL, 'xyz', NULL]", "ARRAY[NULL, 'abc', NULL, NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList("abc", null, "xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[1, 5]", "ARRAY[1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[1, 1, 2, 4]", "ARRAY[1, 1, 4, 4]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[2, 8]", "ARRAY[8, 3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)8, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[IF (RAND() < 1.0E0, 7, 1) , 2]", "ARRAY[7]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)7, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[1, 5]", "ARRAY[1.0E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)5.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[8.3E0, 1.6E0, 4.1E0, 5.2E0]", "ARRAY[4.0E0, 5.2E0, 8.3E0, 9.7E0, 3.5E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)8.3, (Object)1.6, (Object)4.1, (Object)5.2, (Object)4.0, (Object)9.7, (Object)3.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[5.1E0, 7, 3.0E0, 4.8E0, 10]", "ARRAY[6.5E0, 10.0E0, 1.9E0, 5.1E0, 3.9E0, 4.8E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)5.1, (Object)7.0, (Object)3.0, (Object)4.8, (Object)10.0, (Object)6.5, (Object)1.9, (Object)3.9));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[ARRAY[4, 5], ARRAY[6, 7]]", "ARRAY[ARRAY[4, 5], ARRAY[6, 8]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)4, (Object)5), (Object)ImmutableList.of((Object)6, (Object)7), (Object)ImmutableList.of((Object)6, (Object)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[NaN()]", "ARRAY[NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_union", "ARRAY[1, NaN(), 3]", "ARRAY[1, NaN()]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)Double.NaN, (Object)3.0));
    }

    @Test
    public void testComparison() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1, 2, 3]").binding("b", "ARRAY[1, 2, 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1, 2, 3]").binding("b", "ARRAY[1, 2, 3]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[timestamp '2012-10-31 08:00 UTC']").binding("b", "ARRAY[timestamp '2012-10-31 01:00 America/Los_Angeles']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[timestamp '2012-10-31 08:00 UTC']").binding("b", "ARRAY[timestamp '2012-10-31 01:00 America/Los_Angeles']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.1]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.1]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1, 2, null]").binding("b", "ARRAY[1, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['1', '2', null]").binding("b", "ARRAY['1', null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0, 2.0, null]").binding("b", "ARRAY[1.0, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0E0, 2.0E0, null]").binding("b", "ARRAY[1.0E0, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1, 2, null]").binding("b", "ARRAY[1, 2, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['1', '2', null]").binding("b", "ARRAY['1', '2', null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0, 2.0, null]").binding("b", "ARRAY[1.0, 2.0, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0E0, 2.0E0, null]").binding("b", "ARRAY[1.0E0, 2.0E0, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1, 3, null]").binding("b", "ARRAY[1, 2, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1E0, 3E0, null]").binding("b", "ARRAY[1E0, 2E0, null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['1', '3', null]").binding("b", "ARRAY['1', '2', null]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[ARRAY[1], ARRAY[null], ARRAY[2]]").binding("b", "ARRAY[ARRAY[1], ARRAY[2], ARRAY[3]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[ARRAY[1], ARRAY[null], ARRAY[3]]").binding("b", "ARRAY[ARRAY[1], ARRAY[2], ARRAY[3]]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[5]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[5]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1, 2, 3]").binding("b", "ARRAY[3, 2, 1]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1, 2, 3]").binding("b", "ARRAY[3, 2, 1]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[FALSE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[FALSE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0]").binding("b", "ARRAY[11.1E0, 22.1E0, 1.1E0, 44.1E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0]").binding("b", "ARRAY[11.1E0, 22.1E0, 1.1E0, 44.1E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['z', 'f', 's', 'd', 'g']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['z', 'f', 's', 'd', 'g']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5, 6]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5, 6]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2, 3], ARRAY[4, 5]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2, 3], ARRAY[4, 5]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1, 2, null]").binding("b", "ARRAY[1, 2, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1, 2, null]").binding("b", "ARRAY[1, null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[1, 3, null]").binding("b", "ARRAY[1, 2, null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[ARRAY[1], ARRAY[null], ARRAY[2]]").binding("b", "ARRAY[ARRAY[1], ARRAY[2], ARRAY[3]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ARRAY[ARRAY[1], ARRAY[null], ARRAY[3]]").binding("b", "ARRAY[ARRAY[1], ARRAY[2], ARRAY[3]]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 40, 50]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 40, 50]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 40]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 40]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[10, 20]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[10, 20]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, TRUE, TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, TRUE, TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TRUE, FALSE, FALSE]").binding("b", "ARRAY[TRUE, TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TRUE, FALSE, FALSE]").binding("b", "ARRAY[TRUE, TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 4.4E0, 4.4E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 4.4E0, 4.4E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 5.5E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 5.5E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.1E0, 2.2E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 5.5E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.1E0, 2.2E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 5.5E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards', 'lizards']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards', 'lizards']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens', 'lizards']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens', 'lizards']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5, 6]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5, 6]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 5, 6]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 5, 6]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.1]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1.0, 2.0, 3.0]").binding("b", "ARRAY[1.0, 2.0, 3.1]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1234567890.1234567890, 0]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]").binding("b", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 20]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 20]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TRUE, TRUE, TRUE]").binding("b", "ARRAY[TRUE, TRUE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TRUE, TRUE, TRUE]").binding("b", "ARRAY[TRUE, TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TRUE, TRUE, FALSE]").binding("b", "ARRAY[TRUE, TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TRUE, TRUE, FALSE]").binding("b", "ARRAY[TRUE, TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 2.2E0, 4.4E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 2.2E0, 4.4E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:20.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:20.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 3, 4]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 3, 4]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[50]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[50]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE, true]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE, true]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TRUE, FALSE]").binding("b", "ARRAY[TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[2.2E0, 5.5E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[2.2E0, 5.5E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'lizards']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '04:05:06.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 5, 6]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 5, 6]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[10, 20, 30]").binding("b", "ARRAY[10, 20, 30]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE, FALSE, TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE, FALSE, TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TRUE, FALSE, TRUE]").binding("b", "ARRAY[TRUE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]").binding("b", "ARRAY[1.1E0, 2.2E0, 3.3E0, 4.4E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY['puppies', 'kittens', 'lizards']").binding("b", "ARRAY['puppies', 'kittens', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY['puppies', 'kittens']").binding("b", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00', TIME '10:20:30.456-08:00']").binding("b", "ARRAY[TIME '01:02:03.456-08:00', TIME '10:20:30.456-08:00']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]").binding("b", "ARRAY[ARRAY[1, 2], ARRAY[3, 4, 5]]")))).isEqualTo(false);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS ARRAY(UNKNOWN))", "CAST(NULL AS ARRAY(UNKNOWN))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[NULL]", "ARRAY[NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "ARRAY[1, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2]", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2]", "ARRAY[1, 2]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2, 3]", "ARRAY[1, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2]", "ARRAY[1, NULL]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2]", "ARRAY[1, 3]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, NULL]", "ARRAY[1, NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, NULL]", "ARRAY[1, NULL]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[1, 2, NULL]", "ARRAY[1, 2]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[TRUE, FALSE]", "ARRAY[TRUE, FALSE]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[TRUE, NULL]", "ARRAY[TRUE, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[FALSE, NULL]", "ARRAY[NULL, FALSE]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY['puppies', 'kittens']", "ARRAY['puppies', 'kittens']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY['puppies', NULL]", "ARRAY['puppies', 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY['puppies', NULL]", "ARRAY[NULL, 'kittens']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[ARRAY['puppies'], ARRAY['kittens']]", "ARRAY[ARRAY['puppies'], ARRAY['kittens']]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[ARRAY['puppies'], NULL]", "ARRAY[ARRAY['puppies'], ARRAY['kittens']]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[ARRAY['puppies'], NULL]", "ARRAY[NULL, ARRAY['kittens']]")))).isEqualTo(true);
    }

    @Test
    public void testArrayRemove() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'bar', 'baz']", "'foo'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"bar", (Object)"baz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'bar', 'baz']", "'bar'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"foo", (Object)"baz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'bar', 'baz']", "'baz'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"foo", (Object)"bar"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'bar', 'baz']", "'zzz'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'foo', 'foo']", "'foo'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[NULL, 'bar', 'baz']", "'foo'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList(null, "bar", "baz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY['foo', 'bar', NULL]", "'foo'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList("bar", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, 2, 3]", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, 2, 3]", "2")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, 2, 3]", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, 2, 3]", "4")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, 1, 1]", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[NULL, 2, 3]", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, 2, 3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1, NULL, 3]", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, 3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[-1.23E0, 3.14E0]", "3.14E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-1.23));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[3.14E0]", "0.0E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.14));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[sqrt(-1), 3.14E0]", "3.14E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[-1.23E0, sqrt(-1)]", "nan()")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-1.23, (Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[-1.23E0, nan()]", "nan()")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)-1.23, (Object)Double.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[-1.23E0, infinity()]", "-1.23E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[infinity(), 3.14E0]", "infinity()")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)3.14));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[-1.23E0, NULL, 3.14E0]", "3.14E0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(-1.23, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[TRUE, FALSE, TRUE]", "TRUE")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[TRUE, FALSE, TRUE]", "FALSE")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[NULL, FALSE, TRUE]", "TRUE")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(null, false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[ARRAY['foo'], ARRAY['bar'], ARRAY['baz']]", "ARRAY['bar']")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"foo"), (Object)ImmutableList.of((Object)"baz")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1.0, 2.0, 3.0]", "2.0")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1.0, 2.0, 3.0]", "4.0")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", "1234567890.1234567890")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)10))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"9876543210.9876543210", (DecimalType)DecimalType.createDecimalType((int)22, (int)10)), (Object)SqlDecimal.decimal((String)"123123123456.6549876543", (DecimalType)DecimalType.createDecimalType((int)22, (int)10))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_remove", "ARRAY[1234567890.1234567890, 9876543210.9876543210, 123123123456.6549876543]", "4.0")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)22, (int)10))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1234567890.1234567890", (DecimalType)DecimalType.createDecimalType((int)22, (int)10)), (Object)SqlDecimal.decimal((String)"9876543210.9876543210", (DecimalType)DecimalType.createDecimalType((int)22, (int)10)), (Object)SqlDecimal.decimal((String)"123123123456.6549876543", (DecimalType)DecimalType.createDecimalType((int)22, (int)10))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_remove", "ARRAY[ARRAY[CAST(null AS BIGINT)]]", "ARRAY[CAST(1 AS BIGINT)]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_remove", "ARRAY[ARRAY[CAST(null AS BIGINT)]]", "ARRAY[CAST(null AS BIGINT)]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("array_remove", "ARRAY[ARRAY[CAST(1 AS BIGINT)]]", "ARRAY[CAST(null AS BIGINT)]")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testRepeat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "1", "5")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)1, (Object)1, (Object)1, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "'varchar'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"varchar", (Object)"varchar", (Object)"varchar"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "true", "1")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "0.5E0", "4")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)0.5, (Object)0.5, (Object)0.5, (Object)0.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "array[1]", "4")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "null", "4")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as bigint)", "4")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as double)", "4")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as varchar)", "4")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as boolean)", "4")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as array(boolean))", "4")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))).isEqualTo(Arrays.asList(null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "CAST(null as bigint)", "0")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "1", "0")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "'varchar'", "0")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "true", "0")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "0.5E0", "0")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("repeat", "array[1]", "0")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("repeat", "2", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("repeat", "1", "1000000")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("repeat", "'loooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooongvarchar'", "9999")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("repeat", "array[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]", "9999")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(null as array(bigint))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[1,2,3]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[1,2,3,null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array['test1', 'test2', 'test3', 'test4']")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array['test1', 'test2', 'test3', null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array['test1', null, 'test2', 'test3']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[null, 'test1', 'test2', 'test3']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[null, time '12:34:56', time '01:23:45']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[null, timestamp '2016-01-02 12:34:56', timestamp '2016-12-23 01:23:45']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[null, null, null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[row(1), row(2), row(3)]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[CAST(row(1) as row(a bigint)), CAST(null as row(a bigint)), CAST(row(3) as row(a bigint))]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[CAST(row(1) as row(a bigint)), CAST(row(null) as row(a bigint)), CAST(row(3) as row(a bigint))]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), map(array[1], array[-1])]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[map(array[2], array[-2]), map(array[1], array[null])]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[array[1], array[2], array[3]]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[array[1], array[null], array[3]]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[array[1], array[2], null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[1E0, 2E0, null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[1E0, 2E0, 3E0]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[true, false, null]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "array[true, false, true]")))).isEqualTo(false);
    }

    @Test
    public void testSequence() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "1", "5")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-10", "-5")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-10L, (Object)-9L, (Object)-8L, (Object)-7L, (Object)-6L, (Object)-5L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-5", "2")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-5L, (Object)-4L, (Object)-3L, (Object)-2L, (Object)-1L, (Object)0L, (Object)1L, (Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "2", "2")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-04-14'")))).matches("ARRAY[DATE '2016-04-12', DATE '2016-04-13', DATE '2016-04-14']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "5", "1")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)5L, (Object)4L, (Object)3L, (Object)2L, (Object)1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-5", "-10")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-5L, (Object)-6L, (Object)-7L, (Object)-8L, (Object)-9L, (Object)-10L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "2", "-5")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)2L, (Object)1L, (Object)0L, (Object)-1L, (Object)-2L, (Object)-3L, (Object)-4L, (Object)-5L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-14'", "DATE '2016-04-12'")))).matches("ARRAY[DATE '2016-04-14', DATE '2016-04-13', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "1", "9", "4")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L, (Object)5L, (Object)9L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-10", "-5", "2")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-10L, (Object)-8L, (Object)-6L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-5", "2", "3")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-5L, (Object)-2L, (Object)1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "2", "2", "2")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "5", "1", "-1")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)5L, (Object)4L, (Object)3L, (Object)2L, (Object)1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "10", "2", "-2")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)10L, (Object)8L, (Object)6L, (Object)4L, (Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "9223372036854775807", "-9223372036854775808", "-9223372036854775807")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)Long.MAX_VALUE, (Object)0L, (Object)-9223372036854775807L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "9223372036854775807", "-9223372036854775808", "-9223372036854775808")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)Long.MAX_VALUE, (Object)-1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-9223372036854775808", "9223372036854775807", "9223372036854775807")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)Long.MIN_VALUE, (Object)-1L, (Object)0x7FFFFFFFFFFFFFFEL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-9223372036854775808", "-2", "9223372036854775807")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)Long.MIN_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-5", "5", "1000")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-5L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-5", "5", "7")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-5L, (Object)2L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "-100", "5", "100")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)-100L, (Object)0L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "2", "-1", "1")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-1", "-10", "1")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "1", "1000000")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2000-04-14'", "DATE '2030-04-12'")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "9223372036854775807", "-9223372036854775808", "-100")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "9223372036854775807", "-9223372036854775808", "-1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-9223372036854775808", "9223372036854775807", "100")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-9223372036854775808", "9223372036854775807", "1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-9223372036854775808", "0", "100")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-9223372036854775808", "0", "1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "9223372036854775807", "0", "-1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "0", "9223372036854775807", "1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "0", "-9223372036854775808", "-1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "-5000", "5000")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "5000", "-5000", "-1")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testSequenceDateTimeDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-04-14'", "interval '1' day")))).matches("ARRAY[DATE '2016-04-12', DATE '2016-04-13', DATE '2016-04-14']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-14'", "DATE '2016-04-12'", "interval '-1' day")))).matches("ARRAY[DATE '2016-04-14', DATE '2016-04-13', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-04-16'", "interval '2' day")))).matches("ARRAY[DATE '2016-04-12', DATE '2016-04-14', DATE '2016-04-16']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-16'", "DATE '2016-04-12'", "interval '-2' day")))).matches("ARRAY[DATE '2016-04-16', DATE '2016-04-14', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-16 01:07:00'", "interval '3' minute")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10', TIMESTAMP '2016-04-16 01:03:10', TIMESTAMP '2016-04-16 01:06:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:10:10'", "timestamp '2016-04-16 01:03:00'", "interval '-3' minute")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:10:10', TIMESTAMP '2016-04-16 01:07:10', TIMESTAMP '2016-04-16 01:04:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-16 01:01:00'", "interval '20' second")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10',TIMESTAMP '2016-04-16 01:00:30',TIMESTAMP '2016-04-16 01:00:50']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:01:10'", "timestamp '2016-04-16 01:00:20'", "interval '-20' second")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:01:10', TIMESTAMP '2016-04-16 01:00:50', TIMESTAMP '2016-04-16 01:00:30']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-18 01:01:00'", "interval '19' hour")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10',TIMESTAMP '2016-04-16 20:00:10',TIMESTAMP '2016-04-17 15:00:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-14 01:00:20'", "interval '-19' hour")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10',TIMESTAMP '2016-04-15 06:00:10',TIMESTAMP '2016-04-14 11:00:10']");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-04-14'", "interval '-1' day")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2016-04-14'", "DATE '2016-04-12'", "interval '1' day")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2000-04-14'", "DATE '2030-04-12'", "interval '1' day")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2018-01-01'", "DATE '2018-01-04'", "interval '18' hour")::evaluate).hasMessage("sequence step must be a day interval if start and end values are dates");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-16 01:01:00'", "interval '-20' second")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-04-16 01:10:10'", "timestamp '2016-04-16 01:01:00'", "interval '20' second")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-04-16 09:01:00'", "interval '1' second")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testSequenceDateTimeYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-06-12'", "interval '1' month")))).matches("ARRAY[DATE '2016-04-12', DATE '2016-05-12', DATE '2016-06-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-06-12'", "DATE '2016-04-12'", "interval '-1' month")))).matches("ARRAY[DATE '2016-06-12', DATE '2016-05-12', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-08-12'", "interval '2' month")))).matches("ARRAY[DATE '2016-04-12', DATE '2016-06-12', DATE '2016-08-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-08-12'", "DATE '2016-04-12'", "interval '-2' month")))).matches("ARRAY[DATE '2016-08-12', DATE '2016-06-12', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2018-04-12'", "interval '1' year")))).matches("ARRAY[DATE '2016-04-12', DATE '2017-04-12', DATE '2018-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "DATE '2018-04-12'", "DATE '2016-04-12'", "interval '-1' year")))).matches("ARRAY[DATE '2018-04-12', DATE '2017-04-12', DATE '2016-04-12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2016-09-16 01:10:00'", "interval '2' month")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10',TIMESTAMP '2016-06-16 01:00:10',TIMESTAMP '2016-08-16 01:00:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-09-16 01:10:10'", "timestamp '2016-04-16 01:00:00'", "interval '-2' month")))).matches("ARRAY[TIMESTAMP '2016-09-16 01:10:10', TIMESTAMP '2016-07-16 01:10:10', TIMESTAMP '2016-05-16 01:10:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '2021-04-16 01:01:00'", "interval '2' year")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:00:10', TIMESTAMP '2018-04-16 01:00:10', TIMESTAMP '2020-04-16 01:00:10']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sequence", "timestamp '2016-04-16 01:01:10'", "timestamp '2011-04-16 01:00:00'", "interval '-2' year")))).matches("ARRAY[TIMESTAMP '2016-04-16 01:01:10', TIMESTAMP '2014-04-16 01:01:10', TIMESTAMP '2012-04-16 01:01:10']");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2016-06-12'", "DATE '2016-04-12'", "interval '1' month")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2016-04-12'", "DATE '2016-06-12'", "interval '-1' month")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "DATE '2000-04-12'", "DATE '3000-06-12'", "interval '1' month")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-05-16 01:00:10'", "timestamp '2016-04-16 01:01:00'", "interval '1' month")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-04-16 01:10:10'", "timestamp '2016-05-16 01:01:00'", "interval '-1' month")::evaluate).hasMessage("sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("sequence", "timestamp '2016-04-16 01:00:10'", "timestamp '3000-04-16 09:01:00'", "interval '1' month")::evaluate).hasMessage("result of sequence function must not have more than 10000 entries");
    }

    @Test
    public void testFlatten() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[TRUE, FALSE], ARRAY[FALSE]]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[TRUE, FALSE], NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[TRUE, FALSE]]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[TRUE, FALSE]]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[TRUE], ARRAY[FALSE], ARRAY[TRUE, FALSE]]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false, (Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[TRUE], NULL, ARRAY[FALSE], ARRAY[FALSE, TRUE]]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false, (Object)false, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY['1', '2'], ARRAY['3']]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY['1', '2'], NULL]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"1", (Object)"2"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY['1', '2']]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"1", (Object)"2"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY['0'], ARRAY['1'], ARRAY['2', '3']]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY['0'], NULL, ARRAY['1'], ARRAY['2', '3']]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[1, 2], ARRAY[3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[1, 2], NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[1, 2]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[0], ARRAY[1], ARRAY[2, 3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[0], NULL, ARRAY[1], ARRAY[2, 3]]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[1.2E0, 2.2E0], ARRAY[3.2E0]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.2, (Object)2.2, (Object)3.2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[1.2E0, 2.2E0], NULL]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.2, (Object)2.2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[1.2E0, 2.2E0]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.2, (Object)2.2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[0.2E0], ARRAY[1.2E0], ARRAY[2.2E0, 3.2E0]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)0.2, (Object)1.2, (Object)2.2, (Object)3.2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[0.2E0], NULL, ARRAY[1.2E0], ARRAY[2.2E0, 3.2E0]]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)0.2, (Object)1.2, (Object)2.2, (Object)3.2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[ARRAY[1, 2], ARRAY[3, 4]], ARRAY[ARRAY[5, 6], ARRAY[7, 8]]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)5, (Object)6), (Object)ImmutableList.of((Object)7, (Object)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[ARRAY[1, 2], ARRAY[3, 4]], NULL]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[ARRAY[5, 6], ARRAY[7, 8]]]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)5, (Object)6), (Object)ImmutableList.of((Object)7, (Object)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[MAP(ARRAY[1, 2], ARRAY[1, 2])], ARRAY[MAP(ARRAY[3, 4], ARRAY[3, 4])]]")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2), (Object)ImmutableMap.of((Object)3, (Object)3, (Object)4, (Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[ARRAY[MAP(ARRAY[1, 2], ARRAY[1, 2])], NULL]")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("flatten", "ARRAY[NULL, ARRAY[MAP(ARRAY[3, 4], ARRAY[3, 4])]]")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableMap.of((Object)3, (Object)3, (Object)4, (Object)4)));
    }
}

