/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.AbstractTestType;
import io.trino.type.ColorType;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestColorArrayType
extends AbstractTestType {
    public TestColorArrayType() {
        super(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)ColorType.COLOR.getTypeSignature())), List.class, TestColorArrayType.createTestBlock(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)ColorType.COLOR.getTypeSignature()))));
    }

    public static ValueBlock createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)ColorType.COLOR, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)ColorType.COLOR, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)ColorType.COLOR, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)ColorType.COLOR, 100, 200, 300));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getPreviousValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }

    @Test
    public void testNextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getNextValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }
}

