/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestSmallintType
extends AbstractTestType {
    public TestSmallintType() {
        super((Type)SmallintType.SMALLINT, Short.class, TestSmallintType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = SmallintType.SMALLINT.createBlockBuilder(null, 15);
        SmallintType.SMALLINT.writeLong(blockBuilder, 1111L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 1111L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 1111L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 2222L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 2222L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 2222L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 2222L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 2222L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 3333L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 3333L);
        SmallintType.SMALLINT.writeLong(blockBuilder, 4444L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)-32768L);
        Assert.assertEquals((Object)range.getMax(), (Object)32767L);
    }

    @Test
    public void testPreviousValue() {
        long minValue = -32768L;
        long maxValue = 32767L;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(1110L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue - 2L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1L));
    }

    @Test
    public void testNextValue() {
        long minValue = -32768L;
        long maxValue = 32767L;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue + 2L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(1112L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

