/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class CatalogName {
    private static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    private static final String SYSTEM_TABLES_CONNECTOR_PREFIX = "$system@";
    private final String catalogName;

    @JsonCreator
    public CatalogName(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        Preconditions.checkArgument((!catalogName.isEmpty() ? 1 : 0) != 0, (Object)"catalogName is empty");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public CatalogName getActualName() {
        if (this.catalogName.startsWith(SYSTEM_TABLES_CONNECTOR_PREFIX)) {
            return new CatalogName(this.catalogName.substring(SYSTEM_TABLES_CONNECTOR_PREFIX.length()));
        }
        if (this.catalogName.startsWith(INFORMATION_SCHEMA_CONNECTOR_PREFIX)) {
            return new CatalogName(this.catalogName.substring(INFORMATION_SCHEMA_CONNECTOR_PREFIX.length()));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogName that = (CatalogName)o;
        return Objects.equals(this.catalogName, that.catalogName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName;
    }
}

