/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.ViewInfo;
import io.trino.security.AccessControl;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewSystemTable
implements SystemTable {
    private static final ConnectorTableMetadata TABLE_DEFINITION = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", "materialized_views")).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("name", (Type)VarcharType.createUnboundedVarcharType()).column("storage_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("storage_schema", (Type)VarcharType.createUnboundedVarcharType()).column("storage_table", (Type)VarcharType.createUnboundedVarcharType()).column("freshness", (Type)VarcharType.createUnboundedVarcharType()).column("last_fresh_time", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).column("comment", (Type)VarcharType.createUnboundedVarcharType()).column("definition", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public MaterializedViewSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TABLE_DEFINITION;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint, Set<Integer> requiredColumns) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder displayTable = InMemoryRecordSet.builder((ConnectorTableMetadata)this.getTableMetadata());
        Domain catalogDomain = constraint.getDomain((Object)0, (Type)VarcharType.VARCHAR);
        Domain schemaDomain = constraint.getDomain((Object)1, (Type)VarcharType.VARCHAR);
        Domain tableDomain = constraint.getDomain((Object)2, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(catalogDomain) || FilterUtil.isImpossibleObjectName(schemaDomain) || FilterUtil.isImpossibleObjectName(tableDomain)) {
            return displayTable.build().cursor();
        }
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tableDomain);
        boolean needFreshness = requiredColumns.contains(MaterializedViewSystemTable.columnIndex("freshness")) || requiredColumns.contains(MaterializedViewSystemTable.columnIndex("last_fresh_time"));
        MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogDomain).forEach(catalogName -> {
            if (schemaDomain.isNullableDiscreteSet()) {
                for (Object slice : schemaDomain.getNullableDiscreteSet().getNonNullValues()) {
                    String schemaName = ((Slice)slice).toStringUtf8();
                    if (FilterUtil.isImpossibleObjectName(schemaName)) continue;
                    this.addMaterializedViewForCatalog(session, displayTable, FilterUtil.tablePrefix(catalogName, Optional.of(schemaName), tableFilter), needFreshness);
                }
            } else {
                this.addMaterializedViewForCatalog(session, displayTable, FilterUtil.tablePrefix(catalogName, Optional.empty(), tableFilter), needFreshness);
            }
        });
        return displayTable.build().cursor();
    }

    private void addMaterializedViewForCatalog(Session session, InMemoryRecordSet.Builder displayTable, QualifiedTablePrefix tablePrefix, boolean needFreshness) {
        MetadataListing.getMaterializedViews(session, this.metadata, this.accessControl, tablePrefix).forEach((tableName, definition) -> {
            QualifiedObjectName name = new QualifiedObjectName(tablePrefix.getCatalogName(), tableName.getSchemaName(), tableName.getTableName());
            Optional<MaterializedViewFreshness> freshness = Optional.empty();
            if (needFreshness) {
                try {
                    freshness = Optional.of(this.metadata.getMaterializedViewFreshness(session, name));
                }
                catch (MaterializedViewNotFoundException e) {
                    return;
                }
            }
            Object[] materializedViewRow = MaterializedViewSystemTable.createMaterializedViewRow(name, freshness, definition);
            displayTable.addRow(materializedViewRow);
        });
    }

    private static Object[] createMaterializedViewRow(QualifiedObjectName name, Optional<MaterializedViewFreshness> freshness, ViewInfo definition) {
        return new Object[]{name.getCatalogName(), name.getSchemaName(), name.getObjectName(), definition.getStorageTable().map(CatalogSchemaTableName::getCatalogName).orElse(""), definition.getStorageTable().map(storageTable -> storageTable.getSchemaTableName().getSchemaName()).orElse(""), definition.getStorageTable().map(storageTable -> storageTable.getSchemaTableName().getTableName()).orElse(""), freshness.map(MaterializedViewFreshness::getFreshness).map(Enum::name).orElse(null), freshness.flatMap(MaterializedViewFreshness::getLastFreshTime).map(instant -> LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)instant.getEpochSecond(), (long)((long)instant.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY)).orElse(null), definition.getComment().orElse(""), definition.getOriginalSql()};
    }

    private static int columnIndex(String columnName) {
        return Math.toIntExact((Long)Streams.mapWithIndex(TABLE_DEFINITION.getColumns().stream(), (column, index) -> Map.entry(column.getName(), index)).filter(entry -> ((String)entry.getKey()).equals(columnName)).map(Map.Entry::getValue).collect(MoreCollectors.onlyElement()));
    }
}

