/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.function.LanguageFunction;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.routine.SqlRoutineAnalyzer;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class CreateFunctionTask
implements DataDefinitionTask<CreateFunction> {
    private final Optional<CatalogSchemaName> defaultFunctionSchema;
    private final SqlParser sqlParser;
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final AccessControl accessControl;
    private final LanguageFunctionManager languageFunctionManager;

    @Inject
    public CreateFunctionTask(SqlEnvironmentConfig sqlEnvironmentConfig, SqlParser sqlParser, Metadata metadata, FunctionManager functionManager, AccessControl accessControl, LanguageFunctionManager languageFunctionManager) {
        this.defaultFunctionSchema = CreateFunctionTask.defaultFunctionSchema(sqlEnvironmentConfig);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.languageFunctionManager = Objects.requireNonNull(languageFunctionManager, "languageFunctionManager is null");
    }

    @Override
    public String getName() {
        return "CREATE FUNCTION";
    }

    @Override
    public ListenableFuture<Void> execute(CreateFunction statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        FunctionSpecification function = statement.getSpecification();
        QualifiedObjectName name = CreateFunctionTask.qualifiedFunctionName(this.defaultFunctionSchema, (Node)statement, function.getName());
        this.accessControl.checkCanCreateFunction(session.toSecurityContext(), name);
        String formatted = SqlFormatter.formatSql((Node)function);
        this.verifyFormattedFunction(formatted, function);
        this.languageFunctionManager.verifyForCreate(session, formatted, this.functionManager, this.accessControl);
        String signatureToken = this.languageFunctionManager.getSignatureToken(function.getParameters());
        List<CatalogSchemaName> path = session.getPath().getPath().stream().filter(element -> !element.getCatalogName().equals("system")).toList();
        Optional owner = SqlRoutineAnalyzer.isRunAsInvoker(function) ? Optional.empty() : Optional.of(session.getUser());
        LanguageFunction languageFunction = new LanguageFunction(signatureToken, formatted, path, owner);
        boolean replace = false;
        if (this.metadata.languageFunctionExists(session, name, signatureToken)) {
            if (!statement.isReplace()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, (Node)statement, "Function already exists", new Object[0]);
            }
            this.accessControl.checkCanDropFunction(session.toSecurityContext(), name);
            replace = true;
        }
        this.metadata.createLanguageFunction(session, name, languageFunction, replace);
        return Futures.immediateVoidFuture();
    }

    private void verifyFormattedFunction(String sql, FunctionSpecification function) {
        try {
            FunctionSpecification parsed = this.sqlParser.createFunctionSpecification(sql);
            if (!function.equals((Object)parsed)) {
                throw CreateFunctionTask.formattingFailure(null, "Function does not round-trip", function, sql);
            }
        }
        catch (ParsingException e) {
            throw CreateFunctionTask.formattingFailure(e, "Formatted function does not parse", function, sql);
        }
    }

    static Optional<CatalogSchemaName> defaultFunctionSchema(SqlEnvironmentConfig config) {
        return CreateFunctionTask.combine(config.getDefaultFunctionCatalog(), config.getDefaultFunctionSchema(), CatalogSchemaName::new);
    }

    static QualifiedObjectName qualifiedFunctionName(Optional<CatalogSchemaName> functionSchema, Node node, QualifiedName name) {
        List parts = name.getParts();
        return switch (parts.size()) {
            case 1 -> {
                CatalogSchemaName schema = functionSchema.orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "Catalog and schema must be specified when function schema is not configured", new Object[0]));
                yield new QualifiedObjectName(schema.getCatalogName(), schema.getSchemaName(), (String)parts.get(0));
            }
            case 2 -> throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "Function name must be unqualified or fully qualified with catalog and schema", new Object[0]);
            case 3 -> new QualifiedObjectName((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
            default -> throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, node, "Too many dots in function name: %s", name);
        };
    }

    private static TrinoException formattingFailure(Throwable cause, String message, FunctionSpecification function, String sql) {
        TrinoException exception = new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, message, cause);
        exception.addSuppressed((Throwable)new RuntimeException("Function: " + function));
        exception.addSuppressed((Throwable)new RuntimeException("Formatted: [%s]".formatted(sql)));
        return exception;
    }

    private static <T, U, R> Optional<R> combine(Optional<T> first, Optional<U> second, BiFunction<T, U, R> combiner) {
        return first.isPresent() && second.isPresent() ? Optional.of(combiner.apply(first.get(), second.get())) : Optional.empty();
    }
}

