/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.CreateFunctionTask;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropFunction;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropFunctionTask
implements DataDefinitionTask<DropFunction> {
    private final Optional<CatalogSchemaName> functionSchema;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final LanguageFunctionManager languageFunctionManager;

    @Inject
    public DropFunctionTask(SqlEnvironmentConfig sqlEnvironmentConfig, Metadata metadata, AccessControl accessControl, LanguageFunctionManager languageFunctionManager) {
        this.functionSchema = CreateFunctionTask.defaultFunctionSchema(sqlEnvironmentConfig);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.languageFunctionManager = Objects.requireNonNull(languageFunctionManager, "languageFunctionManager is null");
    }

    @Override
    public String getName() {
        return "DROP FUNCTION";
    }

    @Override
    public ListenableFuture<Void> execute(DropFunction statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = CreateFunctionTask.qualifiedFunctionName(this.functionSchema, (Node)statement, statement.getName());
        this.accessControl.checkCanDropFunction(session.toSecurityContext(), name);
        String signatureToken = this.languageFunctionManager.getSignatureToken(statement.getParameters());
        if (!this.metadata.languageFunctionExists(session, name, signatureToken)) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, (Node)statement, "Function not found", new Object[0]);
            }
            return Futures.immediateVoidFuture();
        }
        this.metadata.dropLanguageFunction(session, name, signatureToken);
        return Futures.immediateVoidFuture();
    }
}

