/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.client.NodeVersion;
import io.trino.exchange.ExchangeInput;
import io.trino.execution.BasicStageStats;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateTimer;
import io.trino.execution.QueryStats;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.StageStats;
import io.trino.execution.StateMachine;
import io.trino.execution.TableInfo;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.operator.BlockedReason;
import io.trino.operator.OperatorStats;
import io.trino.operator.RetryPolicy;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.server.BasicQueryStats;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Output;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.tracing.TrinoAttributes;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.util.Ciphers;
import io.trino.util.Failures;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger QUERY_STATE_LOG = Logger.get(QueryStateMachine.class);
    private final QueryId queryId;
    private final String query;
    private final Optional<String> preparedQuery;
    private final Session session;
    private final URI self;
    private final ResourceGroupId resourceGroup;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final QueryOutputManager outputManager;
    private final Executor stateMachineExecutor;
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentRevocableMemory = new AtomicLong();
    private final AtomicLong peakRevocableMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();
    private final AtomicLong peakTotalMemory = new AtomicLong();
    private final AtomicLong peakTaskUserMemory = new AtomicLong();
    private final AtomicLong peakTaskRevocableMemory = new AtomicLong();
    private final AtomicLong peakTaskTotalMemory = new AtomicLong();
    private final QueryStateTimer queryStateTimer;
    private final StateMachine<QueryState> queryState;
    private final AtomicBoolean queryCleanedUp = new AtomicBoolean();
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final AtomicReference<String> setPath = new AtomicReference();
    private final AtomicReference<String> setAuthorizationUser = new AtomicReference();
    private final AtomicBoolean resetAuthorizationUser = new AtomicBoolean();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, SelectedRole> setRoles = new ConcurrentHashMap<String, SelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Optional<Output>> output = new AtomicReference(Optional.empty());
    private final AtomicReference<List<io.trino.spi.eventlistener.TableInfo>> referencedTables = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<List<RoutineInfo>> routines = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final StateMachine<Optional<QueryInfo>> finalQueryInfo;
    private final WarningCollector warningCollector;
    private final PlanOptimizersStatsCollector planOptimizersStatsCollector;
    private final Optional<QueryType> queryType;
    @GuardedBy(value="dynamicFiltersStatsSupplierLock")
    private Supplier<DynamicFilterService.DynamicFiltersStats> dynamicFiltersStatsSupplier = () -> DynamicFilterService.DynamicFiltersStats.EMPTY;
    private final Object dynamicFiltersStatsSupplierLock = new Object();
    private final AtomicBoolean committed = new AtomicBoolean();
    private final AtomicBoolean consumed = new AtomicBoolean();
    private final NodeVersion version;

    private QueryStateMachine(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, TransactionManager transactionManager, Executor stateMachineExecutor, Ticker ticker, Metadata metadata, WarningCollector warningCollector, PlanOptimizersStatsCollector queryStatsCollector, Optional<QueryType> queryType, NodeVersion version) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.self = Objects.requireNonNull(self, "self is null");
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.queryStateTimer = new QueryStateTimer(ticker);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.stateMachineExecutor = Objects.requireNonNull(stateMachineExecutor, "stateMachineExecutor is null");
        this.planOptimizersStatsCollector = Objects.requireNonNull(queryStatsCollector, "queryStatsCollector is null");
        this.queryState = new StateMachine<QueryState>("query " + query, stateMachineExecutor, QueryState.QUEUED, QueryState.TERMINAL_QUERY_STATES);
        this.finalQueryInfo = new StateMachine("finalQueryInfo-" + this.queryId, stateMachineExecutor, Optional.empty());
        this.outputManager = new QueryOutputManager(stateMachineExecutor);
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.version = Objects.requireNonNull(version, "version is null");
    }

    public static QueryStateMachine begin(Optional<TransactionId> existingTransactionId, String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Metadata metadata, WarningCollector warningCollector, PlanOptimizersStatsCollector queryStatsCollector, Optional<QueryType> queryType, boolean faultTolerantExecutionExchangeEncryptionEnabled, NodeVersion version) {
        return QueryStateMachine.beginWithTicker(existingTransactionId, query, preparedQuery, session, self, resourceGroup, transactionControl, transactionManager, accessControl, executor, Ticker.systemTicker(), metadata, warningCollector, queryStatsCollector, queryType, faultTolerantExecutionExchangeEncryptionEnabled, version);
    }

    static QueryStateMachine beginWithTicker(Optional<TransactionId> existingTransactionId, String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector, PlanOptimizersStatsCollector queryStatsCollector, Optional<QueryType> queryType, boolean faultTolerantExecutionExchangeEncryptionEnabled, NodeVersion version) {
        existingTransactionId.ifPresent(transactionId -> {
            if (transactionControl) {
                transactionManager.trySetActive((TransactionId)transactionId);
            } else {
                transactionManager.checkAndSetActive((TransactionId)transactionId);
            }
        });
        if (existingTransactionId.isPresent() || !transactionControl) {
            TransactionId transactionId2 = existingTransactionId.orElseGet(() -> transactionManager.beginTransaction(true));
            session = session.beginTransactionId(transactionId2, transactionManager, accessControl);
        }
        if (SystemSessionProperties.getRetryPolicy(session) == RetryPolicy.TASK && faultTolerantExecutionExchangeEncryptionEnabled) {
            session = session.withExchangeEncryption(Ciphers.serializeAesEncryptionKey(Ciphers.createRandomAesEncryptionKey()));
        }
        Span querySpan = session.getQuerySpan();
        querySpan.setAttribute(TrinoAttributes.QUERY_TYPE, (Object)queryType.map(Enum::name).orElse("UNKNOWN"));
        QueryStateMachine queryStateMachine = new QueryStateMachine(query, preparedQuery, session, self, resourceGroup, transactionManager, executor, ticker, metadata, warningCollector, queryStatsCollector, queryType, version);
        queryStateMachine.addStateChangeListener(newState -> {
            QUERY_STATE_LOG.debug("Query %s is %s", new Object[]{queryStateMachine.getQueryId(), newState});
            if (newState.isDone()) {
                queryStateMachine.getSession().getTransactionId().ifPresent(transactionManager::trySetInactive);
                queryStateMachine.getOutputManager().setQueryCompleted();
            }
        });
        queryStateMachine.addStateChangeListener(newState -> {
            querySpan.addEvent("query_state", Attributes.of(TrinoAttributes.EVENT_STATE, (Object)newState.toString()));
            if (newState.isDone()) {
                queryStateMachine.getFailureInfo().ifPresentOrElse(failure -> {
                    ErrorCode errorCode = Objects.requireNonNull(failure.getErrorCode());
                    querySpan.setStatus(StatusCode.ERROR, Strings.nullToEmpty((String)failure.getMessage())).recordException((Throwable)failure.toException()).setAttribute(TrinoAttributes.ERROR_CODE, errorCode.getCode()).setAttribute(TrinoAttributes.ERROR_NAME, (Object)errorCode.getName()).setAttribute(TrinoAttributes.ERROR_TYPE, (Object)errorCode.getType().toString());
                }, () -> querySpan.setStatus(StatusCode.OK));
                querySpan.end();
            }
        });
        metadata.beginQuery(session);
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public Executor getStateMachineExecutor() {
        return this.stateMachineExecutor;
    }

    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemory.get();
    }

    public long getPeakRevocableMemoryInBytes() {
        return this.peakRevocableMemory.get();
    }

    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemory.get();
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory.get();
    }

    public long getPeakTaskRevocableMemory() {
        return this.peakTaskRevocableMemory.get();
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory.get();
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public PlanOptimizersStatsCollector getPlanOptimizersStatsCollector() {
        return this.planOptimizersStatsCollector;
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaRevocableMemoryInBytes, long deltaTotalMemoryInBytes, long taskUserMemoryInBytes, long taskRevocableMemoryInBytes, long taskTotalMemoryInBytes) {
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.currentRevocableMemory.addAndGet(deltaRevocableMemoryInBytes);
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
        this.peakRevocableMemory.updateAndGet(currentPeakValue -> Math.max(this.currentRevocableMemory.get(), currentPeakValue));
        this.peakTotalMemory.updateAndGet(currentPeakValue -> Math.max(this.currentTotalMemory.get(), currentPeakValue));
        this.peakTaskUserMemory.accumulateAndGet(taskUserMemoryInBytes, Math::max);
        this.peakTaskRevocableMemory.accumulateAndGet(taskRevocableMemoryInBytes, Math::max);
        this.peakTaskTotalMemory.accumulateAndGet(taskTotalMemoryInBytes, Math::max);
    }

    public BasicQueryInfo getBasicQueryInfo(Optional<BasicStageStats> rootStage) {
        ExecutionFailureInfo failureCause;
        QueryState state = this.queryState.get();
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        BasicStageStats stageStats = rootStage.orElse(BasicStageStats.EMPTY_STAGE_STATS);
        BasicQueryStats queryStats = new BasicQueryStats(this.queryStateTimer.getCreateTime(), this.getEndTime().orElse(null), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getExecutionTime(), stageStats.getFailedTasks(), stageStats.getTotalDrivers(), stageStats.getQueuedDrivers(), stageStats.getRunningDrivers(), stageStats.getCompletedDrivers(), stageStats.getRawInputDataSize(), stageStats.getRawInputPositions(), stageStats.getPhysicalInputDataSize(), stageStats.getCumulativeUserMemory(), stageStats.getFailedCumulativeUserMemory(), stageStats.getUserMemoryReservation(), stageStats.getTotalMemoryReservation(), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), stageStats.getTotalCpuTime(), stageStats.getFailedCpuTime(), stageStats.getTotalScheduledTime(), stageStats.getFailedScheduledTime(), stageStats.isFullyBlocked(), stageStats.getBlockedReasons(), stageStats.getProgressPercentage(), stageStats.getRunningPercentage());
        return new BasicQueryInfo(this.queryId, this.session.toSessionRepresentation(), Optional.of(this.resourceGroup), state, stageStats.isScheduled(), this.self, this.query, Optional.ofNullable(this.updateType.get()), this.preparedQuery, queryStats, errorCode == null ? null : errorCode.getType(), errorCode, this.queryType, SystemSessionProperties.getRetryPolicy(this.session));
    }

    @VisibleForTesting
    QueryInfo getQueryInfo(Optional<StageInfo> rootStage) {
        QueryState state = this.queryState.get();
        ExecutionFailureInfo failureCause = null;
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        List<StageInfo> allStages = StageInfo.getAllStages(rootStage);
        QueryStats queryStats = this.getQueryStats(rootStage, allStages);
        boolean finalInfo = state.isDone() && allStages.stream().allMatch(StageInfo::isFinalStageInfo);
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.self, this.outputManager.getQueryOutputInfo().map(QueryExecution.QueryOutputInfo::getColumnNames).orElse((List)ImmutableList.of()), this.query, this.preparedQuery, queryStats, Optional.ofNullable(this.setCatalog.get()), Optional.ofNullable(this.setSchema.get()), Optional.ofNullable(this.setPath.get()), Optional.ofNullable(this.setAuthorizationUser.get()), this.resetAuthorizationUser.get(), this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureCause, errorCode, this.warningCollector.getWarnings(), this.inputs.get(), this.output.get(), this.referencedTables.get(), this.routines.get(), finalInfo, Optional.of(this.resourceGroup), this.queryType, SystemSessionProperties.getRetryPolicy(this.session), false, this.version);
    }

    private QueryStats getQueryStats(Optional<StageInfo> rootStage, List<StageInfo> allStages) {
        OptionalDouble runningPercentage;
        OptionalDouble progressPercentage;
        boolean scheduled;
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int failedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        double cumulativeUserMemory = 0.0;
        double failedCumulativeUserMemory = 0.0;
        long userMemoryReservation = 0L;
        long revocableMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long failedScheduledTime = 0L;
        long totalCpuTime = 0L;
        long failedCpuTime = 0L;
        long totalBlockedTime = 0L;
        long physicalInputDataSize = 0L;
        long failedPhysicalInputDataSize = 0L;
        long physicalInputPositions = 0L;
        long failedPhysicalInputPositions = 0L;
        long physicalInputReadTime = 0L;
        long failedPhysicalInputReadTime = 0L;
        long internalNetworkInputDataSize = 0L;
        long failedInternalNetworkInputDataSize = 0L;
        long internalNetworkInputPositions = 0L;
        long failedInternalNetworkInputPositions = 0L;
        long rawInputDataSize = 0L;
        long failedRawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long failedRawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long failedProcessedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long failedProcessedInputPositions = 0L;
        long inputBlockedTime = 0L;
        long failedInputBlockedTime = 0L;
        long outputDataSize = 0L;
        long failedOutputDataSize = 0L;
        long outputPositions = 0L;
        long failedOutputPositions = 0L;
        long outputBlockedTime = 0L;
        long failedOutputBlockedTime = 0L;
        long physicalWrittenDataSize = 0L;
        long failedPhysicalWrittenDataSize = 0L;
        ImmutableList.Builder stageGcStatistics = ImmutableList.builderWithExpectedSize((int)allStages.size());
        boolean fullyBlocked = rootStage.isPresent();
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        ImmutableList.Builder operatorStatsSummary = ImmutableList.builder();
        for (StageInfo stageInfo : allStages) {
            StageStats stageStats = stageInfo.getStageStats();
            totalTasks += stageStats.getTotalTasks();
            runningTasks += stageStats.getRunningTasks();
            completedTasks += stageStats.getCompletedTasks();
            failedTasks += stageStats.getFailedTasks();
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            blockedDrivers += stageStats.getBlockedDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory += stageStats.getCumulativeUserMemory();
            failedCumulativeUserMemory += stageStats.getFailedCumulativeUserMemory();
            userMemoryReservation += stageStats.getUserMemoryReservation().toBytes();
            revocableMemoryReservation += stageStats.getRevocableMemoryReservation().toBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            failedScheduledTime += stageStats.getFailedScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            failedCpuTime += stageStats.getFailedCpuTime().roundTo(TimeUnit.MILLISECONDS);
            totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.MILLISECONDS);
            if (!stageInfo.getState().isDone()) {
                fullyBlocked &= stageStats.isFullyBlocked();
                blockedReasons.addAll(stageStats.getBlockedReasons());
            }
            physicalInputDataSize += stageStats.getPhysicalInputDataSize().toBytes();
            failedPhysicalInputDataSize += stageStats.getFailedPhysicalInputDataSize().toBytes();
            physicalInputPositions += stageStats.getPhysicalInputPositions();
            failedPhysicalInputPositions += stageStats.getFailedPhysicalInputPositions();
            physicalInputReadTime += stageStats.getPhysicalInputReadTime().roundTo(TimeUnit.MILLISECONDS);
            failedPhysicalInputReadTime += stageStats.getFailedPhysicalInputReadTime().roundTo(TimeUnit.MILLISECONDS);
            internalNetworkInputDataSize += stageStats.getInternalNetworkInputDataSize().toBytes();
            failedInternalNetworkInputDataSize += stageStats.getFailedInternalNetworkInputDataSize().toBytes();
            internalNetworkInputPositions += stageStats.getInternalNetworkInputPositions();
            failedInternalNetworkInputPositions += stageStats.getFailedInternalNetworkInputPositions();
            PlanFragment plan = stageInfo.getPlan();
            if (plan != null) {
                if (plan.getPartitionedSourceNodes().stream().anyMatch(TableScanNode.class::isInstance)) {
                    rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                    failedRawInputDataSize += stageStats.getFailedRawInputDataSize().toBytes();
                    rawInputPositions += stageStats.getRawInputPositions();
                    failedRawInputPositions += stageStats.getFailedRawInputPositions();
                    processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                    failedProcessedInputDataSize += stageStats.getFailedProcessedInputDataSize().toBytes();
                    processedInputPositions += stageStats.getProcessedInputPositions();
                    failedProcessedInputPositions += stageStats.getFailedProcessedInputPositions();
                }
            }
            inputBlockedTime += stageStats.getInputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            failedInputBlockedTime += stageStats.getFailedInputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            outputBlockedTime += stageStats.getOutputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            failedOutputBlockedTime += stageStats.getFailedOutputBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            physicalWrittenDataSize += stageStats.getPhysicalWrittenDataSize().toBytes();
            failedPhysicalWrittenDataSize += stageStats.getFailedPhysicalWrittenDataSize().toBytes();
            stageGcStatistics.add((Object)stageStats.getGcInfo());
            operatorStatsSummary.addAll(stageInfo.getStageStats().getOperatorSummaries());
        }
        if (rootStage.isPresent()) {
            StageStats outputStageStats = rootStage.get().getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            failedOutputDataSize += outputStageStats.getFailedOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
            failedOutputPositions += outputStageStats.getFailedOutputPositions();
        }
        if (SystemSessionProperties.getRetryPolicy(this.session).equals((Object)RetryPolicy.TASK)) {
            boolean bl = scheduled = rootStage.isPresent() && allStages.stream().map(StageInfo::getState).anyMatch(StageState::isScheduled);
            if (!scheduled || totalDrivers == 0) {
                progressPercentage = OptionalDouble.empty();
                runningPercentage = OptionalDouble.empty();
            } else {
                double completedPercentageSum = 0.0;
                double runningPercentageSum = 0.0;
                int totalStages = 0;
                ArrayDeque<StageInfo> queue = new ArrayDeque<StageInfo>();
                queue.add(rootStage.get());
                while (!queue.isEmpty()) {
                    StageInfo stage = (StageInfo)queue.poll();
                    StageStats stageStats = stage.getStageStats();
                    ++totalStages;
                    if (stage.getState().isScheduled()) {
                        completedPercentageSum += 100.0 * (double)stageStats.getCompletedDrivers() / (double)stageStats.getTotalDrivers();
                        runningPercentageSum += 100.0 * (double)stageStats.getRunningDrivers() / (double)stageStats.getTotalDrivers();
                    }
                    queue.addAll(stage.getSubStages());
                }
                progressPercentage = OptionalDouble.of(Math.min(100.0, completedPercentageSum / (double)totalStages));
                runningPercentage = OptionalDouble.of(Math.min(100.0, runningPercentageSum / (double)totalStages));
            }
        } else {
            boolean bl = scheduled = rootStage.isPresent() && allStages.stream().map(StageInfo::getState).allMatch(StageState::isScheduled);
            if (!scheduled || totalDrivers == 0) {
                progressPercentage = OptionalDouble.empty();
                runningPercentage = OptionalDouble.empty();
            } else {
                progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
                runningPercentage = OptionalDouble.of(Math.min(100.0, (double)runningDrivers * 100.0 / (double)totalDrivers));
            }
        }
        return new QueryStats(this.queryStateTimer.getCreateTime(), this.getExecutionStartTime().orElse(null), this.getLastHeartbeat(), this.getEndTime().orElse(null), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getResourceWaitingTime(), this.queryStateTimer.getDispatchingTime(), this.queryStateTimer.getExecutionTime(), this.queryStateTimer.getAnalysisTime(), this.queryStateTimer.getPlanningTime(), this.queryStateTimer.getPlanningCpuTime(), this.queryStateTimer.getFinishingTime(), totalTasks, runningTasks, completedTasks, failedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, failedCumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)revocableMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakRevocableMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTaskUserMemory()), DataSize.succinctBytes((long)this.getPeakTaskRevocableMemory()), DataSize.succinctBytes((long)this.getPeakTaskTotalMemory()), scheduled, progressPercentage, runningPercentage, new Duration((double)totalScheduledTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedScheduledTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, DataSize.succinctBytes((long)physicalInputDataSize), DataSize.succinctBytes((long)failedPhysicalInputDataSize), physicalInputPositions, failedPhysicalInputPositions, new Duration((double)physicalInputReadTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedPhysicalInputReadTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)internalNetworkInputDataSize), DataSize.succinctBytes((long)failedInternalNetworkInputDataSize), internalNetworkInputPositions, failedInternalNetworkInputPositions, DataSize.succinctBytes((long)rawInputDataSize), DataSize.succinctBytes((long)failedRawInputDataSize), rawInputPositions, failedRawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), DataSize.succinctBytes((long)failedProcessedInputDataSize), processedInputPositions, failedProcessedInputPositions, new Duration((double)inputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedInputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)outputDataSize), DataSize.succinctBytes((long)failedOutputDataSize), outputPositions, failedOutputPositions, new Duration((double)outputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedOutputBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)physicalWrittenDataSize), DataSize.succinctBytes((long)failedPhysicalWrittenDataSize), (List<StageGcStatistics>)stageGcStatistics.build(), this.getDynamicFiltersStats(), (List<OperatorStats>)operatorStatsSummary.build(), this.planOptimizersStatsCollector.getTopRuleStats());
    }

    public void setOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.outputManager.setOutputInfoListener(listener);
    }

    public void addOutputTaskFailureListener(TaskFailureListener listener) {
        this.outputManager.addOutputTaskFailureListener(listener);
    }

    public void outputTaskFailed(TaskId taskId, Throwable failure) {
        this.outputManager.outputTaskFailed(taskId, failure);
    }

    public void setColumns(List<String> columnNames, List<Type> columnTypes) {
        this.outputManager.setColumns(columnNames, columnTypes);
    }

    public void updateInputsForQueryResults(List<ExchangeInput> inputs, boolean noMoreInputs) {
        this.outputManager.updateInputsForQueryResults(inputs, noMoreInputs);
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public void setOutput(Optional<Output> output) {
        Objects.requireNonNull(output, "output is null");
        this.output.set(output);
    }

    public void setReferencedTables(List<io.trino.spi.eventlistener.TableInfo> tables) {
        Objects.requireNonNull(tables, "tables is null");
        this.referencedTables.set((List<io.trino.spi.eventlistener.TableInfo>)ImmutableList.copyOf(tables));
    }

    public void setRoutines(List<RoutineInfo> routines) {
        Objects.requireNonNull(routines, "routines is null");
        this.routines.set((List<RoutineInfo>)ImmutableList.copyOf(routines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicFilterService.DynamicFiltersStats getDynamicFiltersStats() {
        Object object = this.dynamicFiltersStatsSupplierLock;
        synchronized (object) {
            return this.dynamicFiltersStatsSupplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDynamicFiltersStatsSupplier(Supplier<DynamicFilterService.DynamicFiltersStats> dynamicFiltersStatsSupplier) {
        Object object = this.dynamicFiltersStatsSupplierLock;
        synchronized (object) {
            this.dynamicFiltersStatsSupplier = Objects.requireNonNull(dynamicFiltersStatsSupplier, "dynamicFiltersStatsSupplier is null");
        }
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void setSetCatalog(String catalog) {
        this.setCatalog.set(Objects.requireNonNull(catalog, "catalog is null"));
    }

    public void setSetSchema(String schema) {
        this.setSchema.set(Objects.requireNonNull(schema, "schema is null"));
    }

    public void setSetPath(String path) {
        Objects.requireNonNull(path, "path is null");
        this.setPath.set(path);
    }

    public String getSetPath() {
        return this.setPath.get();
    }

    public void setSetAuthorizationUser(String authorizationUser) {
        Preconditions.checkState((authorizationUser != null && !authorizationUser.isEmpty() ? 1 : 0) != 0, (Object)"Authorization user cannot be null or empty");
        this.setAuthorizationUser.set(authorizationUser);
    }

    public void resetAuthorizationUser() {
        Preconditions.checkArgument((this.setAuthorizationUser.get() == null ? 1 : 0) != 0, (Object)"Cannot set and reset the authorization user in the same request");
        this.resetAuthorizationUser.set(true);
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public void addSetRole(String catalog, SelectedRole role) {
        this.setRoles.put(Objects.requireNonNull(catalog, "catalog is null"), Objects.requireNonNull(role, "role is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public void addPreparedStatement(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.addedPreparedStatements.put(key, value);
    }

    public void removePreparedStatement(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!this.session.getPreparedStatements().containsKey(key)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + key);
        }
        this.deallocatedPreparedStatements.add(key);
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToWaitingForResources() {
        this.queryStateTimer.beginWaitingForResources();
        return this.queryState.setIf(QueryState.WAITING_FOR_RESOURCES, currentState -> currentState.ordinal() < QueryState.WAITING_FOR_RESOURCES.ordinal());
    }

    public boolean transitionToDispatching() {
        this.queryStateTimer.beginDispatching();
        return this.queryState.setIf(QueryState.DISPATCHING, currentState -> currentState.ordinal() < QueryState.DISPATCHING.ordinal());
    }

    public boolean transitionToPlanning() {
        this.queryStateTimer.beginPlanning();
        return this.queryState.setIf(QueryState.PLANNING, currentState -> currentState.ordinal() < QueryState.PLANNING.ordinal());
    }

    public boolean transitionToStarting() {
        this.queryStateTimer.beginStarting();
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState.ordinal() < QueryState.STARTING.ordinal());
    }

    public boolean transitionToRunning() {
        this.queryStateTimer.beginRunning();
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState.ordinal() < QueryState.RUNNING.ordinal());
    }

    public boolean transitionToFinishing() {
        this.queryStateTimer.beginFinishing();
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        try {
            this.cleanupQuery();
        }
        catch (Exception e) {
            this.transitionToFailed(e);
            return true;
        }
        Optional transaction = this.session.getTransactionId().flatMap(this.transactionManager::getTransactionInfoIfExist);
        if (transaction.isPresent() && ((TransactionInfo)transaction.get()).isAutoCommitContext()) {
            ListenableFuture<Void> commitFuture = this.transactionManager.asyncCommit(((TransactionInfo)transaction.get()).getTransactionId());
            Futures.addCallback(commitFuture, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                    QueryStateMachine.this.committed.set(true);
                    QueryStateMachine.this.transitionToFinishedIfReady();
                }

                public void onFailure(Throwable throwable) {
                    QueryStateMachine.this.transitionToFailed(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            this.committed.set(true);
            this.transitionToFinishedIfReady();
        }
        return true;
    }

    public void resultsConsumed() {
        this.consumed.set(true);
        this.transitionToFinishedIfReady();
    }

    private void transitionToFinishedIfReady() {
        if (this.queryState.get().isDone()) {
            return;
        }
        if (!this.committed.get() || !this.consumed.get()) {
            return;
        }
        this.queryStateTimer.endQuery();
        this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        QueryState oldState = this.queryState.trySet(QueryState.FAILED);
        if (oldState.isDone()) {
            QUERY_STATE_LOG.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
            return false;
        }
        try {
            QUERY_STATE_LOG.debug(throwable, "Query %s failed", new Object[]{this.queryId});
            this.session.getTransactionId().flatMap(this.transactionManager::getTransactionInfoIfExist).ifPresent(transaction -> {
                try {
                    if (transaction.isAutoCommitContext()) {
                        this.transactionManager.asyncAbort(transaction.getTransactionId());
                    } else {
                        this.transactionManager.fail(transaction.getTransactionId());
                    }
                }
                catch (RuntimeException e) {
                    QUERY_STATE_LOG.error((Throwable)e, "Error aborting transaction for failed query. Transaction will be failed directly");
                }
            });
        }
        finally {
            if (oldState.ordinal() <= QueryState.PLANNING.ordinal()) {
                this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(this.getQueryInfo(Optional.empty())));
            }
        }
        return true;
    }

    public boolean transitionToCanceled() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.failureCause.compareAndSet(null, Failures.toFailure(new TrinoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled")));
        boolean canceled = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (canceled) {
            this.session.getTransactionId().flatMap(this.transactionManager::getTransactionInfoIfExist).ifPresent(transaction -> {
                if (transaction.isAutoCommitContext()) {
                    this.transactionManager.asyncAbort(transaction.getTransactionId());
                } else {
                    this.transactionManager.fail(transaction.getTransactionId());
                }
            });
        }
        return canceled;
    }

    private void cleanupQuery() {
        if (this.queryCleanedUp.compareAndSet(false, true)) {
            this.metadata.cleanupQuery(this.session);
        }
    }

    private void cleanupQueryQuietly() {
        try {
            this.cleanupQuery();
        }
        catch (Throwable t) {
            QUERY_STATE_LOG.error("Error cleaning up query: %s", new Object[]{t});
        }
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public void addQueryInfoStateChangeListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalQueryInfo -> {
            if (finalQueryInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((QueryInfo)finalQueryInfo.get());
            }
        };
        this.finalQueryInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public void recordHeartbeat() {
        this.queryStateTimer.recordHeartbeat();
    }

    public void beginAnalysis() {
        this.queryStateTimer.beginAnalysis();
    }

    public void endAnalysis() {
        this.queryStateTimer.endAnalysis();
    }

    public DateTime getCreateTime() {
        return this.queryStateTimer.getCreateTime();
    }

    public Optional<DateTime> getExecutionStartTime() {
        return this.queryStateTimer.getExecutionStartTime();
    }

    public Optional<Duration> getPlanningTime() {
        return this.queryStateTimer.getExecutionStartTime().map(ignored -> this.queryStateTimer.getPlanningTime());
    }

    public DateTime getLastHeartbeat() {
        return this.queryStateTimer.getLastHeartbeat();
    }

    public Optional<DateTime> getEndTime() {
        return this.queryStateTimer.getEndTime();
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        if (this.queryState.get() != QueryState.FAILED) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.failureCause.get());
    }

    public Optional<QueryInfo> getFinalQueryInfo() {
        return this.finalQueryInfo.get();
    }

    public QueryInfo updateQueryInfo(Optional<StageInfo> stageInfo) {
        QueryInfo queryInfo = this.getQueryInfo(stageInfo);
        if (queryInfo.isFinalQueryInfo()) {
            this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(queryInfo));
        }
        return queryInfo;
    }

    public void pruneQueryInfo() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (finalInfo.isEmpty() || finalInfo.get().getOutputStage().isEmpty() || finalInfo.get().isPruned()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        Optional<StageInfo> prunedOutputStage = queryInfo.getOutputStage().map(outputStage -> new StageInfo(outputStage.getStageId(), outputStage.getState(), null, outputStage.isCoordinatorOnly(), outputStage.getTypes(), outputStage.getStageStats(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), (Map<PlanNodeId, TableInfo>)ImmutableMap.of(), outputStage.getFailureCause()));
        QueryInfo prunedQueryInfo = new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryInfo.getPreparedQuery(), QueryStateMachine.pruneQueryStats(queryInfo.getQueryStats()), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetPath(), queryInfo.getSetAuthorizationUser(), queryInfo.isResetAuthorizationUser(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), prunedOutputStage, queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getWarnings(), queryInfo.getInputs(), queryInfo.getOutput(), queryInfo.getReferencedTables(), queryInfo.getRoutines(), queryInfo.isFinalQueryInfo(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getRetryPolicy(), true, this.version);
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    private static QueryStats pruneQueryStats(QueryStats queryStats) {
        return new QueryStats(queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getLastHeartbeat(), queryStats.getEndTime(), queryStats.getElapsedTime(), queryStats.getQueuedTime(), queryStats.getResourceWaitingTime(), queryStats.getDispatchingTime(), queryStats.getExecutionTime(), queryStats.getAnalysisTime(), queryStats.getPlanningTime(), queryStats.getPlanningCpuTime(), queryStats.getFinishingTime(), queryStats.getTotalTasks(), queryStats.getFailedTasks(), queryStats.getRunningTasks(), queryStats.getCompletedTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getBlockedDrivers(), queryStats.getCompletedDrivers(), queryStats.getCumulativeUserMemory(), queryStats.getFailedCumulativeUserMemory(), queryStats.getUserMemoryReservation(), queryStats.getRevocableMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakRevocableMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskUserMemory(), queryStats.getPeakTaskRevocableMemory(), queryStats.getPeakTaskTotalMemory(), queryStats.isScheduled(), queryStats.getProgressPercentage(), queryStats.getRunningPercentage(), queryStats.getTotalScheduledTime(), queryStats.getFailedScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getFailedCpuTime(), queryStats.getTotalBlockedTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getPhysicalInputDataSize(), queryStats.getFailedPhysicalInputDataSize(), queryStats.getPhysicalInputPositions(), queryStats.getFailedPhysicalInputPositions(), queryStats.getPhysicalInputReadTime(), queryStats.getFailedPhysicalInputReadTime(), queryStats.getInternalNetworkInputDataSize(), queryStats.getFailedInternalNetworkInputDataSize(), queryStats.getInternalNetworkInputPositions(), queryStats.getFailedInternalNetworkInputPositions(), queryStats.getRawInputDataSize(), queryStats.getFailedRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getFailedRawInputPositions(), queryStats.getProcessedInputDataSize(), queryStats.getFailedProcessedInputDataSize(), queryStats.getProcessedInputPositions(), queryStats.getFailedProcessedInputPositions(), queryStats.getInputBlockedTime(), queryStats.getFailedInputBlockedTime(), queryStats.getOutputDataSize(), queryStats.getFailedOutputDataSize(), queryStats.getOutputPositions(), queryStats.getFailedOutputPositions(), queryStats.getOutputBlockedTime(), queryStats.getFailedOutputBlockedTime(), queryStats.getPhysicalWrittenDataSize(), queryStats.getFailedPhysicalWrittenDataSize(), queryStats.getStageGcStatistics(), queryStats.getDynamicFiltersStats(), (List<OperatorStats>)ImmutableList.of(), (List<QueryPlanOptimizerStatistics>)ImmutableList.of());
    }

    private QueryOutputManager getOutputManager() {
        return this.outputManager;
    }

    public static class QueryOutputManager {
        private final Executor executor;
        @GuardedBy(value="this")
        private Optional<Consumer<QueryExecution.QueryOutputInfo>> listener = Optional.empty();
        @GuardedBy(value="this")
        private List<String> columnNames;
        @GuardedBy(value="this")
        private List<Type> columnTypes;
        @GuardedBy(value="this")
        private boolean noMoreInputs;
        @GuardedBy(value="this")
        private boolean queryCompleted;
        private final Queue<ExchangeInput> inputsQueue = new ConcurrentLinkedQueue<ExchangeInput>();
        @GuardedBy(value="this")
        private final Map<TaskId, Throwable> outputTaskFailures = new HashMap<TaskId, Throwable>();
        @GuardedBy(value="this")
        private final List<TaskFailureListener> outputTaskFailureListeners = new ArrayList<TaskFailureListener>();

        public QueryOutputManager(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(listener, "listener is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                Preconditions.checkState((boolean)this.listener.isEmpty(), (Object)"listener is already set");
                this.listener = Optional.of(listener);
                queryOutputInfo = this.getQueryOutputInfo();
            }
            this.fireStateChangedIfReady(queryOutputInfo, Optional.of(listener));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColumns(List<String> columnNames, List<Type> columnTypes) {
            Optional<Consumer<QueryExecution.QueryOutputInfo>> listener;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(columnNames, "columnNames is null");
            Objects.requireNonNull(columnTypes, "columnTypes is null");
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must be the same size");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                Preconditions.checkState((this.columnNames == null && this.columnTypes == null ? 1 : 0) != 0, (Object)"output fields already set");
                this.columnNames = ImmutableList.copyOf(columnNames);
                this.columnTypes = ImmutableList.copyOf(columnTypes);
                queryOutputInfo = this.getQueryOutputInfo();
                listener = this.listener;
            }
            this.fireStateChangedIfReady(queryOutputInfo, listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateInputsForQueryResults(List<ExchangeInput> newInputs, boolean noMoreInputs) {
            Optional<Consumer<QueryExecution.QueryOutputInfo>> listener;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(newInputs, "newInputs is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                if (!this.queryCompleted) {
                    Preconditions.checkState((newInputs.isEmpty() || !this.noMoreInputs ? 1 : 0) != 0, (Object)"new inputs added after no more inputs set");
                    this.inputsQueue.addAll(newInputs);
                    this.noMoreInputs = noMoreInputs;
                }
                queryOutputInfo = this.getQueryOutputInfo();
                listener = this.listener;
            }
            this.fireStateChangedIfReady(queryOutputInfo, listener);
        }

        public synchronized void setQueryCompleted() {
            if (this.queryCompleted) {
                return;
            }
            this.queryCompleted = true;
            this.inputsQueue.clear();
            this.noMoreInputs = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutputTaskFailureListener(TaskFailureListener listener) {
            ImmutableMap failures;
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                this.outputTaskFailureListeners.add(listener);
                failures = ImmutableMap.copyOf(this.outputTaskFailures);
            }
            if (!failures.isEmpty()) {
                this.executor.execute(() -> QueryOutputManager.lambda$addOutputTaskFailureListener$0((Map)failures, listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void outputTaskFailed(TaskId taskId, Throwable failure) {
            ImmutableList listeners;
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                this.outputTaskFailures.putIfAbsent(taskId, failure);
                listeners = ImmutableList.copyOf(this.outputTaskFailureListeners);
            }
            if (!listeners.isEmpty()) {
                this.executor.execute(() -> QueryOutputManager.lambda$outputTaskFailed$1((List)listeners, taskId, failure));
            }
        }

        private synchronized Optional<QueryExecution.QueryOutputInfo> getQueryOutputInfo() {
            if (this.columnNames == null || this.columnTypes == null) {
                return Optional.empty();
            }
            return Optional.of(new QueryExecution.QueryOutputInfo(this.columnNames, this.columnTypes, this.inputsQueue, this.noMoreInputs));
        }

        private void fireStateChangedIfReady(Optional<QueryExecution.QueryOutputInfo> info, Optional<Consumer<QueryExecution.QueryOutputInfo>> listener) {
            if (info.isEmpty() || listener.isEmpty()) {
                return;
            }
            this.executor.execute(() -> ((Consumer)listener.get()).accept((QueryExecution.QueryOutputInfo)info.get()));
        }

        private static /* synthetic */ void lambda$outputTaskFailed$1(List listeners, TaskId taskId, Throwable failure) {
            for (TaskFailureListener listener : listeners) {
                listener.onTaskFailed(taskId, failure);
            }
        }

        private static /* synthetic */ void lambda$addOutputTaskFailureListener$0(Map failures, TaskFailureListener listener) {
            failures.forEach(listener::onTaskFailed);
        }
    }
}

