/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.ArbitraryOutputBuffer;
import io.trino.execution.buffer.BroadcastOutputBuffer;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBufferStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PartitionedOutputBuffer;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.buffer.SpoolingExchangeOutputBuffer;
import io.trino.execution.buffer.SpoolingOutputBuffers;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSink;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class LazyOutputBuffer
implements OutputBuffer {
    private final OutputBufferStateMachine stateMachine;
    private final String taskInstanceId;
    private final DataSize maxBufferSize;
    private final DataSize maxBroadcastBufferSize;
    private final Supplier<LocalMemoryContext> memoryContextSupplier;
    private final Executor executor;
    private final Runnable notifyStatusChanged;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    @GuardedBy(value="this")
    private volatile OutputBuffer delegate;
    @GuardedBy(value="this")
    private final Set<PipelinedOutputBuffers.OutputBufferId> destroyedBuffers = new HashSet<PipelinedOutputBuffers.OutputBufferId>();
    @GuardedBy(value="this")
    private final List<PendingRead> pendingReads = new ArrayList<PendingRead>();

    public LazyOutputBuffer(TaskId taskId, String taskInstanceId, Executor executor, DataSize maxBufferSize, DataSize maxBroadcastBufferSize, Supplier<LocalMemoryContext> memoryContextSupplier, Runnable notifyStatusChanged, ExchangeManagerRegistry exchangeManagerRegistry) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.stateMachine = new OutputBufferStateMachine(taskId, executor);
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.maxBroadcastBufferSize = Objects.requireNonNull(maxBroadcastBufferSize, "maxBroadcastBufferSize is null");
        Preconditions.checkArgument((maxBufferSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferSize must be at least 1");
        this.memoryContextSupplier = Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null");
        this.notifyStatusChanged = Objects.requireNonNull(notifyStatusChanged, "notifyStatusChanged is null");
        this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public double getUtilization() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer == null) {
            return 1.0;
        }
        return outputBuffer.getUtilization();
    }

    @Override
    public OutputBufferStatus getStatus() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer == null) {
            return OutputBufferStatus.initial();
        }
        return outputBuffer.getStatus();
    }

    @Override
    public OutputBufferInfo getInfo() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer == null) {
            BufferState state = this.stateMachine.getState();
            return new OutputBufferInfo("UNINITIALIZED", state, state.canAddBuffers(), state.canAddPages(), 0L, 0L, 0L, 0L, Optional.empty(), Optional.empty(), Optional.empty());
        }
        return outputBuffer.getInfo();
    }

    @Override
    public BufferState getState() {
        return this.stateMachine.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        ImmutableSet destroyedBuffers = ImmutableSet.of();
        ImmutableList pendingReads = ImmutableList.of();
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                outputBuffer = this.delegate;
                if (outputBuffer == null) {
                    if (this.stateMachine.getState().isTerminal()) {
                        return;
                    }
                    if (newOutputBuffers instanceof PipelinedOutputBuffers) {
                        PipelinedOutputBuffers outputBuffers = (PipelinedOutputBuffers)newOutputBuffers;
                        outputBuffer = switch (outputBuffers.getType()) {
                            default -> throw new IncompatibleClassChangeError();
                            case PipelinedOutputBuffers.BufferType.PARTITIONED -> new PartitionedOutputBuffer(this.taskInstanceId, this.stateMachine, outputBuffers, this.maxBufferSize, this.memoryContextSupplier, this.executor);
                            case PipelinedOutputBuffers.BufferType.BROADCAST -> new BroadcastOutputBuffer(this.taskInstanceId, this.stateMachine, this.maxBroadcastBufferSize, this.memoryContextSupplier, this.executor, this.notifyStatusChanged);
                            case PipelinedOutputBuffers.BufferType.ARBITRARY -> new ArbitraryOutputBuffer(this.taskInstanceId, this.stateMachine, this.maxBufferSize, this.memoryContextSupplier, this.executor);
                        };
                    } else if (newOutputBuffers instanceof SpoolingOutputBuffers) {
                        SpoolingOutputBuffers outputBuffers = (SpoolingOutputBuffers)newOutputBuffers;
                        ExchangeSinkInstanceHandle exchangeSinkInstanceHandle = outputBuffers.getExchangeSinkInstanceHandle();
                        ExchangeManager exchangeManager = this.exchangeManagerRegistry.getExchangeManager();
                        ExchangeSink exchangeSink = exchangeManager.createSink(exchangeSinkInstanceHandle);
                        outputBuffer = new SpoolingExchangeOutputBuffer(this.stateMachine, outputBuffers, exchangeSink, this.memoryContextSupplier);
                    } else {
                        throw new IllegalArgumentException("Unexpected output buffers type: " + newOutputBuffers.getClass());
                    }
                    destroyedBuffers = ImmutableSet.copyOf(this.destroyedBuffers);
                    this.destroyedBuffers.clear();
                    pendingReads = ImmutableList.copyOf(this.pendingReads);
                    this.pendingReads.clear();
                    this.delegate = outputBuffer;
                }
            }
        }
        outputBuffer.setOutputBuffers(newOutputBuffers);
        destroyedBuffers.forEach(outputBuffer::destroy);
        for (PendingRead pendingRead : pendingReads) {
            pendingRead.process(outputBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<BufferResult> get(PipelinedOutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    if (this.stateMachine.getState().isTerminal()) {
                        boolean complete = this.stateMachine.getState() == BufferState.FINISHED;
                        return Futures.immediateFuture((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, complete));
                    }
                    PendingRead pendingRead = new PendingRead(bufferId, token, maxSize);
                    this.pendingReads.add(pendingRead);
                    return pendingRead.getFutureResult();
                }
                outputBuffer = this.delegate;
            }
        }
        return outputBuffer.get(bufferId, token, maxSize);
    }

    @Override
    public void acknowledge(PipelinedOutputBuffers.OutputBufferId bufferId, long token) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.acknowledge(bufferId, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(PipelinedOutputBuffers.OutputBufferId bufferId) {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    this.destroyedBuffers.add(bufferId);
                    return;
                }
                outputBuffer = this.delegate;
            }
        }
        outputBuffer.destroy(bufferId);
    }

    @Override
    public ListenableFuture<Void> isFull() {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        return outputBuffer.isFull();
    }

    @Override
    public void enqueue(List<Slice> pages) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.enqueue(pages);
    }

    @Override
    public void enqueue(int partition, List<Slice> pages) {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.enqueue(partition, pages);
    }

    @Override
    public void setNoMorePages() {
        OutputBuffer outputBuffer = this.getDelegateOutputBufferOrFail();
        outputBuffer.setNoMorePages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ImmutableList pendingReads = ImmutableList.of();
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    if (!this.stateMachine.finish()) {
                        return;
                    }
                    pendingReads = ImmutableList.copyOf(this.pendingReads);
                    this.pendingReads.clear();
                }
                outputBuffer = this.delegate;
            }
        }
        if (outputBuffer == null) {
            for (PendingRead pendingRead : pendingReads) {
                pendingRead.getFutureResult().set((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, true));
            }
            return;
        }
        outputBuffer.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        ImmutableList pendingReads = ImmutableList.of();
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                if (this.delegate == null) {
                    if (!this.stateMachine.abort()) {
                        return;
                    }
                    pendingReads = ImmutableList.copyOf(this.pendingReads);
                    this.pendingReads.clear();
                }
                outputBuffer = this.delegate;
            }
        }
        if (outputBuffer == null) {
            for (PendingRead pendingRead : pendingReads) {
                pendingRead.getFutureResult().set((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, false));
            }
            return;
        }
        outputBuffer.abort();
    }

    @Override
    public long getPeakMemoryUsage() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        if (outputBuffer != null) {
            return outputBuffer.getPeakMemoryUsage();
        }
        return 0L;
    }

    @Override
    public Optional<Throwable> getFailureCause() {
        return this.stateMachine.getFailureCause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OutputBuffer getDelegateOutputBuffer() {
        OutputBuffer outputBuffer = this.delegate;
        if (outputBuffer == null) {
            LazyOutputBuffer lazyOutputBuffer = this;
            synchronized (lazyOutputBuffer) {
                outputBuffer = this.delegate;
            }
        }
        return outputBuffer;
    }

    private OutputBuffer getDelegateOutputBufferOrFail() {
        OutputBuffer outputBuffer = this.getDelegateOutputBuffer();
        Preconditions.checkState((outputBuffer != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
        return outputBuffer;
    }

    private static class PendingRead {
        private final PipelinedOutputBuffers.OutputBufferId bufferId;
        private final long startingSequenceId;
        private final DataSize maxSize;
        private final SettableFuture<BufferResult> futureResult = SettableFuture.create();

        public PendingRead(PipelinedOutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
            this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
            this.startingSequenceId = startingSequenceId;
            this.maxSize = Objects.requireNonNull(maxSize, "maxSize is null");
        }

        public SettableFuture<BufferResult> getFutureResult() {
            return this.futureResult;
        }

        public void process(OutputBuffer delegate) {
            if (this.futureResult.isDone()) {
                return;
            }
            try {
                ListenableFuture<BufferResult> result = delegate.get(this.bufferId, this.startingSequenceId, this.maxSize);
                this.futureResult.setFuture(result);
            }
            catch (Exception e) {
                this.futureResult.setException((Throwable)e);
            }
        }
    }
}

