/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class FaultTolerantPartitioningScheme {
    private final int partitionCount;
    private final Optional<int[]> bucketToPartitionMap;
    private final Optional<ToIntFunction<Split>> splitToBucketFunction;
    private final Optional<List<InternalNode>> partitionToNodeMap;

    @VisibleForTesting
    FaultTolerantPartitioningScheme(int partitionCount, Optional<int[]> bucketToPartitionMap, Optional<ToIntFunction<Split>> splitToBucketFunction, Optional<List<InternalNode>> partitionToNodeMap) {
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be greater than zero");
        this.partitionCount = partitionCount;
        this.bucketToPartitionMap = Objects.requireNonNull(bucketToPartitionMap, "bucketToPartitionMap is null");
        this.splitToBucketFunction = Objects.requireNonNull(splitToBucketFunction, "splitToBucketFunction is null");
        Objects.requireNonNull(partitionToNodeMap, "partitionToNodeMap is null");
        partitionToNodeMap.ifPresent(map -> Preconditions.checkArgument((map.size() == partitionCount ? 1 : 0) != 0, (String)"partitionToNodeMap size (%s) must be equal to partitionCount (%s)", (int)map.size(), (int)partitionCount));
        this.partitionToNodeMap = partitionToNodeMap.map(ImmutableList::copyOf);
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Optional<int[]> getBucketToPartitionMap() {
        return this.bucketToPartitionMap;
    }

    public int getPartition(Split split) {
        if (this.splitToBucketFunction.isPresent()) {
            Preconditions.checkState((boolean)this.bucketToPartitionMap.isPresent(), (Object)"bucketToPartitionMap is expected to be present");
            int bucket = this.splitToBucketFunction.get().applyAsInt(split);
            Preconditions.checkState((this.bucketToPartitionMap.get().length > bucket ? 1 : 0) != 0, (String)"invalid bucketToPartitionMap size (%s), bucket to partition mapping not found for bucket %s", (int)this.bucketToPartitionMap.get().length, (int)bucket);
            return this.bucketToPartitionMap.get()[bucket];
        }
        Preconditions.checkState((this.partitionCount == 1 ? 1 : 0) != 0, (String)"partitionCount is expected to be set to 1: %s", (int)this.partitionCount);
        return 0;
    }

    public boolean isExplicitPartitionToNodeMappingPresent() {
        return this.partitionToNodeMap.isPresent();
    }

    public Optional<InternalNode> getNodeRequirement(int partition) {
        Preconditions.checkArgument((partition < this.partitionCount ? 1 : 0) != 0, (String)"partition is expected to be less than %s", (int)this.partitionCount);
        return this.partitionToNodeMap.map(map -> (InternalNode)map.get(partition));
    }

    public Optional<List<InternalNode>> getPartitionToNodeMap() {
        return this.partitionToNodeMap;
    }

    public FaultTolerantPartitioningScheme withPartitionCount(int partitionCount) {
        return new FaultTolerantPartitioningScheme(partitionCount, this.bucketToPartitionMap, this.splitToBucketFunction, this.partitionToNodeMap);
    }
}

