/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

public enum TaskExecutionClass {
    STANDARD,
    SPECULATIVE,
    EAGER_SPECULATIVE;


    boolean canTransitionTo(TaskExecutionClass targetExecutionClass) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STANDARD -> {
                if (targetExecutionClass == STANDARD) {
                    yield true;
                }
                yield false;
            }
            case SPECULATIVE -> {
                if (targetExecutionClass == SPECULATIVE || targetExecutionClass == STANDARD) {
                    yield true;
                }
                yield false;
            }
            case EAGER_SPECULATIVE -> targetExecutionClass == EAGER_SPECULATIVE || targetExecutionClass == STANDARD;
        };
    }

    boolean isSpeculative() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STANDARD -> false;
            case SPECULATIVE, EAGER_SPECULATIVE -> true;
        };
    }
}

