/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewInfo;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public final class MetadataListing {
    private MetadataListing() {
    }

    public static SortedSet<String> listCatalogNames(Session session, Metadata metadata, AccessControl accessControl, Domain catalogDomain) {
        Set catalogs;
        Optional<String> catalogName = FilterUtil.tryGetSingleVarcharValue(catalogDomain);
        if (catalogName.isPresent()) {
            Optional<CatalogHandle> catalogHandle = metadata.getCatalogHandle(session, catalogName.get());
            if (catalogHandle.isEmpty()) {
                return ImmutableSortedSet.of();
            }
            catalogs = ImmutableSet.of((Object)catalogName.get());
        } else {
            catalogs = (Set)metadata.listCatalogs(session).stream().map(CatalogInfo::getCatalogName).filter(MetadataListing.stringFilter(catalogDomain)).collect(ImmutableSet.toImmutableSet());
        }
        return ImmutableSortedSet.copyOf(accessControl.filterCatalogs(session.toSecurityContext(), catalogs));
    }

    public static List<CatalogInfo> listCatalogs(Session session, Metadata metadata, AccessControl accessControl) {
        List<CatalogInfo> catalogs = metadata.listCatalogs(session);
        Set catalogNames = (Set)catalogs.stream().map(CatalogInfo::getCatalogName).collect(ImmutableSet.toImmutableSet());
        Set<String> allowedCatalogs = accessControl.filterCatalogs(session.toSecurityContext(), catalogNames);
        return (List)catalogs.stream().filter(catalogInfo -> allowedCatalogs.contains(catalogInfo.getCatalogName())).collect(ImmutableList.toImmutableList());
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName) {
        return MetadataListing.listSchemas(session, metadata, accessControl, catalogName, Optional.empty());
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName, Optional<String> schemaName) {
        try {
            return MetadataListing.doListSchemas(session, metadata, accessControl, catalogName, schemaName);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "schemas", catalogName);
        }
    }

    private static SortedSet<String> doListSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName, Optional<String> schemaName) {
        ImmutableSet schemaNames = ImmutableSet.copyOf(metadata.listSchemaNames(session, catalogName));
        if (schemaName.isPresent()) {
            if (!schemaNames.contains(schemaName.get())) {
                return ImmutableSortedSet.of();
            }
            schemaNames = ImmutableSet.of((Object)schemaName.get());
        }
        return ImmutableSortedSet.copyOf(accessControl.filterSchemas(session.toSecurityContext(), catalogName, (Set<String>)schemaNames));
    }

    public static Set<SchemaTableName> listTables(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doListTables(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "tables", prefix.getCatalogName());
        }
    }

    private static Set<SchemaTableName> doListTables(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listTables(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Set<SchemaTableName> listViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doListViews(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "views", prefix.getCatalogName());
        }
    }

    private static Set<SchemaTableName> doListViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Map<SchemaTableName, ViewInfo> getViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doGetViews(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "views", prefix.getCatalogName());
        }
    }

    private static Map<SchemaTableName, ViewInfo> doGetViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map views = (Map)metadata.getViews(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> accessible = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), views.keySet());
        return (Map)views.entrySet().stream().filter(entry -> accessible.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<SchemaTableName> listMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doListMaterializedViews(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "materialized views", prefix.getCatalogName());
        }
    }

    private static Set<SchemaTableName> doListMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listMaterializedViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Map<SchemaTableName, ViewInfo> getMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doGetMaterializedViews(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "materialized views", prefix.getCatalogName());
        }
    }

    private static Map<SchemaTableName, ViewInfo> doGetMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map materializedViews = (Map)metadata.getMaterializedViews(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> accessible = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), materializedViews.keySet());
        return (Map)materializedViews.entrySet().stream().filter(entry -> accessible.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<GrantInfo> listTablePrivileges(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doListTablePrivileges(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "table privileges", prefix.getCatalogName());
        }
    }

    private static Set<GrantInfo> doListTablePrivileges(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        List<GrantInfo> grants = metadata.listTablePrivileges(session, prefix);
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), (Set)grants.stream().map(GrantInfo::getSchemaTableName).collect(ImmutableSet.toImmutableSet()));
        return (Set)grants.stream().filter(grantInfo -> allowedTables.contains(grantInfo.getSchemaTableName())).collect(ImmutableSet.toImmutableSet());
    }

    public static Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        try {
            return MetadataListing.doListTableColumns(session, metadata, accessControl, prefix);
        }
        catch (RuntimeException exception) {
            throw MetadataListing.handleListingException(exception, "table columns", prefix.getCatalogName());
        }
    }

    private static Map<SchemaTableName, List<ColumnMetadata>> doListTableColumns(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        AtomicInteger filteredCount = new AtomicInteger();
        List<TableColumnsMetadata> catalogColumns = metadata.listTableColumns(session, prefix, relationNames -> {
            Set<SchemaTableName> filtered = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), (Set<SchemaTableName>)relationNames);
            filteredCount.addAndGet(filtered.size());
            return filtered;
        });
        Preconditions.checkState((filteredCount.get() >= catalogColumns.size() ? 1 : 0) != 0, (String)"relationFilter is mandatory, but it has not been called for some of returned relations: returned %s relations, %s passed the filter", (int)catalogColumns.size(), (int)filteredCount.get());
        ImmutableMap.Builder result = ImmutableMap.builder();
        Map columnNamesByTable = (Map)catalogColumns.stream().filter(tableColumnsMetadata -> tableColumnsMetadata.getColumns().isPresent()).collect(ImmutableMap.toImmutableMap(TableColumnsMetadata::getTable, tableColumnsMetadata -> (Set)((List)tableColumnsMetadata.getColumns().orElseThrow()).stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet())));
        Map<SchemaTableName, Set<String>> catalogAllowedColumns = accessControl.filterColumns(session.toSecurityContext(), prefix.getCatalogName(), columnNamesByTable);
        catalogColumns.stream().filter(tableColumnsMetadata -> tableColumnsMetadata.getColumns().isPresent()).forEach(tableColumnsMetadata -> {
            Set allowedTableColumns = (Set)catalogAllowedColumns.getOrDefault(tableColumnsMetadata.getTable(), (Set<String>)ImmutableSet.of());
            result.put((Object)tableColumnsMetadata.getTable(), (Object)((List)((List)tableColumnsMetadata.getColumns().get()).stream().filter(column -> allowedTableColumns.contains(column.getName())).collect(ImmutableList.toImmutableList())));
        });
        catalogColumns.stream().filter(tableColumnsMetadata -> tableColumnsMetadata.getColumns().isEmpty()).forEach(tableColumnsMetadata -> {
            TableHandle targetTableHandle;
            QualifiedObjectName actualTableName;
            SchemaTableName table = tableColumnsMetadata.getTable();
            QualifiedObjectName originalTableName = new QualifiedObjectName(prefix.getCatalogName(), table.getSchemaName(), table.getTableName());
            try {
                RedirectionAwareTableHandle redirection = metadata.getRedirectionAwareTableHandle(session, originalTableName);
                if (redirection.redirectedTableName().isEmpty()) {
                    return;
                }
                actualTableName = redirection.redirectedTableName().get();
                targetTableHandle = redirection.tableHandle().orElseThrow();
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_REDIRECTION_ERROR.toErrorCode())) {
                    return;
                }
                throw e;
            }
            List<ColumnMetadata> columns = metadata.getTableMetadata(session, targetTableHandle).getColumns();
            Set<String> allowedColumns = accessControl.filterColumns(session.toSecurityContext(), actualTableName.asCatalogSchemaTableName().getCatalogName(), (Map<SchemaTableName, Set<String>>)ImmutableMap.of((Object)actualTableName.asSchemaTableName(), (Object)((Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet())))).getOrDefault(actualTableName.asSchemaTableName(), (Set<String>)ImmutableSet.of());
            result.put((Object)table, (Object)((List)columns.stream().filter(column -> allowedColumns.contains(column.getName())).collect(ImmutableList.toImmutableList())));
        });
        return result.buildOrThrow();
    }

    private static TrinoException handleListingException(RuntimeException exception, String type, String catalogName) {
        StandardErrorCode result = StandardErrorCode.GENERIC_INTERNAL_ERROR;
        if (exception instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)((Object)exception);
            result = () -> ((TrinoException)trinoException).getErrorCode();
        }
        return new TrinoException((ErrorCodeSupplier)result, "Error listing %s for catalog %s: %s".formatted(type, catalogName, exception.getMessage()), (Throwable)exception);
    }

    private static Predicate<String> stringFilter(Domain varcharDomain) {
        Preconditions.checkArgument((boolean)(varcharDomain.getType() instanceof VarcharType), (String)"Invalid domain type: %s", (Object)varcharDomain.getType());
        if (varcharDomain.isAll()) {
            return value -> true;
        }
        return value -> varcharDomain.includesNullableValue((Object)(value == null ? null : Slices.utf8Slice((String)value)));
    }
}

