/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import java.util.Objects;
import java.util.function.Function;

@Immutable
public class QualifiedObjectName {
    private final String catalogName;
    private final String schemaName;
    private final String objectName;

    @JsonCreator
    public static QualifiedObjectName valueOf(String name) {
        Objects.requireNonNull(name, "name is null");
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)name));
        Preconditions.checkArgument((ids.size() == 3 ? 1 : 0) != 0, (String)"Invalid name %s", (Object)name);
        return new QualifiedObjectName((String)ids.get(0), (String)ids.get(1), (String)ids.get(2));
    }

    public QualifiedObjectName(String catalogName, String schemaName, String objectName) {
        MetadataUtil.checkObjectName(catalogName, schemaName, objectName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public SchemaTableName asSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.objectName);
    }

    public CatalogSchemaTableName asCatalogSchemaTableName() {
        return new CatalogSchemaTableName(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaRoutineName asSchemaRoutineName() {
        return new SchemaRoutineName(this.schemaName, this.objectName);
    }

    public CatalogSchemaRoutineName asCatalogSchemaRoutineName() {
        return new CatalogSchemaRoutineName(this.catalogName, this.schemaName, this.objectName);
    }

    public QualifiedTablePrefix asQualifiedTablePrefix() {
        return new QualifiedTablePrefix(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaFunctionName asSchemaFunctionName() {
        return new SchemaFunctionName(this.schemaName, this.objectName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedObjectName o = (QualifiedObjectName)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.objectName, o.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.objectName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName + "." + this.schemaName + "." + this.objectName;
    }

    public static Function<SchemaTableName, QualifiedObjectName> convertFromSchemaTableName(String catalogName) {
        return input -> new QualifiedObjectName(catalogName, input.getSchemaName(), input.getTableName());
    }
}

