/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.JoinDomainBuilder;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.DynamicFilterSourceConsumer;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DynamicFilterSourceOperator
implements Operator {
    private final OperatorContext context;
    private final LocalMemoryContext userMemoryContext;
    private boolean finished;
    private Page current;
    private final DynamicFilterSourceConsumer dynamicPredicateConsumer;
    private final List<Channel> channels;
    private final JoinDomainBuilder[] joinDomainBuilders;
    private int minMaxCollectionLimit;
    private boolean isDomainCollectionComplete;

    private DynamicFilterSourceOperator(OperatorContext context, DynamicFilterSourceConsumer dynamicPredicateConsumer, List<Channel> channels, int maxDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, TypeOperators typeOperators) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.userMemoryContext = context.localUserMemoryContext();
        this.minMaxCollectionLimit = minMaxCollectionLimit;
        this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.joinDomainBuilders = (JoinDomainBuilder[])channels.stream().map(Channel::type).map(type -> new JoinDomainBuilder((Type)type, maxDistinctValues, maxFilterSize, minMaxCollectionLimit > 0, this::finishDomainCollectionIfNecessary, typeOperators)).toArray(JoinDomainBuilder[]::new);
        this.userMemoryContext.setBytes(Arrays.stream(this.joinDomainBuilders).mapToLong(JoinDomainBuilder::getRetainedSizeInBytes).sum());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public boolean needsInput() {
        return this.current == null && !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
        this.current = page;
        if (this.isDomainCollectionComplete) {
            return;
        }
        if (this.minMaxCollectionLimit >= 0) {
            this.minMaxCollectionLimit -= page.getPositionCount();
            if (this.minMaxCollectionLimit < 0) {
                for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
                    this.joinDomainBuilders[channelIndex].disableMinMax();
                }
                this.finishDomainCollectionIfNecessary();
            }
        }
        long retainedSize = 0L;
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = page.getBlock(this.channels.get(channelIndex).index());
            this.joinDomainBuilders[channelIndex].add(block);
            if (this.isDomainCollectionComplete) {
                return;
            }
            retainedSize += this.joinDomainBuilders[channelIndex].getRetainedSizeInBytes();
        }
        this.userMemoryContext.setBytes(retainedSize);
    }

    @Override
    public Page getOutput() {
        Page result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.isDomainCollectionComplete) {
            return;
        }
        ImmutableMap.Builder domainsBuilder = ImmutableMap.builder();
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            DynamicFilterId filterId = this.channels.get(channelIndex).filterId();
            domainsBuilder.put((Object)filterId, (Object)this.joinDomainBuilders[channelIndex].build());
        }
        this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.withColumnDomains((Map)domainsBuilder.buildOrThrow()));
        this.userMemoryContext.setBytes(0L);
        Arrays.fill(this.joinDomainBuilders, null);
    }

    @Override
    public boolean isFinished() {
        return this.current == null && this.finished;
    }

    @Override
    public void close() throws Exception {
        this.userMemoryContext.setBytes(0L);
    }

    private void finishDomainCollectionIfNecessary() {
        if (!this.isDomainCollectionComplete && Arrays.stream(this.joinDomainBuilders).noneMatch(JoinDomainBuilder::isCollecting)) {
            this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.all());
            this.isDomainCollectionComplete = true;
            this.userMemoryContext.setBytes(0L);
        }
    }

    public record Channel(DynamicFilterId filterId, Type type, int index) {
    }

    private static class PassthroughDynamicFilterSourceOperator
    implements Operator {
        private final OperatorContext operatorContext;
        private boolean finished;
        private Page current;

        private PassthroughDynamicFilterSourceOperator(OperatorContext operatorContext) {
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        }

        @Override
        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        @Override
        public boolean needsInput() {
            return this.current == null && !this.finished;
        }

        @Override
        public void addInput(Page page) {
            Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
            this.current = page;
        }

        @Override
        public Page getOutput() {
            Page result = this.current;
            this.current = null;
            return result;
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.current == null && this.finished;
        }
    }

    public static class DynamicFilterSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final DynamicFilterSourceConsumer dynamicPredicateConsumer;
        private final List<Channel> channels;
        private final int maxDistinctValues;
        private final DataSize maxFilterSize;
        private final int minMaxCollectionLimit;
        private final TypeOperators typeOperators;
        private boolean closed;
        private int createdOperatorsCount;

        public DynamicFilterSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, DynamicFilterSourceConsumer dynamicPredicateConsumer, List<Channel> channels, int maxDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, TypeOperators typeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
            this.channels = Objects.requireNonNull(channels, "channels is null");
            Verify.verify((channels.stream().map(Channel::filterId).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate dynamic filters are not allowed", (Object[])new Object[0]);
            Verify.verify((channels.stream().map(Channel::index).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate channel indices are not allowed", (Object[])new Object[0]);
            this.maxDistinctValues = maxDistinctValues;
            this.maxFilterSize = maxFilterSize;
            this.minMaxCollectionLimit = minMaxCollectionLimit;
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            ++this.createdOperatorsCount;
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DynamicFilterSourceOperator.class.getSimpleName());
            if (!this.dynamicPredicateConsumer.isDomainCollectionComplete()) {
                return new DynamicFilterSourceOperator(operatorContext, this.dynamicPredicateConsumer, this.channels, this.maxDistinctValues, this.maxFilterSize, this.minMaxCollectionLimit, this.typeOperators);
            }
            return new PassthroughDynamicFilterSourceOperator(operatorContext);
        }

        @Override
        public void noMoreOperators() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.closed = true;
            this.dynamicPredicateConsumer.setPartitionCount(this.createdOperatorsCount);
        }

        @Override
        public OperatorFactory duplicate() {
            this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.all());
            return new DynamicFilterSourceOperatorFactory(this.operatorId, this.planNodeId, new DynamicFilterSourceConsumer(){

                @Override
                public void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setPartitionCount(int partitionCount) {
                }

                @Override
                public boolean isDomainCollectionComplete() {
                    return true;
                }
            }, this.channels, this.maxDistinctValues, this.maxFilterSize, this.minMaxCollectionLimit, this.typeOperators);
        }
    }
}

