/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationLoopBuilder;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.operator.aggregation.AggregationMaskCompiler;
import io.trino.operator.aggregation.CompiledAccumulatorFactory;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.WindowAccumulator;
import io.trino.operator.window.InternalWindowIndex;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.function.WindowIndex;
import io.trino.sql.gen.Binding;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.CompilerOperations;
import io.trino.sql.gen.LambdaMetafactoryGenerator;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class AccumulatorCompiler {
    private AccumulatorCompiler() {
    }

    public static AccumulatorFactory generateAccumulatorFactory(BoundSignature boundSignature, AggregationImplementation implementation, FunctionNullability functionNullability, boolean specializedLoops) {
        implementation = AccumulatorCompiler.normalizeAggregationMethods(implementation);
        DynamicClassLoader classLoader = new DynamicClassLoader(AccumulatorCompiler.class.getClassLoader());
        List<Boolean> argumentNullable = functionNullability.getArgumentNullable().subList(0, functionNullability.getArgumentNullable().size() - implementation.getLambdaInterfaces().size());
        Constructor<GroupedAccumulator> groupedAccumulatorConstructor = AccumulatorCompiler.generateAccumulatorClass(boundSignature, GroupedAccumulator.class, implementation, argumentNullable, classLoader, specializedLoops);
        Constructor<Accumulator> accumulatorConstructor = AccumulatorCompiler.generateAccumulatorClass(boundSignature, Accumulator.class, implementation, argumentNullable, classLoader, specializedLoops);
        ArrayList<Integer> nonNullArguments = new ArrayList<Integer>();
        for (int argumentIndex = 0; argumentIndex < argumentNullable.size(); ++argumentIndex) {
            if (argumentNullable.get(argumentIndex).booleanValue()) continue;
            nonNullArguments.add(argumentIndex);
        }
        Constructor<? extends AggregationMaskBuilder> maskBuilderConstructor = AggregationMaskCompiler.generateAggregationMaskBuilder(nonNullArguments.stream().mapToInt(Integer::intValue).toArray());
        return new CompiledAccumulatorFactory(accumulatorConstructor, groupedAccumulatorConstructor, implementation.getLambdaInterfaces(), maskBuilderConstructor);
    }

    private static <T> Constructor<? extends T> generateAccumulatorClass(BoundSignature boundSignature, Class<T> accumulatorInterface, AggregationImplementation implementation, List<Boolean> argumentNullable, DynamicClassLoader classLoader, boolean specializedLoops) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(boundSignature.getName().getFunctionName() + accumulatorInterface.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(accumulatorInterface)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        List stateDescriptors = implementation.getAccumulatorStateDescriptors();
        ArrayList<StateFieldAndDescriptor> stateFieldAndDescriptors = new ArrayList<StateFieldAndDescriptor>();
        for (int i = 0; i < stateDescriptors.size(); ++i) {
            stateFieldAndDescriptors.add(new StateFieldAndDescriptor((AggregationImplementation.AccumulatorStateDescriptor)stateDescriptors.get(i), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateSerializer_" + i, AccumulatorStateSerializer.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateFactory_" + i, AccumulatorStateFactory.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "state_" + i, grouped ? GroupedAccumulatorState.class : AccumulatorState.class)));
        }
        List stateFields = (List)stateFieldAndDescriptors.stream().map(StateFieldAndDescriptor::getStateField).collect(ImmutableList.toImmutableList());
        int lambdaCount = implementation.getLambdaInterfaces().size();
        ArrayList<FieldDefinition> lambdaProviderFields = new ArrayList<FieldDefinition>(lambdaCount);
        for (int i = 0; i < lambdaCount; ++i) {
            lambdaProviderFields.add(definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "lambdaProvider_" + i, Supplier.class));
        }
        AccumulatorCompiler.generateConstructor(definition, stateFieldAndDescriptors, lambdaProviderFields, callSiteBinder, grouped);
        AccumulatorCompiler.generateCopyConstructor(definition, stateFieldAndDescriptors, lambdaProviderFields);
        AccumulatorCompiler.generateCopy(definition, Accumulator.class);
        AccumulatorCompiler.generateAddInput(definition, specializedLoops, stateFields, argumentNullable, lambdaProviderFields, implementation.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateFields);
        if (grouped) {
            AccumulatorCompiler.generateSetGroupCount(definition, stateFields);
        }
        AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateFieldAndDescriptors, lambdaProviderFields, implementation.getCombineFunction(), callSiteBinder, grouped);
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateFieldAndDescriptors, true);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, stateFieldAndDescriptors, true);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, stateFields, implementation.getOutputFunction(), callSiteBinder);
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, stateFields, implementation.getOutputFunction(), callSiteBinder);
        }
        if (grouped) {
            AccumulatorCompiler.generatePrepareFinal(definition);
        }
        Class<T> accumulatorClass = CompilerUtils.defineClass(definition, accumulatorInterface, callSiteBinder.getBindings(), (ClassLoader)classLoader);
        try {
            return accumulatorClass.getConstructor(List.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<? extends WindowAccumulator> generateWindowAccumulatorClass(BoundSignature boundSignature, AggregationImplementation implementation, FunctionNullability functionNullability) {
        implementation = AccumulatorCompiler.normalizeAggregationMethods(implementation);
        DynamicClassLoader classLoader = new DynamicClassLoader(AccumulatorCompiler.class.getClassLoader());
        List<Boolean> argumentNullable = functionNullability.getArgumentNullable().subList(0, functionNullability.getArgumentNullable().size() - implementation.getLambdaInterfaces().size());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(boundSignature.getName().getFunctionName() + WindowAccumulator.class.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(WindowAccumulator.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        List stateDescriptors = implementation.getAccumulatorStateDescriptors();
        ArrayList<StateFieldAndDescriptor> stateFieldAndDescriptors = new ArrayList<StateFieldAndDescriptor>();
        for (int i = 0; i < stateDescriptors.size(); ++i) {
            stateFieldAndDescriptors.add(new StateFieldAndDescriptor((AggregationImplementation.AccumulatorStateDescriptor)stateDescriptors.get(i), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateSerializer_" + i, AccumulatorStateSerializer.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "stateFactory_" + i, AccumulatorStateFactory.class), definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "state_" + i, AccumulatorState.class)));
        }
        List stateFields = (List)stateFieldAndDescriptors.stream().map(StateFieldAndDescriptor::getStateField).collect(ImmutableList.toImmutableList());
        int lambdaCount = implementation.getLambdaInterfaces().size();
        ArrayList<FieldDefinition> lambdaProviderFields = new ArrayList<FieldDefinition>(lambdaCount);
        for (int i = 0; i < lambdaCount; ++i) {
            lambdaProviderFields.add(definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "lambdaProvider_" + i, Supplier.class));
        }
        AccumulatorCompiler.generateWindowAccumulatorConstructor(definition, stateFieldAndDescriptors, lambdaProviderFields, callSiteBinder);
        AccumulatorCompiler.generateCopyConstructor(definition, stateFieldAndDescriptors, lambdaProviderFields);
        AccumulatorCompiler.generateCopy(definition, WindowAccumulator.class);
        AccumulatorCompiler.generateAddOrRemoveInputWindowIndex(definition, stateFields, argumentNullable, lambdaProviderFields, implementation.getInputFunction(), "addInput", callSiteBinder);
        implementation.getRemoveInputFunction().ifPresent(removeInputFunction -> AccumulatorCompiler.generateAddOrRemoveInputWindowIndex(definition, stateFields, argumentNullable, lambdaProviderFields, removeInputFunction, "removeInput", callSiteBinder));
        AccumulatorCompiler.generateEvaluateFinal(definition, stateFields, implementation.getOutputFunction(), callSiteBinder);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateFields);
        Class<WindowAccumulator> windowAccumulatorClass = CompilerUtils.defineClass(definition, WindowAccumulator.class, callSiteBinder.getBindings(), (ClassLoader)classLoader);
        try {
            return windowAccumulatorClass.getConstructor(List.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateWindowAccumulatorConstructor(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> lambdaProviderFields, CallSiteBinder callSiteBinder) {
        Parameter lambdaProviders = Parameter.arg((String)"lambdaProviders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Supplier.class}));
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{lambdaProviders});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        AccumulatorCompiler.initializeStateFields(method, stateFieldAndDescriptors, callSiteBinder, false);
        AccumulatorCompiler.initializeLambdaProviderFields(method, lambdaProviderFields, lambdaProviders);
        body.ret();
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, List<FieldDefinition> stateFields) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable estimatedSize = method.getScope().declareVariable(Long.TYPE, "estimatedSize");
        method.getBody().append((BytecodeNode)estimatedSize.set(BytecodeExpressions.constantLong((long)0L)));
        for (FieldDefinition stateField : stateFields) {
            method.getBody().append((BytecodeNode)estimatedSize.set(BytecodeExpressions.add((BytecodeExpression)estimatedSize, (BytecodeExpression)method.getThis().getField(stateField).invoke("getEstimatedSize", Long.TYPE, new BytecodeExpression[0]))));
        }
        method.getBody().append((BytecodeNode)estimatedSize.ret());
    }

    private static void generateSetGroupCount(ClassDefinition definition, List<FieldDefinition> stateFields) {
        Parameter groupCount = Parameter.arg((String)"groupCount", Long.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "setGroupCount", ParameterizedType.type(Void.TYPE), new Parameter[]{groupCount});
        BytecodeBlock body = method.getBody();
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = method.getScope().getThis().getField(stateField);
            body.append((BytecodeNode)state.invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{groupCount}));
        }
        body.ret();
    }

    private static void generateAddInput(ClassDefinition definition, boolean specializedLoops, List<FieldDefinition> stateField, List<Boolean> argumentNullable, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        int i;
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIds", int[].class));
        }
        Parameter arguments = Parameter.arg((String)"arguments", Page.class);
        parameters.add((Object)arguments);
        Parameter mask = Parameter.arg((String)"mask", AggregationMask.class);
        parameters.add((Object)mask);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addInput", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        ArrayList<Variable> parameterVariables = new ArrayList<Variable>();
        for (i = 0; i < argumentNullable.size(); ++i) {
            parameterVariables.add(scope.declareVariable(Block.class, "block" + i));
        }
        for (i = 0; i < parameterVariables.size(); ++i) {
            body.comment("%s = arguments.getBlock(%d);", new Object[]{((Variable)parameterVariables.get(i)).getName(), i}).append((BytecodeNode)((Variable)parameterVariables.get(i)).set(arguments.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})));
        }
        BytecodeBlock block = AccumulatorCompiler.generateInputForLoop(specializedLoops, stateField, inputFunction, scope, parameterVariables, lambdaProviderFields, (Variable)mask, callSiteBinder, grouped);
        body.append((BytecodeNode)block);
        body.ret();
    }

    private static void generateAddOrRemoveInputWindowIndex(ClassDefinition definition, List<FieldDefinition> stateField, List<Boolean> argumentNullable, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, String generatedFunctionName, CallSiteBinder callSiteBinder) {
        Parameter index = Parameter.arg((String)"index", WindowIndex.class);
        Parameter startPosition = Parameter.arg((String)"startPosition", Integer.TYPE);
        Parameter endPosition = Parameter.arg((String)"endPosition", Integer.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), generatedFunctionName, ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.of((Object)index, (Object)startPosition, (Object)endPosition));
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable inputBlockPosition = scope.declareVariable(Integer.TYPE, "inputBlockPosition");
        ArrayList<Variable> inputBlockVariables = new ArrayList<Variable>();
        for (int i = 0; i < argumentNullable.size(); ++i) {
            inputBlockVariables.add(scope.declareVariable(Block.class, "inputBlock" + i));
        }
        Binding binding = callSiteBinder.bind(inputFunction);
        BytecodeBlock invokeInputFunction = new BytecodeBlock();
        invokeInputFunction.append((BytecodeNode)inputBlockPosition.set(index.cast(InternalWindowIndex.class).invoke("getRawBlockPosition", Integer.TYPE, new BytecodeExpression[]{position})));
        for (int i = 0; i < inputBlockVariables.size(); ++i) {
            invokeInputFunction.append((BytecodeNode)((Variable)inputBlockVariables.get(i)).set(index.cast(InternalWindowIndex.class).invoke("getRawBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i), position})));
        }
        invokeInputFunction.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)generatedFunctionName, (MethodType)binding.getType(), AccumulatorCompiler.getInvokeFunctionOnWindowIndexParameters(scope.getThis(), stateField, inputBlockPosition, inputBlockVariables, lambdaProviderFields)));
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set((BytecodeExpression)startPosition)).condition((BytecodeNode)BytecodeExpressions.lessThanOrEqual((BytecodeExpression)position, (BytecodeExpression)endPosition)).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)AccumulatorCompiler.anyParametersAreNull(argumentNullable, (Variable)index, position)).ifFalse((BytecodeNode)invokeInputFunction))).ret();
    }

    private static BytecodeExpression anyParametersAreNull(List<Boolean> argumentNullable, Variable index, Variable position) {
        BytecodeExpression isNull = BytecodeExpressions.constantFalse();
        for (int inputChannel = 0; inputChannel < argumentNullable.size(); ++inputChannel) {
            if (argumentNullable.get(inputChannel).booleanValue()) continue;
            isNull = BytecodeExpressions.or((BytecodeExpression)isNull, (BytecodeExpression)index.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)inputChannel), position}));
        }
        return isNull;
    }

    private static List<BytecodeExpression> getInvokeFunctionOnWindowIndexParameters(Variable thisVariable, List<FieldDefinition> stateField, Variable inputBlockPosition, List<Variable> inputBlockVariables, List<FieldDefinition> lambdaProviderFields) {
        ArrayList<BytecodeExpression> expressions = new ArrayList<BytecodeExpression>();
        for (FieldDefinition field : stateField) {
            expressions.add(thisVariable.getField(field));
        }
        for (Variable blockVariable : inputBlockVariables) {
            expressions.add(blockVariable.invoke("getUnderlyingValueBlock", ValueBlock.class, new BytecodeExpression[0]));
            expressions.add(blockVariable.invoke("getUnderlyingValuePosition", Integer.TYPE, new BytecodeExpression[]{inputBlockPosition}));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            expressions.add(thisVariable.getField(lambdaProviderField).invoke("get", Object.class, new BytecodeExpression[0]));
        }
        return expressions;
    }

    private static BytecodeBlock generateInputForLoop(boolean specializedLoops, List<FieldDefinition> stateField, MethodHandle inputFunction, Scope scope, List<Variable> parameterVariables, List<FieldDefinition> lambdaProviderFields, Variable mask, CallSiteBinder callSiteBinder, boolean grouped) {
        if (specializedLoops) {
            BytecodeBlock newBlock = new BytecodeBlock();
            Variable thisVariable = scope.getThis();
            MethodHandle mainLoop = AggregationLoopBuilder.buildLoop(inputFunction, stateField.size(), parameterVariables.size(), grouped);
            ImmutableList.Builder parameters = ImmutableList.builder();
            parameters.add((Object)mask);
            if (grouped) {
                parameters.add((Object)scope.getVariable("groupIds"));
            }
            for (FieldDefinition fieldDefinition : stateField) {
                parameters.add((Object)thisVariable.getField(fieldDefinition));
            }
            parameters.addAll(parameterVariables);
            for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
                parameters.add((Object)scope.getThis().getField(lambdaProviderField).invoke("get", Object.class, new BytecodeExpression[0]));
            }
            newBlock.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(mainLoop), "mainLoop", (List<BytecodeExpression>)parameters.build()));
            return newBlock;
        }
        Variable positionVariable = scope.declareVariable(Integer.TYPE, "position");
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable selectedPositionsArrayVariable = scope.declareVariable(int[].class, "selectedPositionsArray");
        Variable selectedPositionVariable = scope.declareVariable(Integer.TYPE, "selectedPosition");
        BytecodeBlock block = new BytecodeBlock().initializeVariable(rowsVariable).initializeVariable(selectedPositionVariable).initializeVariable(positionVariable);
        ForLoop selectAllLoop = new ForLoop().initialize((BytecodeNode)new BytecodeBlock().append((BytecodeNode)rowsVariable.set(mask.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0)))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)positionVariable, (BytecodeExpression)rowsVariable)).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, positionVariable, parameterVariables, lambdaProviderFields, inputFunction, callSiteBinder, grouped));
        ForLoop selectedPositionsLoop = new ForLoop().initialize((BytecodeNode)new BytecodeBlock().append((BytecodeNode)rowsVariable.set(mask.invoke("getSelectedPositionCount", Integer.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)selectedPositionsArrayVariable.set(mask.invoke("getSelectedPositions", int[].class, new BytecodeExpression[0]))).append((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0)))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)positionVariable, (BytecodeExpression)rowsVariable)).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)selectedPositionVariable.set(selectedPositionsArrayVariable.getElement((BytecodeExpression)positionVariable))).append((BytecodeNode)AccumulatorCompiler.generateInvokeInputFunction(scope, stateField, selectedPositionVariable, parameterVariables, lambdaProviderFields, inputFunction, callSiteBinder, grouped)));
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)mask.invoke("isSelectAll", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)selectAllLoop).ifFalse((BytecodeNode)selectedPositionsLoop));
        return block;
    }

    private static BytecodeBlock generateInvokeInputFunction(Scope scope, List<FieldDefinition> stateField, Variable position, List<Variable> parameterVariables, List<FieldDefinition> lambdaProviderFields, MethodHandle inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        BytecodeBlock block = new BytecodeBlock();
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIds(scope, stateField, block, position);
        }
        block.comment("Call input function with unpacked Block arguments");
        ArrayList<BytecodeExpression> parameters = new ArrayList<BytecodeExpression>();
        for (FieldDefinition field : stateField) {
            parameters.add(scope.getThis().getField(field));
        }
        for (Variable variable : parameterVariables) {
            parameters.add(variable.invoke("getUnderlyingValueBlock", ValueBlock.class, new BytecodeExpression[0]));
            parameters.add(variable.invoke("getUnderlyingValuePosition", Integer.TYPE, new BytecodeExpression[]{position}));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            parameters.add(scope.getThis().getField(lambdaProviderField).invoke("get", Object.class, new BytecodeExpression[0]));
        }
        block.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputFunction), "input", parameters));
        return block;
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> lambdaProviderFields, Optional<MethodHandle> combineFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        int i;
        Object block;
        MethodDefinition method = AccumulatorCompiler.declareAddIntermediate(definition, grouped);
        if (combineFunction.isEmpty()) {
            method.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"Aggregation is not decomposable")})).throwObject();
            return;
        }
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        int stateCount = stateFieldAndDescriptors.size();
        ArrayList<Variable> scratchStates = new ArrayList<Variable>();
        for (int i2 = 0; i2 < stateCount; ++i2) {
            Class<AccumulatorState> scratchStateClass = AccumulatorState.class;
            scratchStates.add(scope.declareVariable(scratchStateClass, "scratchState_" + i2));
        }
        if (stateCount == 1) {
            block = ImmutableList.of((Object)scope.getVariable("block"));
        } else {
            Variable columnarRow = scope.declareVariable(ColumnarRow.class, "columnarRow");
            body.append((BytecodeNode)columnarRow.set(BytecodeExpressions.invokeStatic(ColumnarRow.class, (String)"toColumnarRow", ColumnarRow.class, (BytecodeExpression[])new BytecodeExpression[]{scope.getVariable("block")})));
            block = new ArrayList();
            for (i = 0; i < stateCount; ++i) {
                Variable columnBlock = scope.declareVariable(Block.class, "columnBlock_" + i);
                body.append((BytecodeNode)columnBlock.set(columnarRow.invoke("getField", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})));
                block.add(columnBlock);
            }
        }
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        for (i = 0; i < stateCount; ++i) {
            FieldDefinition stateFactoryField = stateFieldAndDescriptors.get(i).getStateFactoryField();
            body.comment(String.format("scratchState_%s = stateFactory[%s].createSingleState();", i, i)).append((BytecodeNode)thisVariable.getField(stateFactoryField)).invokeInterface(AccumulatorStateFactory.class, "createSingleState", AccumulatorState.class, new Class[0]).checkCast(((Variable)scratchStates.get(i)).getType()).putVariable((Variable)scratchStates.get(i));
        }
        List stateFields = (List)stateFieldAndDescriptors.stream().map(StateFieldAndDescriptor::getStateField).collect(ImmutableList.toImmutableList());
        BytecodeBlock loopBody = new BytecodeBlock();
        loopBody.comment("combine(state_0, state_1, ... scratchState_0, scratchState_1, ... lambda_0, lambda_1, ...)");
        for (FieldDefinition stateField : stateFields) {
            if (grouped) {
                Variable groupIds = scope.getVariable("groupIds");
                loopBody.append((BytecodeNode)thisVariable.getField(stateField).invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIds.getElement((BytecodeExpression)position).cast(Long.TYPE)}));
            }
            loopBody.append((BytecodeNode)thisVariable.getField(stateField));
        }
        for (int i3 = 0; i3 < stateCount; ++i3) {
            FieldDefinition stateSerializerField = stateFieldAndDescriptors.get(i3).getStateSerializerField();
            loopBody.append((BytecodeNode)thisVariable.getField(stateSerializerField).invoke("deserialize", Void.TYPE, new BytecodeExpression[]{(BytecodeExpression)block.get(i3), position, ((Variable)scratchStates.get(i3)).cast(AccumulatorState.class)}));
            loopBody.append((BytecodeNode)scratchStates.get(i3));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            loopBody.append((BytecodeNode)scope.getThis().getField(lambdaProviderField).invoke("get", Object.class, new BytecodeExpression[0]));
        }
        loopBody.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(combineFunction.get()), "combine", new BytecodeExpression[0]));
        body.append((BytecodeNode)AccumulatorCompiler.generateBlockNonNullPositionForLoop(scope, position, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIds(Scope scope, List<FieldDefinition> stateFields, BytecodeBlock block, Variable position) {
        Variable groupIds = scope.getVariable("groupIds");
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = scope.getThis().getField(stateField);
            block.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupIds.getElement((BytecodeExpression)position).cast(Long.TYPE)}));
        }
    }

    private static MethodDefinition declareAddIntermediate(ClassDefinition definition, boolean grouped) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)Parameter.arg((String)"groupIds", int[].class));
        }
        parameters.add((Object)Parameter.arg((String)"block", Block.class));
        return definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable)parameters.build());
    }

    private static BytecodeBlock generateBlockNonNullPositionForLoop(Scope scope, Variable positionVariable, BytecodeBlock loopBody) {
        Variable rowsVariable = scope.declareVariable(Integer.TYPE, "rows");
        Variable blockVariable = scope.getVariable("block");
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)blockVariable).invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement ifStatement = new IfStatement("if(!block.isNull(position))", new Object[0]).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockVariable).append((BytecodeNode)positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE})).ifFalse((BytecodeNode)loopBody);
        block.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)positionVariable.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positionVariable).append((BytecodeNode)rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(positionVariable, (byte)1)).body((BytecodeNode)ifStatement));
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, boolean decomposable) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        if (!decomposable) {
            method.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"Aggregation is not decomposable")})).throwObject();
            return;
        }
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        if (stateFieldAndDescriptors.size() == 1) {
            BytecodeExpression stateSerializer = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateSerializerField());
            BytecodeExpression state = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateField());
            body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)})).append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), out})).ret();
        } else {
            for (StateFieldAndDescriptor stateFieldAndDescriptor : stateFieldAndDescriptors) {
                BytecodeExpression state = thisVariable.getField(stateFieldAndDescriptor.getStateField());
                body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)}));
            }
            AccumulatorCompiler.generateSerializeState(definition, stateFieldAndDescriptors, out, thisVariable, body);
            body.ret();
        }
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, boolean decomposable) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        if (!decomposable) {
            method.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"Aggregation is not decomposable")})).throwObject();
            return;
        }
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        if (stateFieldAndDescriptors.size() == 1) {
            BytecodeExpression stateSerializer = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateSerializerField());
            BytecodeExpression state = thisVariable.getField(((StateFieldAndDescriptor)Iterables.getOnlyElement(stateFieldAndDescriptors)).getStateField());
            body.append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), out})).ret();
        } else {
            AccumulatorCompiler.generateSerializeState(definition, stateFieldAndDescriptors, out, thisVariable, body);
            body.ret();
        }
    }

    private static void generateSerializeState(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, Parameter out, Variable thisVariable, BytecodeBlock body) {
        MethodDefinition serializeState = AccumulatorCompiler.generateSerializeStateMethod(definition, stateFieldAndDescriptors);
        BytecodeExpression rowEntryBuilder = LambdaMetafactoryGenerator.generateMetafactory(RowValueBuilder.class, serializeState, (List<BytecodeExpression>)ImmutableList.of((Object)thisVariable));
        body.append((BytecodeNode)out.cast(RowBlockBuilder.class).invoke("buildEntry", Void.TYPE, new BytecodeExpression[]{rowEntryBuilder}));
    }

    private static MethodDefinition generateSerializeStateMethod(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors) {
        Parameter fieldBuilders = Parameter.arg((String)"fieldBuilders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{BlockBuilder.class}));
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), "serializeState", ParameterizedType.type(Void.TYPE), new Parameter[]{fieldBuilders});
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        for (int i = 0; i < stateFieldAndDescriptors.size(); ++i) {
            StateFieldAndDescriptor stateFieldAndDescriptor = stateFieldAndDescriptors.get(i);
            BytecodeExpression stateSerializer = thisVariable.getField(stateFieldAndDescriptor.getStateSerializerField());
            BytecodeExpression state = thisVariable.getField(stateFieldAndDescriptor.getStateField());
            BytecodeExpression fieldBuilder = fieldBuilders.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}).cast(BlockBuilder.class);
            body.append((BytecodeNode)stateSerializer.invoke("serialize", Void.TYPE, new BytecodeExpression[]{state.cast(AccumulatorState.class), fieldBuilder}));
        }
        body.ret();
        return method;
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, List<FieldDefinition> stateFields, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter groupId = Parameter.arg((String)"groupId", Integer.TYPE);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{groupId, out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        ArrayList<BytecodeExpression> states = new ArrayList<BytecodeExpression>();
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = thisVariable.getField(stateField);
            body.append((BytecodeNode)state.invoke("setGroupId", Void.TYPE, new BytecodeExpression[]{groupId.cast(Long.TYPE)}));
            states.add(state);
        }
        body.comment("output(state_0, state_1, ..., out)");
        states.forEach(arg_0 -> ((BytecodeBlock)body).append(arg_0));
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output", new BytecodeExpression[0]));
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, List<FieldDefinition> stateFields, MethodHandle outputFunction, CallSiteBinder callSiteBinder) {
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluateFinal", ParameterizedType.type(Void.TYPE), new Parameter[]{out});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        ArrayList<BytecodeExpression> states = new ArrayList<BytecodeExpression>();
        for (FieldDefinition stateField : stateFields) {
            BytecodeExpression state = thisVariable.getField(stateField);
            states.add(state);
        }
        body.comment("output(state_0, state_1, ..., out)");
        states.forEach(arg_0 -> ((BytecodeBlock)body).append(arg_0));
        body.append((BytecodeNode)out);
        body.append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(outputFunction), "output", new BytecodeExpression[0]));
        body.ret();
    }

    private static void generatePrepareFinal(ClassDefinition definition) {
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "prepareFinal", ParameterizedType.type(Void.TYPE), new Parameter[0]);
        method.getBody().ret();
    }

    private static void generateConstructor(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> lambdaProviderFields, CallSiteBinder callSiteBinder, boolean grouped) {
        Parameter lambdaProviders = Parameter.arg((String)"lambdaProviders", (ParameterizedType)ParameterizedType.type(List.class, (Class[])new Class[]{Supplier.class}));
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{lambdaProviders});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull((Variable)lambdaProviders));
        AccumulatorCompiler.initializeStateFields(method, stateFieldAndDescriptors, callSiteBinder, grouped);
        AccumulatorCompiler.initializeLambdaProviderFields(method, lambdaProviderFields, lambdaProviders);
        body.ret();
    }

    private static void initializeStateFields(MethodDefinition method, List<StateFieldAndDescriptor> stateFieldAndDescriptors, CallSiteBinder callSiteBinder, boolean grouped) {
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        for (StateFieldAndDescriptor fieldAndDescriptor : stateFieldAndDescriptors) {
            AggregationImplementation.AccumulatorStateDescriptor<?> accumulatorStateDescriptor = fieldAndDescriptor.getAccumulatorStateDescriptor();
            body.append((BytecodeNode)thisVariable.setField(fieldAndDescriptor.getStateSerializerField(), BytecodeUtils.loadConstant(callSiteBinder, accumulatorStateDescriptor.getSerializer(), AccumulatorStateSerializer.class)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, fieldAndDescriptor.getStateSerializerField()));
            body.append((BytecodeNode)thisVariable.setField(fieldAndDescriptor.getStateFactoryField(), BytecodeUtils.loadConstant(callSiteBinder, accumulatorStateDescriptor.getFactory(), AccumulatorStateFactory.class)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, fieldAndDescriptor.getStateFactoryField()));
            FieldDefinition stateField = fieldAndDescriptor.getStateField();
            BytecodeExpression stateFactory = thisVariable.getField(fieldAndDescriptor.getStateFactoryField());
            BytecodeExpression createStateInstance = stateFactory.invoke(grouped ? "createGroupedState" : "createSingleState", AccumulatorState.class, new BytecodeExpression[0]);
            body.append((BytecodeNode)thisVariable.setField(stateField, createStateInstance.cast(stateField.getType())));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, stateField));
        }
    }

    private static void initializeLambdaProviderFields(MethodDefinition method, List<FieldDefinition> lambdaProviderFields, Parameter lambdaProviders) {
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        for (int i = 0; i < lambdaProviderFields.size(); ++i) {
            body.append((BytecodeNode)thisVariable.setField(lambdaProviderFields.get(i), lambdaProviders.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)}).cast(Supplier.class)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, lambdaProviderFields.get(i)));
        }
    }

    private static void generateCopyConstructor(ClassDefinition definition, List<StateFieldAndDescriptor> stateFieldAndDescriptors, List<FieldDefinition> lambdaProviderFields) {
        Parameter source = Parameter.arg((String)"source", (ParameterizedType)definition.getType());
        MethodDefinition method = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{source});
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull((Variable)source));
        for (StateFieldAndDescriptor descriptor : stateFieldAndDescriptors) {
            FieldDefinition stateSerializerField = descriptor.getStateSerializerField();
            body.append((BytecodeNode)thisVariable.setField(stateSerializerField, source.getField(stateSerializerField)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, stateSerializerField));
            FieldDefinition stateFactoryField = descriptor.getStateFactoryField();
            body.append((BytecodeNode)thisVariable.setField(stateFactoryField, source.getField(stateFactoryField)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, stateFactoryField));
            FieldDefinition stateField = descriptor.getStateField();
            body.append((BytecodeNode)thisVariable.setField(stateField, source.getField(stateField).invoke("copy", AccumulatorState.class, new BytecodeExpression[0]).cast(stateField.getType())));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, stateField));
        }
        for (FieldDefinition lambdaProviderField : lambdaProviderFields) {
            body.append((BytecodeNode)thisVariable.setField(lambdaProviderField, source.getField(lambdaProviderField)));
            body.append((BytecodeNode)AccumulatorCompiler.generateRequireNotNull(thisVariable, lambdaProviderField));
        }
        body.ret();
    }

    private static void generateCopy(ClassDefinition definition, Class<?> returnType) {
        MethodDefinition copy = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "copy", ParameterizedType.type(returnType), new Parameter[0]);
        copy.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)definition.getType(), (BytecodeExpression[])new BytecodeExpression[]{copy.getScope().getThis()}).ret());
    }

    private static BytecodeExpression generateRequireNotNull(Variable variable) {
        return AccumulatorCompiler.generateRequireNotNull((BytecodeExpression)variable, variable.getName() + " is null");
    }

    private static BytecodeExpression generateRequireNotNull(Variable variable, FieldDefinition field) {
        return AccumulatorCompiler.generateRequireNotNull(variable.getField(field), field.getName() + " is null");
    }

    private static BytecodeExpression generateRequireNotNull(BytecodeExpression expression, String message) {
        return BytecodeExpressions.invokeStatic(Objects.class, (String)"requireNonNull", Object.class, (BytecodeExpression[])new BytecodeExpression[]{expression.cast(Object.class), BytecodeExpressions.constantString((String)message)}).cast(expression.getType());
    }

    private static AggregationImplementation normalizeAggregationMethods(AggregationImplementation implementation) {
        int lambdaParameterCount = implementation.getLambdaInterfaces().size();
        AggregationImplementation.Builder builder = AggregationImplementation.builder();
        builder.inputFunction(AccumulatorCompiler.normalizeParameters(implementation.getInputFunction(), lambdaParameterCount));
        implementation.getRemoveInputFunction().map(removeFunction -> AccumulatorCompiler.normalizeParameters(removeFunction, lambdaParameterCount)).ifPresent(arg_0 -> ((AggregationImplementation.Builder)builder).removeInputFunction(arg_0));
        implementation.getCombineFunction().map(combineFunction -> AccumulatorCompiler.normalizeParameters(combineFunction, lambdaParameterCount)).ifPresent(arg_0 -> ((AggregationImplementation.Builder)builder).combineFunction(arg_0));
        builder.outputFunction(AccumulatorCompiler.normalizeParameters(implementation.getOutputFunction(), 0));
        builder.accumulatorStateDescriptors(implementation.getAccumulatorStateDescriptors());
        builder.lambdaInterfaces(implementation.getLambdaInterfaces());
        return builder.build();
    }

    private static MethodHandle normalizeParameters(MethodHandle function, int lambdaParameterCount) {
        int i;
        Class<?>[] parameterTypes = function.type().parameterArray();
        for (i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (AccumulatorState.class.isAssignableFrom(parameterType)) {
                parameterTypes[i] = AccumulatorState.class;
                continue;
            }
            if (!ValueBlock.class.isAssignableFrom(parameterType)) continue;
            parameterTypes[i] = ValueBlock.class;
        }
        for (i = parameterTypes.length - lambdaParameterCount; i < parameterTypes.length; ++i) {
            parameterTypes[i] = Object.class;
        }
        MethodType newType = MethodType.methodType(function.type().returnType(), parameterTypes);
        return MethodHandles.explicitCastArguments(function, newType);
    }

    private static class StateFieldAndDescriptor {
        private final AggregationImplementation.AccumulatorStateDescriptor<?> accumulatorStateDescriptor;
        private final FieldDefinition stateSerializerField;
        private final FieldDefinition stateFactoryField;
        private final FieldDefinition stateField;

        private StateFieldAndDescriptor(AggregationImplementation.AccumulatorStateDescriptor<?> accumulatorStateDescriptor, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition stateField) {
            this.accumulatorStateDescriptor = accumulatorStateDescriptor;
            this.stateSerializerField = Objects.requireNonNull(stateSerializerField, "stateSerializerField is null");
            this.stateFactoryField = Objects.requireNonNull(stateFactoryField, "stateFactoryField is null");
            this.stateField = Objects.requireNonNull(stateField, "stateField is null");
        }

        public AggregationImplementation.AccumulatorStateDescriptor<?> getAccumulatorStateDescriptor() {
            return this.accumulatorStateDescriptor;
        }

        private FieldDefinition getStateSerializerField() {
            return this.stateSerializerField;
        }

        private FieldDefinition getStateFactoryField() {
            return this.stateFactoryField;
        }

        private FieldDefinition getStateField() {
            return this.stateField;
        }
    }
}

