/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.trino.operator.aggregation.ApproximateLongPercentileAggregations;
import io.trino.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileArrayAggregations {
    private ApproximateLongPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.input(state, ApproximateLongPercentileAggregations.toDoubleExact(value), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="double") double weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.weightedInput(state, ApproximateLongPercentileAggregations.toDoubleExact(value), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileArrayState state, TDigestAndPercentileArrayState otherState) {
        ApproximateDoublePercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(bigint)")
    public static void output(@AggregationState TDigestAndPercentileArrayState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        ((ArrayBlockBuilder)out).buildEntry(elementBuilder -> {
            List<Double> valuesAtPercentiles = ApproximateDoublePercentileArrayAggregations.valuesAtPercentiles(digest, percentiles);
            for (double value : valuesAtPercentiles) {
                BigintType.BIGINT.writeLong(elementBuilder, Math.round(value));
            }
        });
    }
}

