/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.slice.XxHash64;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PartitionFunction;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchangeSink;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.LocalPartitionGenerator;
import io.trino.operator.exchange.PartitioningExchanger;
import io.trino.operator.exchange.PassthroughExchanger;
import io.trino.operator.exchange.RandomExchanger;
import io.trino.operator.exchange.ScaleWriterExchanger;
import io.trino.operator.exchange.ScaleWriterPartitioningExchanger;
import io.trino.operator.output.SkewedPartitionRebalancer;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;

@ThreadSafe
public class LocalExchange {
    private static final int SCALE_WRITERS_MAX_PARTITIONS_PER_WRITER = 128;
    private final Supplier<LocalExchanger> exchangerSupplier;
    private final List<LocalExchangeSource> sources;
    @GuardedBy(value="this")
    private boolean allSourcesFinished;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private final Set<LocalExchangeSinkFactory> openSinkFactories = new HashSet<LocalExchangeSinkFactory>();
    @GuardedBy(value="this")
    private final Set<LocalExchangeSink> sinks = new HashSet<LocalExchangeSink>();
    @GuardedBy(value="this")
    private int nextSourceIndex;

    public LocalExchange(NodePartitioningManager nodePartitioningManager, Session session, int defaultConcurrency, PartitioningHandle partitioning, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel, DataSize maxBufferedBytes, TypeOperators typeOperators, DataSize writerScalingMinDataProcessed, Supplier<Long> totalMemoryUsed) {
        int bufferCount = LocalExchange.computeBufferCount(partitioning, defaultConcurrency, partitionChannels);
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            LocalExchangeMemoryManager memoryManager2 = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
            this.sources = (List)IntStream.range(0, bufferCount).mapToObj(i -> new LocalExchangeSource(memoryManager2, source -> this.checkAllSourcesFinished())).collect(ImmutableList.toImmutableList());
            this.exchangerSupplier = () -> new RandomExchanger(LocalExchange.asPageConsumers(this.sources), memoryManager2);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            List memoryManagers = (List)IntStream.range(0, bufferCount).mapToObj(i -> new LocalExchangeMemoryManager(maxBufferedBytes.toBytes() / (long)bufferCount)).collect(ImmutableList.toImmutableList());
            this.sources = (List)memoryManagers.stream().map(memoryManager -> new LocalExchangeSource((LocalExchangeMemoryManager)memoryManager, source -> this.checkAllSourcesFinished())).collect(ImmutableList.toImmutableList());
            AtomicInteger nextSource = new AtomicInteger();
            this.exchangerSupplier = () -> {
                int currentSource = nextSource.getAndIncrement();
                Preconditions.checkState((currentSource < this.sources.size() ? 1 : 0) != 0, (Object)"no more sources");
                return new PassthroughExchanger(this.sources.get(currentSource), (LocalExchangeMemoryManager)memoryManagers.get(currentSource));
            };
        } else if (partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION)) {
            LocalExchangeMemoryManager memoryManager3 = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
            this.sources = (List)IntStream.range(0, bufferCount).mapToObj(i -> new LocalExchangeSource(memoryManager3, source -> this.checkAllSourcesFinished())).collect(ImmutableList.toImmutableList());
            AtomicLong dataProcessed = new AtomicLong(0L);
            this.exchangerSupplier = () -> new ScaleWriterExchanger(LocalExchange.asPageConsumers(this.sources), memoryManager3, maxBufferedBytes.toBytes(), dataProcessed, writerScalingMinDataProcessed, totalMemoryUsed, SystemSessionProperties.getQueryMaxMemoryPerNode(session).toBytes());
        } else if (PartitioningHandle.isScaledWriterHashDistribution(partitioning)) {
            int partitionCount = bufferCount * 128;
            SkewedPartitionRebalancer skewedPartitionRebalancer = new SkewedPartitionRebalancer(partitionCount, bufferCount, 1, writerScalingMinDataProcessed.toBytes(), SystemSessionProperties.getSkewedPartitionMinDataProcessedRebalanceThreshold(session).toBytes(), Math.max(SkewedPartitionRebalancer.getScaleWritersMaxSkewedPartitions(session), bufferCount));
            LocalExchangeMemoryManager memoryManager4 = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
            this.sources = (List)IntStream.range(0, bufferCount).mapToObj(i -> new LocalExchangeSource(memoryManager4, source -> this.checkAllSourcesFinished())).collect(ImmutableList.toImmutableList());
            this.exchangerSupplier = () -> {
                PartitionFunction partitionFunction = LocalExchange.createPartitionFunction(nodePartitioningManager, session, typeOperators, partitioning, partitionCount, partitionChannels, partitionChannelTypes, partitionHashChannel);
                return new ScaleWriterPartitioningExchanger(LocalExchange.asPageConsumers(this.sources), memoryManager4, maxBufferedBytes.toBytes(), LocalExchange.createPartitionPagePreparer(partitioning, partitionChannels), partitionFunction, partitionCount, skewedPartitionRebalancer, totalMemoryUsed, SystemSessionProperties.getQueryMaxMemoryPerNode(session).toBytes());
            };
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent() || partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            LocalExchangeMemoryManager memoryManager5 = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
            this.sources = (List)IntStream.range(0, bufferCount).mapToObj(i -> new LocalExchangeSource(memoryManager5, source -> this.checkAllSourcesFinished())).collect(ImmutableList.toImmutableList());
            this.exchangerSupplier = () -> {
                PartitionFunction partitionFunction = LocalExchange.createPartitionFunction(nodePartitioningManager, session, typeOperators, partitioning, bufferCount, partitionChannels, partitionChannelTypes, partitionHashChannel);
                return new PartitioningExchanger(LocalExchange.asPageConsumers(this.sources), memoryManager5, LocalExchange.createPartitionPagePreparer(partitioning, partitionChannels), partitionFunction);
            };
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
    }

    public int getBufferCount() {
        return this.sources.size();
    }

    public synchronized LocalExchangeSinkFactory createSinkFactory() {
        Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0, (Object)"No more sink factories already set");
        LocalExchangeSinkFactory newFactory = new LocalExchangeSinkFactory(this);
        this.openSinkFactories.add(newFactory);
        return newFactory;
    }

    public synchronized LocalExchangeSource getNextSource() {
        Preconditions.checkState((this.nextSourceIndex < this.sources.size() ? 1 : 0) != 0, (Object)"All operators already created");
        LocalExchangeSource result = this.sources.get(this.nextSourceIndex);
        ++this.nextSourceIndex;
        return result;
    }

    private static Function<Page, Page> createPartitionPagePreparer(PartitioningHandle partitioning, List<Integer> partitionChannels) {
        Function<Page, Page> partitionPagePreparer;
        if (partitioning.getConnectorHandle() instanceof SystemPartitioningHandle) {
            partitionPagePreparer = Function.identity();
        } else {
            int[] partitionChannelsArray = Ints.toArray(partitionChannels);
            partitionPagePreparer = page -> page.getColumns(partitionChannelsArray);
        }
        return partitionPagePreparer;
    }

    private static PartitionFunction createPartitionFunction(NodePartitioningManager nodePartitioningManager, Session session, TypeOperators typeOperators, PartitioningHandle partitioning, int partitionCount, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel) {
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        if (LocalExchange.isSystemPartitioning(partitioning)) {
            HashGenerator hashGenerator = partitionHashChannel.isPresent() ? new PrecomputedHashGenerator(partitionHashChannel.get()) : InterpretedHashGenerator.createChannelsHashGenerator(partitionChannelTypes, Ints.toArray(partitionChannels), typeOperators);
            return new LocalPartitionGenerator(hashGenerator, partitionCount);
        }
        int bucketCount = LocalExchange.getBucketCount(session, nodePartitioningManager, partitioning);
        int[] bucketToPartition = new int[bucketCount];
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            int hashedBucket = (int)XxHash64.hash((long)Long.reverse(bucket));
            bucketToPartition[bucket] = hashedBucket & partitionCount - 1;
        }
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioning.getConnectorHandle();
        if (connectorPartitioningHandle instanceof MergePartitioningHandle) {
            MergePartitioningHandle handle = (MergePartitioningHandle)connectorPartitioningHandle;
            return handle.getPartitionFunction((scheme, types) -> nodePartitioningManager.getPartitionFunction(session, scheme, types, bucketToPartition), partitionChannelTypes, bucketToPartition);
        }
        return new BucketPartitionFunction(nodePartitioningManager.getBucketFunction(session, partitioning, partitionChannelTypes, bucketCount), bucketToPartition);
    }

    public static int getBucketCount(Session session, NodePartitioningManager nodePartitioningManager, PartitioningHandle partitioning) {
        if (partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            return nodePartitioningManager.getNodePartitioningMap(session, partitioning).getBucketToPartition().length;
        }
        return nodePartitioningManager.getBucketNodeMap(session, partitioning).getBucketCount();
    }

    private static boolean isSystemPartitioning(PartitioningHandle partitioning) {
        return partitioning.getConnectorHandle() instanceof SystemPartitioningHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSourcesFinished() {
        ImmutableList openSinks;
        LocalExchange.checkNotHoldsLock(this);
        if (!this.sources.stream().allMatch(LocalExchangeSource::isFinished)) {
            return;
        }
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.allSourcesFinished = true;
            openSinks = ImmutableList.copyOf(this.sinks);
            this.sinks.clear();
        }
        openSinks.forEach(LocalExchangeSink::finish);
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExchangeSink createSink(LocalExchangeSinkFactory factory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            Preconditions.checkState((boolean)this.openSinkFactories.contains(factory), (Object)"Factory is already closed");
            if (this.allSourcesFinished) {
                return LocalExchangeSink.finishedLocalExchangeSink();
            }
            LocalExchanger exchanger = this.exchangerSupplier.get();
            LocalExchangeSink sink = new LocalExchangeSink(exchanger, this::sinkFinished);
            this.sinks.add(sink);
            return sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFinished(LocalExchangeSink sink) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.sinks.remove(sink);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreSinkFactories() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.noMoreSinkFactories = true;
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFactoryClosed(LocalExchangeSinkFactory sinkFactory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.openSinkFactories.remove(sinkFactory);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSinksComplete() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            if (!(this.noMoreSinkFactories && this.openSinkFactories.isEmpty() && this.sinks.isEmpty())) {
                return;
            }
        }
        this.sources.forEach(LocalExchangeSource::finish);
    }

    @VisibleForTesting
    LocalExchangeSource getSource(int partitionIndex) {
        return this.sources.get(partitionIndex);
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Cannot execute this method while holding a lock");
    }

    private static int computeBufferCount(PartitioningHandle partitioning, int defaultConcurrency, List<Integer> partitionChannels) {
        int bufferCount;
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            bufferCount = 1;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Gather exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Broadcast exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Arbitrary exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Passthrough exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Scaled writer exchange must not have partition channels");
        } else if (PartitioningHandle.isScaledWriterHashDistribution(partitioning)) {
            bufferCount = defaultConcurrency;
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent() || partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            bufferCount = defaultConcurrency;
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
        return bufferCount;
    }

    private static List<Consumer<Page>> asPageConsumers(List<LocalExchangeSource> sources) {
        return (List)sources.stream().map(buffer -> buffer::addPage).collect(ImmutableList.toImmutableList());
    }

    @ThreadSafe
    public static class LocalExchangeSinkFactory
    implements Closeable {
        private final LocalExchange exchange;

        private LocalExchangeSinkFactory(LocalExchange exchange) {
            this.exchange = Objects.requireNonNull(exchange, "exchange is null");
        }

        public LocalExchangeSink createSink() {
            return this.exchange.createSink(this);
        }

        public LocalExchangeSinkFactory duplicate() {
            return this.exchange.createSinkFactory();
        }

        @Override
        public void close() {
            this.exchange.sinkFactoryClosed(this);
        }

        public void noMoreSinkFactories() {
            this.exchange.noMoreSinkFactories();
        }
    }
}

