/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.operator.OperatorInfo;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.spi.Mergeable;
import java.util.Optional;

public class JoinOperatorInfo
implements Mergeable<JoinOperatorInfo>,
OperatorInfo {
    private final LookupJoinOperatorFactory.JoinType joinType;
    private final long[] logHistogramProbes;
    private final long[] logHistogramOutput;
    private final Optional<Long> lookupSourcePositions;
    private final long rleProbes;
    private final long totalProbes;

    public static JoinOperatorInfo createJoinOperatorInfo(LookupJoinOperatorFactory.JoinType joinType, long[] logHistogramCounters, Optional<Long> lookupSourcePositions, long rleProbes, long totalProbes) {
        long[] logHistogramProbes = new long[8];
        long[] logHistogramOutput = new long[8];
        for (int i = 0; i < 8; ++i) {
            logHistogramProbes[i] = logHistogramCounters[2 * i];
            logHistogramOutput[i] = logHistogramCounters[2 * i + 1];
        }
        return new JoinOperatorInfo(joinType, logHistogramProbes, logHistogramOutput, lookupSourcePositions, rleProbes, totalProbes);
    }

    @JsonCreator
    public JoinOperatorInfo(@JsonProperty(value="joinType") LookupJoinOperatorFactory.JoinType joinType, @JsonProperty(value="logHistogramProbes") long[] logHistogramProbes, @JsonProperty(value="logHistogramOutput") long[] logHistogramOutput, @JsonProperty(value="lookupSourcePositions") Optional<Long> lookupSourcePositions, @JsonProperty(value="rleProbes") long rleProbes, @JsonProperty(value="totalProbes") long totalProbes) {
        Preconditions.checkArgument((logHistogramProbes.length == 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((logHistogramOutput.length == 8 ? 1 : 0) != 0);
        this.joinType = joinType;
        this.logHistogramProbes = logHistogramProbes;
        this.logHistogramOutput = logHistogramOutput;
        this.lookupSourcePositions = lookupSourcePositions;
        this.rleProbes = rleProbes;
        this.totalProbes = totalProbes;
    }

    @JsonProperty
    public LookupJoinOperatorFactory.JoinType getJoinType() {
        return this.joinType;
    }

    @JsonProperty
    public long[] getLogHistogramProbes() {
        return this.logHistogramProbes;
    }

    @JsonProperty
    public long[] getLogHistogramOutput() {
        return this.logHistogramOutput;
    }

    @JsonProperty
    public Optional<Long> getLookupSourcePositions() {
        return this.lookupSourcePositions;
    }

    @JsonProperty
    public long getRleProbes() {
        return this.rleProbes;
    }

    @JsonProperty
    public long getTotalProbes() {
        return this.totalProbes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("joinType", (Object)this.joinType).add("logHistogramProbes", (Object)this.logHistogramProbes).add("logHistogramOutput", (Object)this.logHistogramOutput).add("lookupSourcePositions", this.lookupSourcePositions).add("rleProbes", this.rleProbes).add("totalProbes", this.totalProbes).toString();
    }

    public JoinOperatorInfo mergeWith(JoinOperatorInfo other) {
        Preconditions.checkState((this.joinType == other.joinType ? 1 : 0) != 0, (Object)"different join types");
        long[] logHistogramProbes = new long[8];
        long[] logHistogramOutput = new long[8];
        for (int i = 0; i < 8; ++i) {
            logHistogramProbes[i] = this.logHistogramProbes[i] + other.logHistogramProbes[i];
            logHistogramOutput[i] = this.logHistogramOutput[i] + other.logHistogramOutput[i];
        }
        Optional<Long> mergedSourcePositions = Optional.empty();
        if (this.lookupSourcePositions.isPresent() || other.lookupSourcePositions.isPresent()) {
            mergedSourcePositions = Optional.of(this.lookupSourcePositions.orElse(0L) + other.lookupSourcePositions.orElse(0L));
        }
        return new JoinOperatorInfo(this.joinType, logHistogramProbes, logHistogramOutput, mergedSourcePositions, this.rleProbes + other.rleProbes, this.totalProbes + other.totalProbes);
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

