/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;

public class LongPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LongPositionsAppender.class);
    private static final Block NULL_VALUE_BLOCK = new LongArrayBlock(1, Optional.of(new boolean[]{true}), new long[1]);
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public LongPositionsAppender(int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, ValueBlock block) {
        Preconditions.checkArgument((boolean)(block instanceof LongArrayBlock), (String)"Block must be instance of %s", LongArrayBlock.class);
        if (positions.isEmpty()) {
            return;
        }
        int[] positionArray = positions.elements();
        int positionsSize = positions.size();
        this.ensureCapacity(this.positionCount + positionsSize);
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                int positionIndex = this.positionCount + i;
                boolean isNull = block.isNull(position);
                if (isNull) {
                    this.valueIsNull[positionIndex] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.values[positionIndex] = block.getLong(position, 0);
                this.hasNonNullValue = true;
            }
            this.positionCount += positionsSize;
        } else {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                this.values[this.positionCount + i] = block.getLong(position, 0);
            }
            this.positionCount += positionsSize;
            this.hasNonNullValue = true;
        }
        this.updateSize(positionsSize);
    }

    @Override
    public void appendRle(ValueBlock block, int rlePositionCount) {
        Preconditions.checkArgument((boolean)(block instanceof LongArrayBlock), (String)"Block must be instance of %s", LongArrayBlock.class);
        if (rlePositionCount == 0) {
            return;
        }
        int sourcePosition = 0;
        this.ensureCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(sourcePosition)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullValue = true;
        } else {
            long value = block.getLong(sourcePosition, 0);
            Arrays.fill(this.values, this.positionCount, this.positionCount + rlePositionCount, value);
            this.hasNonNullValue = true;
        }
        this.positionCount += rlePositionCount;
        this.updateSize(rlePositionCount);
    }

    @Override
    public void append(int sourcePosition, ValueBlock source) {
        Preconditions.checkArgument((boolean)(source instanceof LongArrayBlock), (String)"Block must be instance of %s", LongArrayBlock.class);
        this.ensureCapacity(this.positionCount + 1);
        if (source.isNull(sourcePosition)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            this.values[this.positionCount] = source.getLong(sourcePosition, 0);
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        this.updateSize(1L);
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new LongArrayBlock(this.positionCount, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty(), this.values) : RunLengthEncodedBlock.create((Block)NULL_VALUE_BLOCK, (int)this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.values = new long[0];
        this.positionCount = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.values.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = PositionsAppenderUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateRetainedSize();
    }

    private void updateSize(long positionsSize) {
        this.sizeInBytes += 9L * positionsSize;
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.values);
    }
}

