/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.operator.output.BytePositionsAppender;
import io.trino.operator.output.Fixed12PositionsAppender;
import io.trino.operator.output.Int128PositionsAppender;
import io.trino.operator.output.IntPositionsAppender;
import io.trino.operator.output.LongPositionsAppender;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.RowPositionsAppender;
import io.trino.operator.output.ShortPositionsAppender;
import io.trino.operator.output.SlicePositionsAppender;
import io.trino.operator.output.TypedPositionsAppender;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;
import java.util.Optional;

public class PositionsAppenderFactory {
    private final BlockTypeOperators blockTypeOperators;

    public PositionsAppenderFactory(BlockTypeOperators blockTypeOperators) {
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public UnnestingPositionsAppender create(Type type, int expectedPositions, long maxPageSizeInBytes) {
        Optional<BlockTypeOperators.BlockPositionIsDistinctFrom> distinctFromOperator = Optional.empty();
        if (type.isComparable()) {
            distinctFromOperator = Optional.of(this.blockTypeOperators.getDistinctFromOperator(type));
        }
        return new UnnestingPositionsAppender(this.createPrimitiveAppender(type, expectedPositions, maxPageSizeInBytes), distinctFromOperator);
    }

    private PositionsAppender createPrimitiveAppender(Type type, int expectedPositions, long maxPageSizeInBytes) {
        if (type.getValueBlockType() == ByteArrayBlock.class) {
            return new BytePositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == ShortArrayBlock.class) {
            return new ShortPositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == IntArrayBlock.class) {
            return new IntPositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == LongArrayBlock.class) {
            return new LongPositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == Fixed12Block.class) {
            return new Fixed12PositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == Int128ArrayBlock.class) {
            return new Int128PositionsAppender(expectedPositions);
        }
        if (type.getValueBlockType() == VariableWidthBlock.class) {
            return new SlicePositionsAppender(expectedPositions, maxPageSizeInBytes);
        }
        if (type.getValueBlockType() == RowBlock.class) {
            return RowPositionsAppender.createRowAppender(this, (RowType)type, expectedPositions, maxPageSizeInBytes);
        }
        return new TypedPositionsAppender(type, expectedPositions);
    }
}

