/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;

public class SlicePositionsAppender
implements PositionsAppender {
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SlicePositionsAppender.class);
    private static final Block NULL_VALUE_BLOCK = new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 0}, Optional.of(new boolean[]{true}));
    private boolean initialized;
    private int initialEntryCount;
    private int initialBytesSize;
    private byte[] bytes = new byte[0];
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positionCount;
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public SlicePositionsAppender(int expectedEntries, long maxPageSizeInBytes) {
        this(expectedEntries, SlicePositionsAppender.getExpectedBytes(maxPageSizeInBytes, expectedEntries));
    }

    public SlicePositionsAppender(int expectedEntries, int expectedBytes) {
        this.initialEntryCount = expectedEntries;
        this.initialBytesSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, ValueBlock block) {
        Preconditions.checkArgument((boolean)(block instanceof VariableWidthBlock), (String)"Block must be instance of %s", VariableWidthBlock.class);
        if (positions.isEmpty()) {
            return;
        }
        this.ensurePositionCapacity(this.positionCount + positions.size());
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int newByteCount = 0;
        int[] lengths = new int[positions.size()];
        int[] sourceOffsets = new int[positions.size()];
        int[] positionArray = positions.elements();
        if (block.mayHaveNull()) {
            for (int i = 0; i < positions.size(); ++i) {
                boolean isNull;
                int length;
                int position = positionArray[i];
                lengths[i] = length = variableWidthBlock.getSliceLength(position);
                sourceOffsets[i] = variableWidthBlock.getRawSliceOffset(position);
                newByteCount += length;
                this.valueIsNull[this.positionCount + i] = isNull = block.isNull(position);
                this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i] + length;
                this.hasNullValue |= isNull;
                this.hasNonNullValue |= !isNull;
            }
        } else {
            for (int i = 0; i < positions.size(); ++i) {
                int length;
                int position = positionArray[i];
                lengths[i] = length = variableWidthBlock.getSliceLength(position);
                sourceOffsets[i] = variableWidthBlock.getRawSliceOffset(position);
                newByteCount += length;
                this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i] + length;
            }
            this.hasNonNullValue = true;
        }
        this.copyBytes(variableWidthBlock.getRawSlice(), lengths, sourceOffsets, positions.size(), newByteCount);
    }

    @Override
    public void appendRle(ValueBlock block, int rlePositionCount) {
        Preconditions.checkArgument((boolean)(block instanceof VariableWidthBlock), (String)"Block must be instance of %s", VariableWidthBlock.class);
        if (rlePositionCount == 0) {
            return;
        }
        this.ensurePositionCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(0)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            Arrays.fill(this.offsets, this.positionCount + 1, this.positionCount + rlePositionCount + 1, this.getCurrentOffset());
            this.positionCount += rlePositionCount;
            this.hasNullValue = true;
            this.updateSize(rlePositionCount, 0);
        } else {
            this.hasNonNullValue = true;
            this.duplicateBytes(block.getSlice(0, 0, block.getSliceLength(0)), rlePositionCount);
        }
    }

    @Override
    public void append(int position, ValueBlock source) {
        Preconditions.checkArgument((boolean)(source instanceof VariableWidthBlock), (Object)"Block must be instance of %s but is %s".formatted(VariableWidthBlock.class, source.getClass()));
        this.ensurePositionCapacity(this.positionCount + 1);
        if (source.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.offsets[this.positionCount + 1] = this.getCurrentOffset();
            ++this.positionCount;
            this.hasNullValue = true;
            this.updateSize(1L, 0);
        } else {
            this.hasNonNullValue = true;
            int currentOffset = this.getCurrentOffset();
            int sliceLength = source.getSliceLength(position);
            Slice slice = source.getSlice(position, 0, sliceLength);
            this.ensureExtraBytesCapacity(sliceLength);
            slice.getBytes(0, this.bytes, currentOffset, sliceLength);
            this.offsets[this.positionCount + 1] = currentOffset + sliceLength;
            ++this.positionCount;
            this.updateSize(1L, sliceLength);
        }
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new VariableWidthBlock(this.positionCount, Slices.wrappedBuffer((byte[])this.bytes, (int)0, (int)this.getCurrentOffset()), this.offsets, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty()) : RunLengthEncodedBlock.create((Block)NULL_VALUE_BLOCK, (int)this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void copyBytes(Slice rawSlice, int[] lengths, int[] sourceOffsets, int count, int newByteCount) {
        this.ensureExtraBytesCapacity(newByteCount);
        byte[] base = rawSlice.byteArray();
        int byteArrayOffset = rawSlice.byteArrayOffset();
        for (int i = 0; i < count; ++i) {
            System.arraycopy(base, byteArrayOffset + sourceOffsets[i], this.bytes, this.offsets[this.positionCount + i], lengths[i]);
        }
        this.positionCount += count;
        this.updateSize(count, newByteCount);
    }

    private void duplicateBytes(Slice slice, int count) {
        int length = slice.length();
        int newByteCount = Math.toIntExact((long)count * (long)length);
        int startOffset = this.getCurrentOffset();
        this.ensureExtraBytesCapacity(newByteCount);
        SlicePositionsAppender.duplicateBytes(slice, this.bytes, startOffset, count);
        int currentStartOffset = startOffset + length;
        for (int i = 0; i < count; ++i) {
            this.offsets[this.positionCount + i + 1] = currentStartOffset;
            currentStartOffset += length;
        }
        this.positionCount += count;
        this.updateSize(count, newByteCount);
    }

    @VisibleForTesting
    static void duplicateBytes(Slice slice, byte[] bytes, int startOffset, int count) {
        int length = slice.length();
        if (length == 0) {
            return;
        }
        slice.getBytes(0, bytes, startOffset, length);
        int totalDuplicatedBytes = count * length;
        int duplicatedBytes = length;
        while (duplicatedBytes * 2 <= totalDuplicatedBytes) {
            System.arraycopy(bytes, startOffset, bytes, startOffset + duplicatedBytes, duplicatedBytes);
            duplicatedBytes *= 2;
        }
        System.arraycopy(bytes, startOffset, bytes, startOffset + duplicatedBytes, totalDuplicatedBytes - duplicatedBytes);
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialBytesSize = PositionsAppenderUtil.calculateBlockResetBytes(this.getCurrentOffset());
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.offsets = new int[1];
        this.bytes = new byte[0];
        this.positionCount = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private int getCurrentOffset() {
        return this.offsets[this.positionCount];
    }

    private void updateSize(long positionsSize, int bytesWritten) {
        this.sizeInBytes += 5L * positionsSize + (long)bytesWritten;
    }

    private void ensureExtraBytesCapacity(int extraBytesCapacity) {
        int totalBytesCapacity = this.getCurrentOffset() + extraBytesCapacity;
        if (this.bytes.length < totalBytesCapacity) {
            int newBytesLength = Math.max(this.bytes.length, this.initialBytesSize);
            if (totalBytesCapacity > newBytesLength) {
                newBytesLength = Math.max(totalBytesCapacity, PositionsAppenderUtil.calculateNewArraySize(newBytesLength));
            }
            this.bytes = Arrays.copyOf(this.bytes, newBytesLength);
            this.updateRetainedSize();
        }
    }

    private void ensurePositionCapacity(int capacity) {
        if (this.valueIsNull.length < capacity) {
            int newSize;
            if (this.initialized) {
                newSize = PositionsAppenderUtil.calculateNewArraySize(this.valueIsNull.length);
            } else {
                newSize = this.initialEntryCount;
                this.initialized = true;
            }
            newSize = Math.max(newSize, capacity);
            this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
            this.updateRetainedSize();
        }
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((byte[])this.bytes);
    }

    private static int getExpectedBytes(long maxPageSizeInBytes, int expectedPositions) {
        return (int)Math.min((long)expectedPositions * 32L, maxPageSizeInBytes);
    }
}

