/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class UnnestingPositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UnnestingPositionsAppender.class);
    private final PositionsAppender delegate;
    @Nullable
    private final BlockTypeOperators.BlockPositionIsDistinctFrom isDistinctFromOperator;
    private State state = State.UNINITIALIZED;
    private ValueBlock dictionary;
    private DictionaryIdsBuilder dictionaryIdsBuilder;
    @Nullable
    private ValueBlock rleValue;
    private int rlePositionCount;

    public UnnestingPositionsAppender(PositionsAppender delegate, Optional<BlockTypeOperators.BlockPositionIsDistinctFrom> isDistinctFromOperator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.dictionaryIdsBuilder = new DictionaryIdsBuilder(1024);
        this.isDistinctFromOperator = isDistinctFromOperator.orElse(null);
    }

    public void append(IntArrayList positions, Block source) {
        if (positions.isEmpty()) {
            return;
        }
        if (source instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)source;
            this.appendRle(rleBlock.getValue(), positions.size());
        } else if (source instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)source;
            ValueBlock dictionary = dictionaryBlock.getDictionary();
            if (this.state == State.UNINITIALIZED) {
                this.state = State.DICTIONARY;
                this.dictionary = dictionary;
                this.dictionaryIdsBuilder.appendPositions(positions, dictionaryBlock);
            } else if (this.state == State.DICTIONARY && this.dictionary == dictionary) {
                this.dictionaryIdsBuilder.appendPositions(positions, dictionaryBlock);
            } else {
                this.transitionToDirect();
                int[] positionArray = new int[positions.size()];
                for (int i = 0; i < positions.size(); ++i) {
                    positionArray[i] = dictionaryBlock.getId(positions.getInt(i));
                }
                this.delegate.append(IntArrayList.wrap((int[])positionArray), dictionary);
            }
        } else if (source instanceof ValueBlock) {
            ValueBlock valueBlock = (ValueBlock)source;
            this.transitionToDirect();
            this.delegate.append(positions, valueBlock);
        } else {
            throw new IllegalArgumentException("Unsupported block type: " + source.getClass().getSimpleName());
        }
    }

    public void appendRle(ValueBlock value, int positionCount) {
        if (positionCount == 0) {
            return;
        }
        if (this.state == State.DICTIONARY) {
            this.transitionToDirect();
        }
        if (this.isDistinctFromOperator == null) {
            this.transitionToDirect();
        }
        if (this.state == State.UNINITIALIZED) {
            this.state = State.RLE;
            this.rleValue = value;
            this.rlePositionCount = positionCount;
            return;
        }
        if (this.state == State.RLE) {
            if (!this.isDistinctFromOperator.isDistinctFrom((Block)this.rleValue, 0, (Block)value, 0)) {
                this.rlePositionCount += positionCount;
                return;
            }
            this.transitionToDirect();
        }
        Verify.verify((this.state == State.DIRECT ? 1 : 0) != 0);
        this.delegate.appendRle(value, positionCount);
    }

    public void append(int position, Block source) {
        if (this.state != State.DIRECT) {
            this.transitionToDirect();
        }
        if (source instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)source;
            this.delegate.append(0, runLengthEncodedBlock.getValue());
        } else if (source instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)source;
            this.delegate.append(dictionaryBlock.getId(position), dictionaryBlock.getDictionary());
        } else if (source instanceof ValueBlock) {
            ValueBlock valueBlock = (ValueBlock)source;
            this.delegate.append(position, valueBlock);
        } else {
            throw new IllegalArgumentException("Unsupported block type: " + source.getClass().getSimpleName());
        }
    }

    private void transitionToDirect() {
        if (this.state == State.DICTIONARY) {
            int[] dictionaryIds = this.dictionaryIdsBuilder.getDictionaryIds();
            this.delegate.append(IntArrayList.wrap((int[])dictionaryIds, (int)this.dictionaryIdsBuilder.size()), this.dictionary);
            this.dictionary = null;
            this.dictionaryIdsBuilder = this.dictionaryIdsBuilder.newBuilderLike();
        } else if (this.state == State.RLE) {
            this.delegate.appendRle(this.rleValue, this.rlePositionCount);
            this.rleValue = null;
            this.rlePositionCount = 0;
        }
        this.state = State.DIRECT;
    }

    public Block build() {
        Block result = switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.DICTIONARY -> DictionaryBlock.create((int)this.dictionaryIdsBuilder.size(), (Block)this.dictionary, (int[])this.dictionaryIdsBuilder.getDictionaryIds());
            case State.RLE -> RunLengthEncodedBlock.create((Block)this.rleValue, (int)this.rlePositionCount);
            case State.UNINITIALIZED, State.DIRECT -> this.delegate.build();
        };
        this.state = State.UNINITIALIZED;
        this.dictionary = null;
        this.dictionaryIdsBuilder = this.dictionaryIdsBuilder.newBuilderLike();
        this.rleValue = null;
        this.rlePositionCount = 0;
        return result;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.delegate.getRetainedSizeInBytes() + this.dictionaryIdsBuilder.getRetainedSizeInBytes() + (this.rleValue != null ? this.rleValue.getRetainedSizeInBytes() : 0L);
    }

    public long getSizeInBytes() {
        return this.delegate.getSizeInBytes() + (this.rleValue != null ? this.rleValue.getSizeInBytes() : 0L);
    }

    private static enum State {
        UNINITIALIZED,
        DICTIONARY,
        RLE,
        DIRECT;

    }

    private static class DictionaryIdsBuilder {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryIdsBuilder.class);
        private final int initialEntryCount;
        private int[] dictionaryIds;
        private int size;

        public DictionaryIdsBuilder(int initialEntryCount) {
            this.initialEntryCount = initialEntryCount;
            this.dictionaryIds = new int[0];
        }

        public int[] getDictionaryIds() {
            return this.dictionaryIds;
        }

        public int size() {
            return this.size;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.dictionaryIds);
        }

        public void appendPositions(IntArrayList positions, DictionaryBlock block) {
            Preconditions.checkArgument((!positions.isEmpty() ? 1 : 0) != 0, (Object)"positions is empty");
            this.ensureCapacity(this.size + positions.size());
            for (int i = 0; i < positions.size(); ++i) {
                this.dictionaryIds[this.size + i] = block.getId(positions.getInt(i));
            }
            this.size += positions.size();
        }

        public DictionaryIdsBuilder newBuilderLike() {
            if (this.size == 0) {
                return this;
            }
            return new DictionaryIdsBuilder(Math.max(PositionsAppenderUtil.calculateBlockResetSize(this.size), this.initialEntryCount));
        }

        private void ensureCapacity(int capacity) {
            if (this.dictionaryIds.length >= capacity) {
                return;
            }
            int newSize = this.dictionaryIds.length > 0 ? PositionsAppenderUtil.calculateNewArraySize(this.dictionaryIds.length) : this.initialEntryCount;
            newSize = Math.max(newSize, capacity);
            this.dictionaryIds = IntArrays.ensureCapacity((int[])this.dictionaryIds, (int)newSize, (int)this.size);
        }
    }
}

