/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.SizeOf;
import io.trino.operator.unnest.UnnestBlockBuilder;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarRow;
import java.util.Objects;

public class ArrayOfRowsUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayOfRowsUnnester.class);
    private final int fieldCount;
    private final UnnestBlockBuilder[] blockBuilders;
    private int[] arrayLengths = new int[0];
    private ColumnarArray columnarArray;
    private ColumnarRow columnarRow;

    public ArrayOfRowsUnnester(int fieldCount) {
        this.blockBuilders = ArrayOfRowsUnnester.createUnnestBlockBuilders(fieldCount);
        this.fieldCount = fieldCount;
    }

    private static UnnestBlockBuilder[] createUnnestBlockBuilders(int fieldCount) {
        UnnestBlockBuilder[] builders = new UnnestBlockBuilder[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            builders[i] = new UnnestBlockBuilder();
        }
        return builders;
    }

    @Override
    public int getChannelCount() {
        return this.fieldCount;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        this.columnarRow = ColumnarRow.toColumnarRow((Block)this.columnarArray.getElementsBlock());
        for (int i = 0; i < this.fieldCount; ++i) {
            this.blockBuilders[i].resetInputBlock(this.columnarRow.getField(i), this.columnarRow.getNullCheckBlock());
        }
        int positionCount = block.getPositionCount();
        this.arrayLengths = UnnestOperator.ensureCapacity(this.arrayLengths, positionCount, false);
        for (int j = 0; j < positionCount; ++j) {
            this.arrayLengths[j] = this.columnarArray.getLength(j);
        }
    }

    @Override
    public int[] getOutputEntriesPerPosition() {
        return this.arrayLengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] outputEntriesPerPosition, int startPosition, int batchSize, int outputRowCount) {
        boolean nullRequired = this.needToInsertNulls(startPosition, batchSize, outputRowCount);
        Block[] outputBlocks = new Block[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            outputBlocks[i] = nullRequired ? this.blockBuilders[i].buildWithNulls(outputEntriesPerPosition, startPosition, batchSize, outputRowCount, this.arrayLengths) : this.blockBuilders[i].buildWithoutNulls(outputRowCount);
        }
        return outputBlocks;
    }

    private boolean needToInsertNulls(int offset, int inputBatchSize, int outputRowCount) {
        int start = this.columnarArray.getOffset(offset);
        int end = this.columnarArray.getOffset(offset + inputBatchSize);
        int totalLength = end - start;
        if (totalLength < outputRowCount) {
            return true;
        }
        if (this.columnarRow.mayHaveNull()) {
            for (int i = start; i < end; ++i) {
                if (!this.columnarRow.isNull(i)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.arrayLengths);
    }
}

