/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import io.trino.operator.window.matcher.Done;
import io.trino.operator.window.matcher.Instruction;
import io.trino.operator.window.matcher.Jump;
import io.trino.operator.window.matcher.MatchEnd;
import io.trino.operator.window.matcher.MatchLabel;
import io.trino.operator.window.matcher.MatchStart;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.matcher.Save;
import io.trino.operator.window.matcher.Split;
import io.trino.sql.planner.rowpattern.ir.IrAlternation;
import io.trino.sql.planner.rowpattern.ir.IrAnchor;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrEmpty;
import io.trino.sql.planner.rowpattern.ir.IrExclusion;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrPermutation;
import io.trino.sql.planner.rowpattern.ir.IrQuantified;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.planner.rowpattern.ir.IrRowPatternVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public class IrRowPatternToProgramRewriter {
    private IrRowPatternToProgramRewriter() {
    }

    public static Program rewrite(IrRowPattern node, Map<IrLabel, Integer> labelMapping) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        new Rewriter(instructions, labelMapping).process(node);
        instructions.add(new Done());
        return new Program(instructions);
    }

    private static class Rewriter
    extends IrRowPatternVisitor<Void, Void> {
        private final List<Instruction> instructions;
        private final Map<IrLabel, Integer> labelMapping;

        public Rewriter(List<Instruction> instructions, Map<IrLabel, Integer> labelMapping) {
            this.instructions = Objects.requireNonNull(instructions, "instructions is null");
            this.labelMapping = Objects.requireNonNull(labelMapping, "labelMapping is null");
        }

        @Override
        protected Void visitIrRowPattern(IrRowPattern node, Void context) {
            throw new UnsupportedOperationException("unsupported node type: " + node.getClass().getName());
        }

        @Override
        protected Void visitIrLabel(IrLabel node, Void context) {
            this.instructions.add(new MatchLabel(this.labelMapping.get(node)));
            return null;
        }

        @Override
        protected Void visitIrEmpty(IrEmpty node, Void context) {
            return null;
        }

        @Override
        protected Void visitIrAnchor(IrAnchor node, Void context) {
            switch (node.getType()) {
                case PARTITION_START: {
                    this.instructions.add(new MatchStart());
                    return null;
                }
                case PARTITION_END: {
                    this.instructions.add(new MatchEnd());
                    return null;
                }
            }
            throw new IllegalStateException("unexpected anchor type: " + node.getType());
        }

        @Override
        protected Void visitIrExclusion(IrExclusion node, Void context) {
            this.instructions.add(new Save());
            this.process(node.getPattern());
            this.instructions.add(new Save());
            return null;
        }

        @Override
        protected Void visitIrAlternation(IrAlternation node, Void context) {
            List<IrRowPattern> parts = node.getPatterns();
            ArrayList<Integer> jumpPositions = new ArrayList<Integer>();
            for (int i = 0; i < parts.size() - 1; ++i) {
                int splitPosition = this.instructions.size();
                this.instructions.add(null);
                int splitTarget = this.instructions.size();
                this.process(parts.get(i));
                jumpPositions.add(this.instructions.size());
                this.instructions.add(null);
                this.instructions.set(splitPosition, new Split(splitTarget, this.instructions.size()));
            }
            this.process(parts.get(parts.size() - 1));
            Iterator iterator = jumpPositions.iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                this.instructions.set(position, new Jump(this.instructions.size()));
            }
            return null;
        }

        @Override
        protected Void visitIrConcatenation(IrConcatenation node, Void context) {
            this.concatenation(node.getPatterns());
            return null;
        }

        @Override
        protected Void visitIrPermutation(IrPermutation node, Void context) {
            Preconditions.checkArgument((node.getPatterns().size() > 1 ? 1 : 0) != 0, (Object)"invalid pattern: permutation with single element. run IrRowPatternFlattener first");
            List indexes = (List)IntStream.range(0, node.getPatterns().size()).boxed().collect(ImmutableList.toImmutableList());
            List permutations = (List)Collections2.orderedPermutations((Iterable)indexes).stream().map(permutation -> (ImmutableList)permutation.stream().map(node.getPatterns()::get).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            this.alternation(permutations);
            return null;
        }

        private void concatenation(List<IrRowPattern> patterns) {
            patterns.forEach(this::process);
        }

        private void alternation(List<List<IrRowPattern>> parts) {
            ArrayList<Integer> jumpPositions = new ArrayList<Integer>();
            for (int i = 0; i < parts.size() - 1; ++i) {
                int splitPosition = this.instructions.size();
                this.instructions.add(null);
                int splitTarget = this.instructions.size();
                this.concatenation(parts.get(i));
                jumpPositions.add(this.instructions.size());
                this.instructions.add(null);
                this.instructions.set(splitPosition, new Split(splitTarget, this.instructions.size()));
            }
            this.concatenation(parts.get(parts.size() - 1));
            Iterator iterator = jumpPositions.iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                this.instructions.set(position, new Jump(this.instructions.size()));
            }
        }

        @Override
        protected Void visitIrQuantified(IrQuantified node, Void context) {
            IrRowPattern pattern = node.getPattern();
            IrQuantifier quantifier = node.getQuantifier();
            boolean greedy = quantifier.isGreedy();
            if (quantifier.getAtMost().isPresent()) {
                this.rangeQuantified(pattern, greedy, quantifier.getAtLeast(), quantifier.getAtMost().get());
            } else {
                this.loopingQuantified(pattern, greedy, quantifier.getAtLeast());
            }
            return null;
        }

        private void loopingQuantified(IrRowPattern pattern, boolean greedy, int min) {
            Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (Object)("invalid min value: " + min));
            if (min == 0) {
                int startSplitPosition = this.instructions.size();
                this.instructions.add(null);
                int splitTarget = this.instructions.size();
                int loopingPosition = this.instructions.size();
                this.process(pattern);
                this.loop(loopingPosition, greedy);
                if (greedy) {
                    this.instructions.set(startSplitPosition, new Split(splitTarget, this.instructions.size()));
                } else {
                    this.instructions.set(startSplitPosition, new Split(this.instructions.size(), splitTarget));
                }
                return;
            }
            int loopingPosition = this.instructions.size();
            for (int i = 0; i < min; ++i) {
                loopingPosition = this.instructions.size();
                this.process(pattern);
            }
            this.loop(loopingPosition, greedy);
        }

        private void loop(int loopingPosition, boolean greedy) {
            Split loopingSplit = greedy ? new Split(loopingPosition, this.instructions.size() + 1) : new Split(this.instructions.size() + 1, loopingPosition);
            this.instructions.add(loopingSplit);
        }

        private void rangeQuantified(IrRowPattern pattern, boolean greedy, int min, int max) {
            int i;
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)String.format("invalid range: (%s, %s)", min, max));
            for (int i2 = 0; i2 < min; ++i2) {
                this.process(pattern);
            }
            if (min == max) {
                return;
            }
            ArrayList<Integer> splitPositions = new ArrayList<Integer>();
            ArrayList<Integer> splitTargets = new ArrayList<Integer>();
            for (i = min; i < max; ++i) {
                splitPositions.add(this.instructions.size());
                this.instructions.add(null);
                splitTargets.add(this.instructions.size());
                this.process(pattern);
            }
            for (i = 0; i < splitPositions.size(); ++i) {
                if (greedy) {
                    this.instructions.set((Integer)splitPositions.get(i), new Split((Integer)splitTargets.get(i), this.instructions.size()));
                    continue;
                }
                this.instructions.set((Integer)splitPositions.get(i), new Split(this.instructions.size(), (Integer)splitTargets.get(i)));
            }
        }
    }
}

