/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.base.Verify;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.ForwardingAccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ViewAccessControl
extends ForwardingAccessControl {
    private final AccessControl delegate;

    public ViewAccessControl(AccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    protected AccessControl delegate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public Set<String> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return this.delegate.filterColumns(context, tableName, columns);
    }

    @Override
    public Map<SchemaTableName, Set<String>> filterColumns(SecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        return this.delegate.filterColumns(context, catalogName, tableColumns);
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public boolean canExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        return this.delegate.canCreateViewWithExecuteFunction(context, functionName);
    }

    @Override
    public boolean canCreateViewWithExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        return this.delegate.canCreateViewWithExecuteFunction(context, functionName);
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return this.delegate.getRowFilters(context, tableName);
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return this.delegate.getColumnMask(context, tableName, columnName, type);
    }

    private static void wrapAccessDeniedException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AccessDeniedException e) {
            String prefix = "Access Denied: ";
            Verify.verify((boolean)e.getMessage().startsWith(prefix));
            String msg = e.getMessage().substring(prefix.length());
            throw new AccessDeniedException("View owner does not have sufficient privileges: " + msg, e);
        }
    }
}

