/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.QueryManagerConfig;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.split.BufferingSplitSource;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import io.trino.split.TracingSplitSource;
import io.trino.tracing.TrinoAttributes;
import java.util.Objects;
import java.util.Optional;

public class SplitManager {
    private final CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider;
    private final Tracer tracer;
    private final int minScheduleSplitBatchSize;

    @Inject
    public SplitManager(CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider, Tracer tracer, QueryManagerConfig config) {
        this.splitManagerProvider = Objects.requireNonNull(splitManagerProvider, "splitManagerProvider is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
    }

    public SplitSource getSplits(Session session, Span parentSpan, TableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorSplitManager splitManager = this.splitManagerProvider.getService(catalogHandle);
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            dynamicFilter = DynamicFilter.EMPTY;
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        ConnectorSplitSource source = splitManager.getSplits(table.getTransaction(), connectorSession, table.getConnectorHandle(), dynamicFilter, constraint);
        SplitSource splitSource = new ConnectorAwareSplitSource(catalogHandle, source);
        Span span = this.splitSourceSpan(parentSpan, catalogHandle);
        if (this.minScheduleSplitBatchSize > 1) {
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.empty(), "split-batch");
            splitSource = new BufferingSplitSource(splitSource, this.minScheduleSplitBatchSize);
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-buffer");
        } else {
            splitSource = new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-batch");
        }
        return splitSource;
    }

    public SplitSource getSplits(Session session, Span parentSpan, TableFunctionHandle function) {
        CatalogHandle catalogHandle = function.getCatalogHandle();
        ConnectorSplitManager splitManager = this.splitManagerProvider.getService(catalogHandle);
        ConnectorSplitSource source = splitManager.getSplits(function.getTransactionHandle(), session.toConnectorSession(catalogHandle), function.getFunctionHandle());
        ConnectorAwareSplitSource splitSource = new ConnectorAwareSplitSource(catalogHandle, source);
        Span span = this.splitSourceSpan(parentSpan, catalogHandle);
        return new TracingSplitSource(splitSource, this.tracer, Optional.of(span), "split-buffer");
    }

    private Span splitSourceSpan(Span querySpan, CatalogHandle catalogHandle) {
        return this.tracer.spanBuilder("split-source").setParent(Context.current().with((ImplicitContextKeyed)querySpan)).setAttribute(TrinoAttributes.CATALOG, (Object)catalogHandle.getCatalogName()).startSpan();
    }
}

