/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BuiltinFunctionCallBuilder {
    private final Metadata metadata;
    private String name;
    private List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
    private List<Expression> argumentValues = new ArrayList<Expression>();
    private Optional<NodeLocation> location = Optional.empty();
    private Optional<Window> window = Optional.empty();
    private Optional<Expression> filter = Optional.empty();
    private Optional<OrderBy> orderBy = Optional.empty();
    private boolean distinct;

    public static BuiltinFunctionCallBuilder resolve(Metadata metadata) {
        return new BuiltinFunctionCallBuilder(metadata);
    }

    private BuiltinFunctionCallBuilder(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public BuiltinFunctionCallBuilder setName(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
        return this;
    }

    public BuiltinFunctionCallBuilder addArgument(Type type, Expression value) {
        Objects.requireNonNull(type, "type is null");
        return this.addArgument(type.getTypeSignature(), value);
    }

    public BuiltinFunctionCallBuilder addArgument(TypeSignature typeSignature, Expression value) {
        Objects.requireNonNull(typeSignature, "typeSignature is null");
        Objects.requireNonNull(value, "value is null");
        this.argumentTypes.add(typeSignature);
        this.argumentValues.add(value);
        return this;
    }

    public BuiltinFunctionCallBuilder setArguments(List<Type> types, List<Expression> values) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(values, "values is null");
        this.argumentTypes = types.stream().map(Type::getTypeSignature).collect(Collectors.toList());
        this.argumentValues = new ArrayList<Expression>(values);
        return this;
    }

    public BuiltinFunctionCallBuilder setLocation(NodeLocation location) {
        this.location = Optional.of(Objects.requireNonNull(location, "location is null"));
        return this;
    }

    public BuiltinFunctionCallBuilder setWindow(Window window) {
        this.window = Optional.of(Objects.requireNonNull(window, "window is null"));
        return this;
    }

    public BuiltinFunctionCallBuilder setWindow(Optional<Window> window) {
        this.window = Objects.requireNonNull(window, "window is null");
        return this;
    }

    public BuiltinFunctionCallBuilder setFilter(Expression filter) {
        this.filter = Optional.of(Objects.requireNonNull(filter, "filter is null"));
        return this;
    }

    public BuiltinFunctionCallBuilder setFilter(Optional<Expression> filter) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
        return this;
    }

    public BuiltinFunctionCallBuilder setOrderBy(OrderBy orderBy) {
        this.orderBy = Optional.of(Objects.requireNonNull(orderBy, "orderBy is null"));
        return this;
    }

    public BuiltinFunctionCallBuilder setOrderBy(Optional<OrderBy> orderBy) {
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        return this;
    }

    public BuiltinFunctionCallBuilder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public FunctionCall build() {
        ResolvedFunction resolvedFunction = this.metadata.resolveBuiltinFunction(this.name, TypeSignatureProvider.fromTypeSignatures(this.argumentTypes));
        return new FunctionCall(this.location, resolvedFunction.toQualifiedName(), this.window, this.filter, this.orderBy, this.distinct, Optional.empty(), Optional.empty(), this.argumentValues);
    }
}

