/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.ArraySubscriptOperator;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ConstantExpressionVerifier;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.gen.VarArgsToMapAdapterGenerator;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.Coercer;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.LiteralInterpreter;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.ResolvedFunctionCallRewriter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import io.trino.type.FunctionType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePattern;
import io.trino.type.TypeCoercion;
import io.trino.util.Failures;
import io.trino.util.FastutilSetHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExpressionInterpreter {
    private static final CatalogSchemaFunctionName FAIL_NAME = GlobalFunctionCatalog.builtinFunctionName("fail");
    private final Expression expression;
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final LiteralInterpreter literalInterpreter;
    private final LiteralEncoder literalEncoder;
    private final Session session;
    private final ConnectorSession connectorSession;
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final IdentityHashMap<LikePredicate, LikePattern> likePatternCache = new IdentityHashMap();
    private final IdentityHashMap<InListExpression, Set<?>> inListCache = new IdentityHashMap();

    public ExpressionInterpreter(Expression expression, PlannerContext plannerContext, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        this.literalEncoder = new LiteralEncoder(plannerContext);
        this.session = Objects.requireNonNull(session, "session is null");
        this.connectorSession = session.toConnectorSession();
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        Verify.verify((boolean)expressionTypes.containsKey(NodeRef.of((Node)expression)));
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
    }

    public static Object evaluateConstantExpression(Expression expression, Type expectedType, PlannerContext plannerContext, Session session, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Analysis analysis = new Analysis(null, (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of(), QueryType.OTHERS);
        Scope scope = Scope.create();
        ExpressionAnalyzer.analyzeExpressionWithoutSubqueries(session, plannerContext, accessControl, scope, analysis, expression, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", WarningCollector.NOOP, CorrelationSupport.DISALLOWED);
        TranslationMap translationMap = new TranslationMap(Optional.empty(), scope, analysis, (Map<NodeRef<LambdaArgumentDeclaration>, Symbol>)ImmutableMap.of(), (List<Symbol>)ImmutableList.of(), session, plannerContext);
        expression = QueryPlanner.coerceIfNecessary(analysis, expression, translationMap.rewrite(expression));
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(plannerContext, accessControl, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(expression, scope);
        Type actualType = analyzer.getExpressionTypes().get(NodeRef.of((Node)expression));
        if (!new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0)).canCoerce(actualType, expectedType)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "Cannot cast type %s to %s", actualType.getDisplayName(), expectedType.getDisplayName());
        }
        ImmutableMap coercions = ImmutableMap.builder().putAll(analyzer.getExpressionCoercions()).put((Object)NodeRef.of((Node)expression), (Object)expectedType).buildOrThrow();
        return ExpressionInterpreter.evaluateConstantExpression(expression, (Map<NodeRef<Expression>, Type>)coercions, analyzer.getTypeOnlyCoercions(), plannerContext, session, accessControl, (Set<NodeRef<Expression>>)ImmutableSet.of(), parameters);
    }

    public static Object evaluateConstantExpression(Expression expression, Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions, PlannerContext plannerContext, Session session, AccessControl accessControl, Set<NodeRef<Expression>> columnReferences, Map<NodeRef<Parameter>, Expression> parameters) {
        Objects.requireNonNull(columnReferences, "columnReferences is null");
        ConstantExpressionVerifier.verifyExpressionIsConstant(columnReferences, expression);
        Expression rewrite = Coercer.addCoercions(expression, coercions, typeOnlyCoercions);
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.createConstantAnalyzer(plannerContext, accessControl, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(rewrite, Scope.create());
        analyzer = ExpressionAnalyzer.createConstantAnalyzer(plannerContext, accessControl, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(rewrite, Scope.create());
        Expression canonicalized = CanonicalizeExpressionRewriter.canonicalizeExpression(rewrite, analyzer.getExpressionTypes(), plannerContext, session);
        analyzer = ExpressionAnalyzer.createConstantAnalyzer(plannerContext, accessControl, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(canonicalized, Scope.create());
        Expression resolved = ResolvedFunctionCallRewriter.rewriteResolvedFunctions(canonicalized, analyzer.getResolvedFunctions());
        analyzer = ExpressionAnalyzer.createConstantAnalyzer(plannerContext, accessControl, session, parameters, WarningCollector.NOOP);
        analyzer.analyze(resolved, Scope.create());
        return new ExpressionInterpreter(resolved, plannerContext, session, analyzer.getExpressionTypes()).evaluate();
    }

    public Type getType() {
        return this.expressionTypes.get(NodeRef.of((Node)this.expression));
    }

    public Object evaluate() {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, new NoPagePositionContext());
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object evaluate(SymbolResolver inputs) {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, inputs);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object optimize(SymbolResolver inputs) {
        return new Visitor(true).processWithExceptionHandling(this.expression, inputs);
    }

    private static boolean isArray(Type type) {
        return type instanceof ArrayType;
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private final boolean optimize;

        private Visitor(boolean optimize) {
            this.optimize = optimize;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process((Node)expression, context);
            }
            catch (TrinoException e) {
                if (this.optimize) {
                    return expression;
                }
                throw e;
            }
        }

        public Object visitFieldReference(FieldReference node, Object context) {
            throw new UnsupportedOperationException("Field references not supported in interpreter");
        }

        protected Object visitDereferenceExpression(DereferenceExpression node, Object context) {
            Preconditions.checkArgument((!DereferenceExpression.isQualifiedAllFieldsReference((Expression)node) ? 1 : 0) != 0, (Object)("unexpected expression: all fields labeled reference " + node));
            Identifier fieldIdentifier = (Identifier)node.getField().orElseThrow();
            Type type = this.type(node.getBase());
            if (type == null) {
                return node;
            }
            Object base = this.processWithExceptionHandling(node.getBase(), context);
            if (base == null) {
                return null;
            }
            if (this.hasUnresolvedValue(base)) {
                return new DereferenceExpression(this.toExpression(base, type), fieldIdentifier);
            }
            RowType rowType = (RowType)type;
            SqlRow row = (SqlRow)base;
            Type returnType = this.type((Expression)node);
            String fieldName = fieldIdentifier.getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)fieldName);
            return TypeUtils.readNativeValue((Type)returnType, (Block)row.getRawFieldBlock(index), (int)row.getRawIndex());
        }

        protected Object visitIdentifier(Identifier node, Object context) {
            return ((SymbolResolver)context).getValue(new Symbol(node.getValue()));
        }

        protected Object visitParameter(Parameter node, Object context) {
            return node;
        }

        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((SymbolResolver)context).getValue(Symbol.from((Expression)node));
        }

        protected Object visitLiteral(Literal node, Object context) {
            return ExpressionInterpreter.this.literalInterpreter.evaluate((Expression)node, this.type((Expression)node));
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SearchedCaseExpression(whenClauses, Optional.ofNullable(defaultExpression));
        }

        protected Object visitIfExpression(IfExpression node, Object context) {
            Object condition = this.processWithExceptionHandling(node.getCondition(), context);
            if (condition instanceof Expression) {
                Object trueValue = this.processWithExceptionHandling(node.getTrueValue(), context);
                Object falseValue = this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
                return new IfExpression(this.toExpression(condition, this.type(node.getCondition())), this.toExpression(trueValue, this.type(node.getTrueValue())), falseValue == null ? null : this.toExpression(falseValue, this.type((Expression)node.getFalseValue().get())));
            }
            if (Boolean.TRUE.equals(condition)) {
                return this.processWithExceptionHandling(node.getTrueValue(), context);
            }
            return this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = this.type(node.getOperand());
            if (operand == null) {
                return this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            }
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, this.type(whenClause.getOperand()))) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SimpleCaseExpression(this.toExpression(operand, this.type(node.getOperand())), whenClauses, Optional.ofNullable(defaultExpression));
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2)));
        }

        private Type type(Expression expression) {
            return ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)expression));
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            List<Object> newOperands = this.processOperands(node, context);
            if (newOperands.isEmpty()) {
                return null;
            }
            if (newOperands.size() == 1) {
                return Iterables.getOnlyElement(newOperands);
            }
            return new CoalesceExpression((List)newOperands.stream().map(value -> this.toExpression(value, this.type((Expression)node))).collect(ImmutableList.toImmutableList()));
        }

        private List<Object> processOperands(CoalesceExpression node, Object context) {
            ArrayList<Object> newOperands = new ArrayList<Object>();
            HashSet<Expression> uniqueNewOperands = new HashSet<Expression>();
            for (Expression operand : node.getOperands()) {
                Object value = this.processWithExceptionHandling(operand, context);
                if (value instanceof CoalesceExpression) {
                    for (Expression nestedOperand : ((CoalesceExpression)value).getOperands()) {
                        if (!DeterminismEvaluator.isDeterministic(nestedOperand, ExpressionInterpreter.this.metadata) || uniqueNewOperands.add(nestedOperand)) {
                            newOperands.add(nestedOperand);
                        }
                        if (!ExpressionUtils.isEffectivelyLiteral(ExpressionInterpreter.this.plannerContext, ExpressionInterpreter.this.session, nestedOperand)) continue;
                        Verify.verify((!(nestedOperand instanceof NullLiteral) && (!(nestedOperand instanceof Cast) || !(((Cast)nestedOperand).getExpression() instanceof NullLiteral)) ? 1 : 0) != 0, (String)"Null operand should have been removed by recursive coalesce processing", (Object[])new Object[0]);
                        return newOperands;
                    }
                    continue;
                }
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    Verify.verify((!(value instanceof NullLiteral) ? 1 : 0) != 0, (String)"Null value is expected to be represented as null, not NullLiteral", (Object[])new Object[0]);
                    if (DeterminismEvaluator.isDeterministic(expression, ExpressionInterpreter.this.metadata) && !uniqueNewOperands.add(expression)) continue;
                    newOperands.add(expression);
                    continue;
                }
                if (value == null) continue;
                newOperands.add(value);
                return newOperands;
            }
            return newOperands;
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            Expression valueListExpression = node.getValueList();
            if (!(valueListExpression instanceof InListExpression)) {
                if (!this.optimize) {
                    throw new UnsupportedOperationException("IN predicate value list type not yet implemented: " + valueListExpression.getClass().getName());
                }
                return node;
            }
            InListExpression valueList = (InListExpression)valueListExpression;
            if (value == null) {
                return null;
            }
            if (!(value instanceof Expression)) {
                Set<?> set = ExpressionInterpreter.this.inListCache.get(valueList);
                if (!ExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                    if (valueList.getValues().stream().allMatch(Literal.class::isInstance)) {
                        if (valueList.getValues().stream().noneMatch(NullLiteral.class::isInstance)) {
                            Set objectSet = valueList.getValues().stream().map(expression -> this.processWithExceptionHandling((Expression)expression, context)).collect(Collectors.toSet());
                            Type type = this.type(node.getValue());
                            set = FastutilSetHelper.toFastutilHashSet(objectSet, type, ExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(ExpressionInterpreter.this.metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle(), ExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(ExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle());
                        }
                    }
                    ExpressionInterpreter.this.inListCache.put(valueList, set);
                }
                if (set != null) {
                    return set.contains(value);
                }
            }
            boolean hasUnresolvedValue = value instanceof Expression;
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Type> types = new ArrayList<Type>(valueList.getValues().size());
            ResolvedFunction equalsOperator = ExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, this.types(new Expression[]{node.getValue(), valueList}));
            for (Expression expression2 : valueList.getValues()) {
                if (value instanceof Expression && expression2 instanceof Literal) {
                    values.add(expression2);
                    types.add(this.type(expression2));
                    continue;
                }
                Object inValue = this.process((Node)expression2, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(this.type(expression2));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                Boolean result = (Boolean)ExpressionInterpreter.this.functionInvoker.invoke(equalsOperator, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value, (Object)inValue));
                if (result == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !result.booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = this.type(node.getValue());
                List<Expression> expressionValues = this.toExpressions(values, types);
                List simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter(expression -> DeterminismEvaluator.isDeterministic(expression, ExpressionInterpreter.this.metadata)).distinct(), expressionValues.stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, ExpressionInterpreter.this.metadata))).collect(ImmutableList.toImmutableList());
                if (simplifiedExpressionValues.size() == 1) {
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, this.toExpression(value, type), (Expression)simplifiedExpressionValues.get(0));
                }
                return new InPredicate(this.toExpression(value, type), (Expression)new InListExpression(simplifiedExpressionValues));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitExists(ExistsPredicate node, Object context) {
            if (!this.optimize) {
                throw new UnsupportedOperationException("Exists subquery not yet implemented");
            }
            return node;
        }

        protected Object visitSubqueryExpression(SubqueryExpression node, Object context) {
            if (!this.optimize) {
                throw new UnsupportedOperationException("Subquery not yet implemented");
            }
            return node;
        }

        protected Object visitArithmeticUnary(ArithmeticUnaryExpression node, Object context) {
            Object object;
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                Expression valueExpression = this.toExpression(value, this.type(node.getValue()));
                return switch (node.getSign()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ArithmeticUnaryExpression.Sign.PLUS -> valueExpression;
                    case ArithmeticUnaryExpression.Sign.MINUS -> valueExpression instanceof ArithmeticUnaryExpression && ((ArithmeticUnaryExpression)valueExpression).getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS) ? ((ArithmeticUnaryExpression)valueExpression).getValue() : new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, valueExpression);
                };
            }
            switch (node.getSign()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case PLUS: {
                    Object object2;
                    object = object2 = value;
                    break;
                }
                case MINUS: {
                    ResolvedFunction resolvedOperator = ExpressionInterpreter.this.metadata.resolveOperator(OperatorType.NEGATION, this.types(node.getValue()));
                    InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
                    MethodHandle handle = ExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(resolvedOperator, invocationConvention).getMethodHandle();
                    if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
                        handle = handle.bindTo(ExpressionInterpreter.this.connectorSession);
                    }
                    try {
                        Object object3;
                        object = object3 = handle.invokeWithArguments(value);
                        break;
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                        Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                        throw new RuntimeException(throwable.getMessage(), throwable);
                    }
                }
            }
            return object;
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.processWithExceptionHandling(node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)node.getOperator().name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Operator operator = node.getOperator();
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                return this.processIsDistinctFrom(context, left, right);
            }
            if (node.getOperator() == ComparisonExpression.Operator.NOT_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result == null) {
                    return null;
                }
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return (Boolean)result == false;
            }
            if (node.getOperator() == ComparisonExpression.Operator.GREATER_THAN || node.getOperator() == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return result;
            }
            return this.processComparisonExpression(context, operator, left, right);
        }

        private Object processIsDistinctFrom(Object context, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (left == null && right instanceof Expression) {
                return new IsNotNullPredicate((Expression)right);
            }
            if (right == null && left instanceof Expression) {
                return new IsNotNullPredicate((Expression)left);
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return this.invokeOperator(OperatorType.valueOf((String)ComparisonExpression.Operator.IS_DISTINCT_FROM.name()), this.types(leftExpression, rightExpression), Arrays.asList(left, right));
        }

        private Object processComparisonExpression(Object context, ComparisonExpression.Operator operator, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (right == null) {
                return null;
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(operator, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return this.invokeOperator(OperatorType.valueOf((String)operator.name()), this.types(leftExpression, rightExpression), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        private ComparisonExpression flipComparison(ComparisonExpression comparisonExpression) {
            return switch (comparisonExpression.getOperator()) {
                case ComparisonExpression.Operator.EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.NOT_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.LESS_THAN -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                default -> throw new IllegalStateException("Unexpected value: " + comparisonExpression.getOperator());
            };
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.processWithExceptionHandling(node.getMin(), context);
            Object max = this.processWithExceptionHandling(node.getMax(), context);
            if (value instanceof Expression || min instanceof Expression || max instanceof Expression) {
                return new BetweenPredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(min, this.type(node.getMin())), this.toExpression(max, this.type(node.getMax())));
            }
            Boolean greaterOrEqualToMin = null;
            if (min != null) {
                greaterOrEqualToMin = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getMin(), node.getValue()), (List<Object>)ImmutableList.of((Object)min, (Object)value));
            }
            Boolean lessThanOrEqualToMax = null;
            if (max != null) {
                lessThanOrEqualToMax = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getValue(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)max));
            }
            if (greaterOrEqualToMin == null) {
                return Objects.equals(lessThanOrEqualToMax, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            if (lessThanOrEqualToMax == null) {
                return Objects.equals(greaterOrEqualToMin, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            return greaterOrEqualToMin != false && lessThanOrEqualToMax != false;
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.processWithExceptionHandling(node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.processWithExceptionHandling(node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = this.type(node.getFirst());
            Type secondType = this.type(node.getSecond());
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(this.toExpression(first, firstType), this.toExpression(second, secondType));
            }
            Type commonType = ExpressionInterpreter.this.typeCoercion.getCommonSuperType(firstType, secondType).get();
            ResolvedFunction firstCast = ExpressionInterpreter.this.metadata.getCoercion(firstType, commonType);
            ResolvedFunction secondCast = ExpressionInterpreter.this.metadata.getCoercion(secondType, commonType);
            boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.this.functionInvoker.invoke(firstCast, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)first)), (Object)ExpressionInterpreter.this.functionInvoker.invoke(secondCast, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)second)))));
            if (equal) {
                return null;
            }
            return first;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(this.toExpression(value, this.type(node.getValue())));
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalExpression(LogicalExpression node, Object context) {
            ArrayList<Object> terms = new ArrayList<Object>();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Expression term : node.getTerms()) {
                Object processed = this.processWithExceptionHandling(term, context);
                switch (node.getOperator()) {
                    case AND: {
                        if (Boolean.FALSE.equals(processed)) {
                            return false;
                        }
                        if (Boolean.TRUE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                        break;
                    }
                    case OR: {
                        if (Boolean.TRUE.equals(processed)) {
                            return true;
                        }
                        if (Boolean.FALSE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                    }
                }
            }
            if (terms.isEmpty()) {
                return switch (node.getOperator()) {
                    default -> throw new IncompatibleClassChangeError();
                    case LogicalExpression.Operator.AND -> true;
                    case LogicalExpression.Operator.OR -> false;
                };
            }
            if (terms.size() == 1) {
                return terms.get(0);
            }
            if (terms.stream().allMatch(Objects::isNull)) {
                return null;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (int i = 0; i < terms.size(); ++i) {
                expressions.add((Object)this.toExpression(terms.get(i), (Type)types.get(i)));
            }
            return new LogicalExpression(node.getOperator(), (List)expressions.build());
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Object value = this.processWithExceptionHandling(expression, context);
                Type type = this.type(expression);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            ResolvedFunction resolvedFunction = ExpressionInterpreter.this.metadata.decodeFunction(node.getName());
            FunctionNullability functionNullability = resolvedFunction.getFunctionNullability();
            for (int i = 0; i < argumentValues.size(); ++i) {
                Object value = argumentValues.get(i);
                if (value != null || functionNullability.isArgumentNullable(i)) continue;
                return null;
            }
            if (this.optimize && (!resolvedFunction.isDeterministic() || this.hasUnresolvedValue(argumentValues) || DynamicFilters.isDynamicFilter((Expression)node) || resolvedFunction.getSignature().getName().equals((Object)FAIL_NAME))) {
                Verify.verify((!node.isDistinct() ? 1 : 0) != 0, (String)"distinct not supported", (Object[])new Object[0]);
                Verify.verify((boolean)node.getOrderBy().isEmpty(), (String)"order by not supported", (Object[])new Object[0]);
                Verify.verify((boolean)node.getFilter().isEmpty(), (String)"filter not supported", (Object[])new Object[0]);
                return ResolvedFunctionCallBuilder.builder(resolvedFunction).setWindow(node.getWindow()).setArguments(this.toExpressions(argumentValues, argumentTypes)).build();
            }
            return ExpressionInterpreter.this.functionInvoker.invoke(resolvedFunction, ExpressionInterpreter.this.connectorSession, argumentValues);
        }

        protected Object visitLambdaExpression(LambdaExpression node, Object context) {
            if (this.optimize) {
                Expression optimizedBody;
                Object value = this.processWithExceptionHandling(node.getBody(), context);
                if (value instanceof Expression) {
                    optimizedBody = (Expression)value;
                } else {
                    Type type = this.type(node.getBody());
                    optimizedBody = this.toExpression(value, type);
                }
                return new LambdaExpression(node.getArguments(), optimizedBody);
            }
            Expression body = node.getBody();
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            FunctionType functionType = (FunctionType)ExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)node));
            Preconditions.checkArgument((argumentNames.size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), argumentNames, map -> this.processWithExceptionHandling(body, new LambdaSymbolResolver((Map<String, Object>)map)));
        }

        protected Object visitBindExpression(BindExpression node, Object context) {
            List<Object> values = node.getValues().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).collect(Collectors.toList());
            Object function = this.processWithExceptionHandling(node.getFunction(), context);
            if (this.hasUnresolvedValue(values) || this.hasUnresolvedValue(function)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    builder.add((Object)this.toExpression(values.get(i), this.type((Expression)node.getValues().get(i))));
                }
                return new BindExpression((List)builder.build(), this.toExpression(function, this.type(node.getFunction())));
            }
            return MethodHandles.insertArguments((MethodHandle)function, 0, values.toArray());
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Slice && node.getPattern() instanceof StringLiteral && (node.getEscape().isEmpty() || node.getEscape().get() instanceof StringLiteral)) {
                return this.evaluateLikePredicate(node, (Slice)value, this.getConstantPattern(node));
            }
            Object pattern = this.processWithExceptionHandling(node.getPattern(), context);
            if (pattern == null) {
                return null;
            }
            Object escape = null;
            if (node.getEscape().isPresent() && (escape = this.processWithExceptionHandling((Expression)node.getEscape().get(), context)) == null) {
                return null;
            }
            if (value instanceof Slice && pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                LikePattern likePattern = escape == null ? LikePattern.compile(((Slice)pattern).toStringUtf8(), Optional.empty()) : LikeFunctions.likePattern((Slice)pattern, (Slice)escape);
                return this.evaluateLikePredicate(node, (Slice)value, likePattern);
            }
            if (pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                Type valueType = this.type(node.getValue());
                if (!LikeFunctions.isLikePattern((Slice)pattern, Optional.ofNullable((Slice)escape))) {
                    Expression patternExpression;
                    Expression valueExpression;
                    Slice unescapedPattern = LikeFunctions.unescapeLiteralLikePattern((Slice)pattern, Optional.ofNullable((Slice)escape));
                    VarcharType patternType = VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)unescapedPattern));
                    if (valueType instanceof CharType) {
                        if (((CharType)valueType).getLength() != patternType.getBoundedLength()) {
                            return false;
                        }
                        valueExpression = this.toExpression(value, valueType);
                        patternExpression = this.toExpression(Chars.trimTrailingSpaces((Slice)unescapedPattern), valueType);
                    } else if (valueType instanceof VarcharType) {
                        Type superType = ExpressionInterpreter.this.typeCoercion.getCommonSuperType(valueType, (Type)patternType).orElseThrow(() -> new IllegalArgumentException("Missing super type when optimizing " + node));
                        valueExpression = this.toExpression(value, valueType);
                        if (!valueType.equals(superType)) {
                            valueExpression = new Cast(valueExpression, TypeSignatureTranslator.toSqlType(superType), false, ExpressionInterpreter.this.typeCoercion.isTypeOnlyCoercion(valueType, superType));
                        }
                        patternExpression = this.toExpression(unescapedPattern, superType);
                    } else {
                        throw new IllegalStateException("Unsupported valueType for LIKE: " + valueType);
                    }
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, valueExpression, patternExpression);
                }
                if (LikeFunctions.isMatchAllPattern((Slice)pattern)) {
                    if (!(valueType instanceof CharType) && !(valueType instanceof VarcharType)) {
                        throw new IllegalStateException("Unsupported valueType for LIKE: " + valueType);
                    }
                    return new IsNotNullPredicate(this.toExpression(value, valueType));
                }
            }
            Optional<Object> optimizedEscape = Optional.empty();
            if (node.getEscape().isPresent()) {
                optimizedEscape = Optional.of(this.toExpression(escape, this.type((Expression)node.getEscape().get())));
            }
            return new LikePredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(pattern, this.type(node.getPattern())), optimizedEscape);
        }

        private boolean evaluateLikePredicate(LikePredicate node, Slice value, LikePattern pattern) {
            if (this.type(node.getValue()) instanceof VarcharType) {
                return LikeFunctions.likeVarchar(value, pattern);
            }
            Type type = this.type(node.getValue());
            Preconditions.checkState((boolean)(type instanceof CharType), (Object)"LIKE value is neither VARCHAR or CHAR");
            return LikeFunctions.likeChar(Long.valueOf(((CharType)type).getLength()), value, pattern);
        }

        private LikePattern getConstantPattern(LikePredicate node) {
            LikePattern result = ExpressionInterpreter.this.likePatternCache.get(node);
            if (result == null) {
                StringLiteral pattern = (StringLiteral)node.getPattern();
                if (node.getEscape().isPresent()) {
                    Slice escape = Slices.utf8Slice((String)((StringLiteral)node.getEscape().get()).getValue());
                    result = LikeFunctions.likePattern(Slices.utf8Slice((String)pattern.getValue()), escape);
                } else {
                    result = LikePattern.compile(pattern.getValue(), Optional.empty());
                }
                ExpressionInterpreter.this.likePatternCache.put(node, result);
            }
            return result;
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.processWithExceptionHandling(node.getExpression(), context);
            Type targetType = ExpressionInterpreter.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            Type sourceType = this.type(node.getExpression());
            if (value instanceof Expression) {
                if (targetType.equals(sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe(), node.isTypeOnly());
            }
            if (node.isTypeOnly()) {
                return value;
            }
            if (value == null) {
                return null;
            }
            ResolvedFunction operator = ExpressionInterpreter.this.metadata.getCoercion(sourceType, targetType);
            try {
                return ExpressionInterpreter.this.functionInvoker.invoke(operator, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value));
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        protected Object visitArray(Array node, Object context) {
            Type elementType = ((ArrayType)this.type((Expression)node)).getElementType();
            BlockBuilder arrayBlockBuilder = elementType.createBlockBuilder(null, node.getValues().size());
            for (Expression expression : node.getValues()) {
                Object value = this.processWithExceptionHandling(expression, context);
                if (value instanceof Expression) {
                    Failures.checkCondition(node.getValues().size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for array constructor", new Object[0]);
                    return this.visitFunctionCall(BuiltinFunctionCallBuilder.resolve(ExpressionInterpreter.this.metadata).setName("$array").setArguments(this.types(node.getValues()), node.getValues()).build(), context);
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)arrayBlockBuilder, (Object)value);
            }
            return arrayBlockBuilder.build();
        }

        protected Object visitCurrentCatalog(CurrentCatalog node, Object context) {
            FunctionCall function = BuiltinFunctionCallBuilder.resolve(ExpressionInterpreter.this.metadata).setName("$current_catalog").build();
            return this.visitFunctionCall(function, context);
        }

        protected Object visitCurrentSchema(CurrentSchema node, Object context) {
            FunctionCall function = BuiltinFunctionCallBuilder.resolve(ExpressionInterpreter.this.metadata).setName("$current_schema").build();
            return this.visitFunctionCall(function, context);
        }

        protected Object visitCurrentUser(CurrentUser node, Object context) {
            FunctionCall function = BuiltinFunctionCallBuilder.resolve(ExpressionInterpreter.this.metadata).setName("$current_user").build();
            return this.visitFunctionCall(function, context);
        }

        protected Object visitCurrentPath(CurrentPath node, Object context) {
            FunctionCall function = BuiltinFunctionCallBuilder.resolve(ExpressionInterpreter.this.metadata).setName("$current_path").build();
            return this.visitFunctionCall(function, context);
        }

        protected Object visitAtTimeZone(AtTimeZone node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object timeZone = this.processWithExceptionHandling(node.getTimeZone(), context);
            if (timeZone == null) {
                return null;
            }
            Type valueType = this.type(node.getValue());
            Type timeZoneType = this.type(node.getTimeZone());
            if (value instanceof Expression || timeZone instanceof Expression) {
                return new AtTimeZone(this.toExpression(value, valueType), this.toExpression(timeZone, timeZoneType));
            }
            if (valueType instanceof TimeType) {
                TimeType type = (TimeType)valueType;
                TimeWithTimeZoneType timeWithTimeZoneType = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)type.getPrecision());
                ResolvedFunction function = ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$at_timezone", TypeSignatureProvider.fromTypes(new Type[]{timeWithTimeZoneType, timeZoneType}));
                ResolvedFunction cast = ExpressionInterpreter.this.metadata.getCoercion(valueType, (Type)timeWithTimeZoneType);
                return ExpressionInterpreter.this.functionInvoker.invoke(function, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.this.functionInvoker.invoke(cast, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value)), (Object)timeZone));
            }
            if (valueType instanceof TimeWithTimeZoneType) {
                ResolvedFunction function = ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$at_timezone", TypeSignatureProvider.fromTypes(valueType, timeZoneType));
                return ExpressionInterpreter.this.functionInvoker.invoke(function, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value, (Object)timeZone));
            }
            if (valueType instanceof TimestampType) {
                TimestampType type = (TimestampType)valueType;
                TimestampWithTimeZoneType timestampWithTimeZoneType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)type.getPrecision());
                ResolvedFunction function = ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("at_timezone", TypeSignatureProvider.fromTypes(new Type[]{timestampWithTimeZoneType, timeZoneType}));
                ResolvedFunction cast = ExpressionInterpreter.this.metadata.getCoercion(valueType, (Type)timestampWithTimeZoneType);
                return ExpressionInterpreter.this.functionInvoker.invoke(function, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)ExpressionInterpreter.this.functionInvoker.invoke(cast, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value)), (Object)timeZone));
            }
            if (valueType instanceof TimestampWithTimeZoneType) {
                ResolvedFunction function = ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("at_timezone", TypeSignatureProvider.fromTypes(valueType, timeZoneType));
                return ExpressionInterpreter.this.functionInvoker.invoke(function, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value, (Object)timeZone));
            }
            throw new IllegalArgumentException("Unexpected type: " + valueType);
        }

        protected Object visitCurrentTime(CurrentTime node, Object context) {
            return switch (node.getFunction()) {
                default -> throw new IncompatibleClassChangeError();
                case CurrentTime.Function.DATE -> ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("current_date", (List<TypeSignatureProvider>)ImmutableList.of()), ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of());
                case CurrentTime.Function.TIME -> ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$current_time", TypeSignatureProvider.fromTypes(this.type((Expression)node))), ExpressionInterpreter.this.connectorSession, Collections.singletonList(null));
                case CurrentTime.Function.LOCALTIME -> ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$localtime", TypeSignatureProvider.fromTypes(this.type((Expression)node))), ExpressionInterpreter.this.connectorSession, Collections.singletonList(null));
                case CurrentTime.Function.TIMESTAMP -> ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$current_timestamp", TypeSignatureProvider.fromTypes(this.type((Expression)node))), ExpressionInterpreter.this.connectorSession, Collections.singletonList(null));
                case CurrentTime.Function.LOCALTIMESTAMP -> ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$localtimestamp", TypeSignatureProvider.fromTypes(this.type((Expression)node))), ExpressionInterpreter.this.connectorSession, Collections.singletonList(null));
            };
        }

        protected Object visitRow(Row node, Object context) {
            RowType rowType = (RowType)this.type((Expression)node);
            List parameterTypes = rowType.getTypeParameters();
            List arguments = node.getItems();
            int cardinality = arguments.size();
            ArrayList<Object> values = new ArrayList<Object>(cardinality);
            for (Expression argument : arguments) {
                values.add(this.processWithExceptionHandling(argument, context));
            }
            if (this.hasUnresolvedValue(values)) {
                return new Row(this.toExpressions(values, parameterTypes));
            }
            return RowValueBuilder.buildRowValue((RowType)rowType, fields -> {
                for (int i = 0; i < cardinality; ++i) {
                    TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)((BlockBuilder)fields.get(i)), values.get(i));
                }
            });
        }

        protected Object visitFormat(Format node, Object context) {
            Object format = this.processWithExceptionHandling((Expression)node.getArguments().get(0), context);
            if (format == null) {
                return null;
            }
            List arguments = node.getArguments().subList(1, node.getArguments().size());
            List argumentTypes = (List)arguments.stream().map(this::type).collect(ImmutableList.toImmutableList());
            List<Object> processedArguments = arguments.stream().map(argument -> this.processWithExceptionHandling((Expression)argument, context)).collect(Collectors.toList());
            if (format instanceof Expression || this.hasUnresolvedValue(processedArguments)) {
                return new Format((List)ImmutableList.builder().add((Object)this.toExpression(format, this.type((Expression)node))).addAll(this.toExpressions(processedArguments, argumentTypes)).build());
            }
            RowType rowType = RowType.anonymous((List)argumentTypes);
            ResolvedFunction function = ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("$format", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR, rowType}));
            SqlRow row = RowValueBuilder.buildRowValue((RowType)rowType, fields -> {
                for (int i = 0; i < arguments.size(); ++i) {
                    TypeUtils.writeNativeValue((Type)((Type)argumentTypes.get(i)), (BlockBuilder)((BlockBuilder)fields.get(i)), processedArguments.get(i));
                }
            });
            return ExpressionInterpreter.this.functionInvoker.invoke(function, ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)format, (Object)row));
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.processWithExceptionHandling(node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.processWithExceptionHandling(node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (index instanceof Long && ExpressionInterpreter.isArray(this.type(node.getBase()))) {
                ArraySubscriptOperator.checkArrayIndex((Long)index);
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(this.toExpression(base, this.type(node.getBase())), this.toExpression(index, this.type(node.getIndex())));
            }
            if (base instanceof SqlRow) {
                SqlRow row = (SqlRow)base;
                int fieldIndex = Math.toIntExact((Long)index - 1L);
                if (fieldIndex < 0 || fieldIndex >= row.getFieldCount()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "ROW index out of bounds: " + (fieldIndex + 1));
                }
                Type returnType = (Type)this.type(node.getBase()).getTypeParameters().get(fieldIndex);
                return TypeUtils.readNativeValue((Type)returnType, (Block)row.getRawFieldBlock(fieldIndex), (int)row.getRawIndex());
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        protected Object visitExtract(Extract node, Object context) {
            Object value = this.processWithExceptionHandling(node.getExpression(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new Extract(this.toExpression(value, this.type((Expression)node)), node.getField());
            }
            String name = switch (node.getField()) {
                default -> throw new IncompatibleClassChangeError();
                case Extract.Field.YEAR -> "year";
                case Extract.Field.QUARTER -> "quarter";
                case Extract.Field.MONTH -> "month";
                case Extract.Field.WEEK -> "week";
                case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> "day";
                case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> "day_of_week";
                case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> "day_of_year";
                case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> "year_of_week";
                case Extract.Field.HOUR -> "hour";
                case Extract.Field.MINUTE -> "minute";
                case Extract.Field.SECOND -> "second";
                case Extract.Field.TIMEZONE_MINUTE -> "timezone_minute";
                case Extract.Field.TIMEZONE_HOUR -> "timezone_hour";
            };
            return ExpressionInterpreter.this.functionInvoker.invoke(ExpressionInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes(this.type(node.getExpression()))), ExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value));
        }

        protected Object visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Object context) {
            if (!this.optimize) {
                throw new UnsupportedOperationException("QuantifiedComparison not yet implemented");
            }
            return node;
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        protected Object visitNode(Node node, Object context) {
            throw new UnsupportedOperationException("Evaluator visitor can only handle Expression nodes");
        }

        private List<Type> types(Expression ... expressions) {
            return (List)Stream.of(expressions).map(NodeRef::of).map(ExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private List<Type> types(List<Expression> expressions) {
            return (List)expressions.stream().map(NodeRef::of).map(ExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(Predicates.instanceOf(Expression.class));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            ResolvedFunction operator = ExpressionInterpreter.this.metadata.resolveOperator(operatorType, argumentTypes);
            return ExpressionInterpreter.this.functionInvoker.invoke(operator, ExpressionInterpreter.this.connectorSession, argumentValues);
        }

        private Expression toExpression(Object base, Type type) {
            return ExpressionInterpreter.this.literalEncoder.toExpression(base, type);
        }

        private List<Expression> toExpressions(List<Object> values, List<Type> types) {
            return ExpressionInterpreter.this.literalEncoder.toExpressions(values, types);
        }
    }

    private static class NoPagePositionContext
    implements PagePositionContext {
        private NoPagePositionContext() {
        }

        @Override
        public Block getBlock(int channel) {
            throw new IllegalArgumentException("Context does not contain any blocks");
        }

        @Override
        public int getPosition(int channel) {
            throw new IllegalArgumentException("Context does not have a position");
        }
    }

    private static class LambdaSymbolResolver
    implements SymbolResolver {
        private final Map<String, Object> values;

        public LambdaSymbolResolver(Map<String, Object> values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @Override
        public Object getValue(Symbol symbol) {
            Preconditions.checkState((boolean)this.values.containsKey(symbol.getName()), (String)"values does not contain %s", (Object)symbol);
            return this.values.get(symbol.getName());
        }
    }

    private static interface PagePositionContext {
        public Block getBlock(int var1);

        public int getPosition(int var1);
    }
}

