/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.Map;
import java.util.Objects;

public final class ResolvedFunctionCallRewriter {
    private ResolvedFunctionCallRewriter() {
    }

    public static Expression rewriteResolvedFunctions(Expression expression, Map<NodeRef<Expression>, ResolvedFunction> resolvedFunctions) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(resolvedFunctions), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, ResolvedFunction> resolvedFunctions;

        public Visitor(Map<NodeRef<Expression>, ResolvedFunction> resolvedFunctions) {
            this.resolvedFunctions = Objects.requireNonNull(resolvedFunctions, "resolvedFunctions is null");
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ResolvedFunction resolvedFunction = this.resolvedFunctions.get(NodeRef.of((Node)node));
            Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
            FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
            return new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getProcessingMode(), rewritten.getArguments());
        }
    }
}

