/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.util.AstUtils;
import java.util.Objects;
import java.util.OptionalInt;

public class ScopeAware<T extends Node> {
    private final Analysis analysis;
    private final Scope queryScope;
    private final T node;
    private final int hash;

    private ScopeAware(Analysis analysis, Scope scope, T node) {
        Objects.requireNonNull(scope, "scope is null");
        this.queryScope = scope.getQueryBoundaryScope();
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.node = (Node)Objects.requireNonNull(node, "node is null");
        this.hash = AstUtils.treeHash(node, this::scopeAwareHash);
    }

    public static <T extends Node> ScopeAware<T> scopeAwareKey(T node, Analysis analysis, Scope scope) {
        return new ScopeAware<T>(analysis, scope, node);
    }

    public T getNode() {
        return this.node;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeAware other = (ScopeAware)o;
        Preconditions.checkArgument((this.queryScope == other.queryScope ? 1 : 0) != 0, (Object)"Expressions must be in the same local scope");
        return AstUtils.treeEqual(this.node, other.node, this::scopeAwareComparison);
    }

    public String toString() {
        return "ScopeAware(" + this.node + ")";
    }

    private Boolean scopeAwareComparison(Node left, Node right) {
        if (left instanceof Expression) {
            Expression leftExpression = (Expression)left;
            if (right instanceof Expression) {
                Expression rightExpression = (Expression)right;
                if (this.analysis.isColumnReference(leftExpression) && this.analysis.isColumnReference(rightExpression)) {
                    ResolvedField leftField = this.analysis.getResolvedField(leftExpression);
                    ResolvedField rightField = this.analysis.getResolvedField(rightExpression);
                    boolean leftFieldInSubqueryScope = leftField.getScope().hasOuterParent(this.queryScope);
                    boolean rightFieldInSubqueryScope = rightField.getScope().hasOuterParent(this.queryScope);
                    if (leftFieldInSubqueryScope && rightFieldInSubqueryScope) {
                        return AstUtils.treeEqual((Node)leftExpression, (Node)rightExpression, CanonicalizationAware::canonicalizationAwareComparison);
                    }
                    if (!leftFieldInSubqueryScope && !rightFieldInSubqueryScope) {
                        return leftField.getFieldId().equals(rightField.getFieldId());
                    }
                    return false;
                }
                if (leftExpression instanceof Identifier && rightExpression instanceof Identifier) {
                    return AstUtils.treeEqual((Node)leftExpression, (Node)rightExpression, CanonicalizationAware::canonicalizationAwareComparison);
                }
            }
        }
        if (!left.shallowEquals(right)) {
            return false;
        }
        return null;
    }

    private OptionalInt scopeAwareHash(Node node) {
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            if (this.analysis.isColumnReference(expression)) {
                ResolvedField field = this.analysis.getResolvedField(expression);
                Scope resolvedScope = field.getScope();
                if (resolvedScope.hasOuterParent(this.queryScope)) {
                    return OptionalInt.of(AstUtils.treeHash((Node)expression, CanonicalizationAware::canonicalizationAwareHash));
                }
                return OptionalInt.of(field.getFieldId().hashCode());
            }
            if (expression instanceof Identifier) {
                return OptionalInt.of(AstUtils.treeHash((Node)expression, CanonicalizationAware::canonicalizationAwareHash));
            }
            if (node.getChildren().isEmpty()) {
                return OptionalInt.of(expression.hashCode());
            }
        }
        return OptionalInt.empty();
    }
}

